#!/bin/bash

# -------------------------------------------------
# NOTE: Typical Bash Script running on host machine
# -------------------------------------------------

# HACK For debug
cd /home/koraty/Documenti/master_thesis/vagrant/

# HERE Sourcing
source logging.sh
source variables.sh
source utils.sh
# -------------------------------------------------
# -------------------------------------------------
# HERE: Beginning of script
# -------------------------------------------------
# -------------------------------------------------

# Initialize error count
ERROR_COUNT=0

# Usage: verify_conf_file.sh <remote_host> <function> <args_list>
REMOTE_HOST=$1
FUNCTION=$2
ARGS_LIST=("${@:3}")  # Capture all arguments starting from the 3rd argument onward

# Convert the array to a space-separated string if arguments are provided
if [ ${#ARGS_LIST[@]} -gt 0 ]; then
    ARGS_STRING=$(printf "%s " "${ARGS_LIST[@]}")
else
    ARGS_STRING=""  # No arguments, so ARGS_STRING is empty
fi

# Debug logs
log $DEBUG_LEVEL $VERBOSE_DEBUG "Starting verification script"
log $DEBUG_LEVEL $VERBOSE_DEBUG "Remote host: $REMOTE_HOST"
log $DEBUG_LEVEL $VERBOSE_DEBUG "Function to run: $FUNCTION"
log $DEBUG_LEVEL $VERBOSE_DEBUG "Arguments list: ${ARGS_LIST[*]}"
log $DEBUG_LEVEL $VERBOSE_DEBUG "Arguments string: $ARGS_STRING"

# Check if the function is reachable as a shell function
if command -v $FUNCTION >/dev/null 2>&1; then
    # Execute the shell function remotely with the arguments (if any)
    if [ -z "$ARGS_STRING" ]; then
        # If no arguments, run the function without arguments
        if ! ssh "root@$REMOTE_HOST" "source $PATH_TO_SOURCER && $FUNCTION"; then
            log $DEBUG_LEVEL $VERBOSE_ERROR "SSH connection failed or function execution failed for node $REMOTE_HOST. Operation aborted."
            exit 1
        fi
    else
        # Run the function with arguments
        if ! ssh "root@$REMOTE_HOST" "source $PATH_TO_SOURCER && $FUNCTION $ARGS_STRING"; then
            log $DEBUG_LEVEL $VERBOSE_ERROR "SSH connection failed or function execution failed for node $REMOTE_HOST. Operation aborted."
            exit 1
        fi
    fi
else
    # Assume it's a Python function and run it
    FUNCTION_MODULE=$MODULE_TO_UTILS
    if [ -z "$ARGS_STRING" ]; then
        # If no arguments, run the Python function without arguments
        if ! ssh "root@$REMOTE_HOST" "python3 -c 'import sys; sys.path.insert(0, \"${PATH_TO_PYTHON_SCRIPTS}\"); from ${FUNCTION_MODULE} import ${FUNCTION} ; ${FUNCTION}()'"; then
            log $DEBUG_LEVEL $VERBOSE_ERROR "SSH connection failed or function execution failed for node $REMOTE_HOST. Operation aborted."
            exit 1
        fi
    else
        # Run the Python function with arguments
        if ! ssh "root@$REMOTE_HOST" "python3 -c 'import sys; sys.path.insert(0, \"${PATH_TO_PYTHON_SCRIPTS}\"); from ${FUNCTION_MODULE} import ${FUNCTION} ; ${FUNCTION}(\"${ARGS_STRING}\")'"; then
            log $DEBUG_LEVEL $VERBOSE_ERROR "SSH connection failed or function execution failed for node $REMOTE_HOST. Operation aborted."
            exit 1
        fi
    fi
fi
