import pandas as pd
from agents_elements.agent_types.manager.manager import Manager
from agents_elements.agent_types.defender.defender import Defender

from variables import PATH_TO_OSSEC_AGENT_BASE_MANAGER,PATH_TO_OSSEC_AGENT_TEST_MANAGER
import os
from utils import save_hierarchy_to_file
# -------------------- CONFIGURATION --------------------
# Paths and Configurations
PATH_TO_MODIFIED_OSSEC = "wazuh_library/conf_files/ossec_config_modified.conf"

if __name__ == '__main__':

    """
    Scenario: Defender downloads the script, Manager adds the new rule, Defender downloads the script again and active response is released
    """
    # Fake malware script content readed by the LLM/ Evaluator
    fake_malware_script = """
    #!/bin/bash

    # Fake malware script
    echo "This is a fake malware script!"

    # Simulate malicious behavior (e.g., creating a suspicious file)
    echo "Creating a suspicious file..."
    touch /tmp/suspicious_file

    # Simulate network activity (e.g., pinging a non-existent domain)
    echo "Simulating network activity..."
    ping -c 4 nonexistentdomain.com

    # Simulate modifying a system file (e.g., appending to /etc/hosts)
    echo "Simulating modification of a system file..."
    echo "127.0.0.1 fake.malware.domain" >> /etc/hosts

    # Simulate executing a suspicious command
    echo "Simulating execution of a suspicious command..."
    echo "Suspicious command executed"
    """

    # Set provided by the LLM in response to the downloaded file#


    active_response_to_add = """
    <active-response>
        <command>isolate_infected_system</command>
        <location>local</location>
        <rules_id>100003</rules_id>
    </active-response>

"""
    local_rules_to_add = """

    <group name="yara,malware">
        <rule id="100003" level="10">
            <decoder>yara</decoder>
            <options>no_full_log</options>
            <match>yara.rule=DetectFakeMalware</match>
            <description>Fake malware detected by YARA rule</description>
            <group>yara,malware</group>
        </rule>
    </group>

"""

    # Header provided by an LLM
    new_yara_rule = """
    rule DetectFakeMalware
{
    meta:
        description = "Rule to detect the fake malware script"
        author = "Your Name"
        date = "2023-10-01"

    strings:
        $malware_string1 = "This is a fake malware script!"
        $malware_string2 = "Creating a suspicious file..."
        $malware_string3 = "Simulating network activity..."
        $malware_string4 = "Simulating modification of a system file..."
        $malware_string5 = "Simulating execution of a suspicious command..."

    condition:
        any of ($malware_string*)
}
"""


    # -------------------- INITIALIZATION --------------------
    # Go to the right directory 
    os.chdir('vagrant/src')
    # Manager Instance
    manager = Manager(name='wazidx1', ip_address='192.168.56.13')

    #Defender Instance
    defender = Defender(name='wazagent1', ip_address='192.168.56.14')

    # Step 1: Defender downloads the fake malware script
    print("Defender downloading the fake malware script...")
    
    # Install YARA on the remote host
    bash_script_name = 'copy_malware.sh'
    defender.run_bash_script_on_remote_host(bash_script_name)


    # Step 2: Manager adds the new YARA rule
    print("Manager adding the new YARA rule provided by the LLM...")
    manager.add_yara_signature(new_yara_rule)
    
    # Step 3: Manager updates the ossec.conf and local_rules.xml
    print("Manager updating ossec.conf and local_rules.xml...")
    manager.add_section_tag_to_conf_file(active_response_to_add)
    manager.add_group_to_xml(local_rules_to_add)

    # Step 4: Defender downloads the script again
    
    # Install YARA on the remote host
    bash_script_name = 'copy_malware.sh'
    defender.run_bash_script_on_remote_host(bash_script_name)


    # Step 5: Check if the associated rules entered into action
    print("Checking if the associated rules entered into action...")
    assert(manager.check_alerts('100300'), True)
