#!/bin/bash
# Wazuh - Malware Downloader for test purposes
# Copyright (C) 2015-2022, Wazuh Inc.
#
# This program is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License (version 2) as published by the FSF - Free Software
# Foundation.
# Source the variables.sh file to get environment variables, including DEBUG_LEVEL
cd /vagrant
source variables.sh
source logging.sh  # Assuming the logging function is defined here

DOWNLOAD_DIR=$PATH_TO_YARA_MALWARE_DIR
rm -rf "$DOWNLOAD_DIR"/*

# Create the directory if it doesn't exist
mkdir -p "$DOWNLOAD_DIR"

function fetch_sample(){
  curl -s -XGET "$1" -o "$2"
}

echo "WARNING: Downloading Malware samples, please use this script with caution."

# Mirai
echo "# Mirai: https://en.wikipedia.org/wiki/Mirai_(malware)"
echo "Downloading malware sample..."
fetch_sample "https://wazuh-demo.s3-us-west-1.amazonaws.com/mirai" "$DOWNLOAD_DIR/mirai" && echo "Done!" || echo "Error while downloading."


# Xbash
echo "# Xbash: https://unit42.paloaltonetworks.com/unit42-xbash-combines-botnet-ransomware-coinmining-worm-targets-linux-windows/"
echo "Downloading malware sample..."
fetch_sample "https://wazuh-demo.s3-us-west-1.amazonaws.com/xbash" "$DOWNLOAD_DIR/xbash" && echo "Done!" || echo "Error while downloading."


# VPNFilter
echo "# VPNFilter: https://news.sophos.com/en-us/2018/05/24/vpnfilter-botnet-a-sophoslabs-analysis/"
echo "Downloading malware sample..."
fetch_sample "https://wazuh-demo.s3-us-west-1.amazonaws.com/vpn_filter" "$DOWNLOAD_DIR/vpn_filter" && echo "Done!" || echo "Error while downloading."


# Webshell
echo "# WebShell: https://github.com/SecWiki/WebShell-2/blob/master/Php/Worse%20Linux%20Shell.php"
echo "Downloading malware sample..."
fetch_sample "https://wazuh-demo.s3-us-west-1.amazonaws.com/webshell" "$DOWNLOAD_DIR/webshell" && echo "Done!" || echo "Error while downloading."


