#!/bin/bash

# Define the destination directory
cd /vagrant
source variables.sh
source logging.sh  # Assuming the logging function is defined here

DOWNLOAD_DIR=$PATH_TO_YARA_MALWARE_DIR
# Create the destination directory if it does not exist
mkdir -p "$DOWNLOAD_DIR"

# Define the malicious script content
MALICIOUS_SCRIPT_CONTENT=$(cat << 'EOF'
#!/bin/bash

# Fake malware script
echo "This is a fake malware script!"

# Simulate malicious behavior (e.g., creating a suspicious file)
echo "Creating a suspicious file..."
touch /tmp/suspicious_file

# Simulate network activity (e.g., pinging a non-existent domain)
echo "Simulating network activity..."
ping -c 4 nonexistentdomain.com

# Simulate modifying a system file (e.g., appending to /etc/hosts)
echo "Simulating modification of a system file..."
echo "127.0.0.1 fake.malware.domain" >> /etc/hosts

# Simulate executing a suspicious command
echo "Simulating execution of a suspicious command..."
echo "Suspicious command executed"
EOF
)

# Define the path to the malicious script
MALICIOUS_SCRIPT_PATH="$DOWNLOAD_DIR/fake_malware.sh"

# Write the malicious script content to the file
echo "$MALICIOUS_SCRIPT_CONTENT" > "$MALICIOUS_SCRIPT_PATH"

# Make the malicious script executable
chmod +x "$MALICIOUS_SCRIPT_PATH"

# Print a confirmation message
echo "Malicious script copied to $MALICIOUS_SCRIPT_PATH"
