# HERE import every common classes to every agents
from utils import load_classes_from_relative_dir
import variables
from .fim import Fim
from .yara import Yara
# INFO Add the current directory to sys.path for resolving modules
# INFO Please add every subclasses in the Vmagent arguments (ie Fim, Yara ect...) 
#current_dir = os.path.dirname(__file__)
PATH_RELATIVE_COMMON_FOLDER = "vmagent"

# Load classes dynamically
base_classes = tuple(load_classes_from_relative_dir(__file__))

# Define the Vmagent class dynamically
#class Vmagent(*base_classes):
#HACK Use directly names of class for automatic completion.
class Vmagent(Fim,Yara):

    """
    Vmagent element: 
        - Instance of Agents class (set of Vmagent)
        - Daughter of remote
        - Mother class of Vmagent types : Attacker, Defender,Manager
        - Inherits from common features to every Vmagent in vmagent_common folder.
        - Associated to a virtual machine

    """

    def __init__(self, **kwargs):
        """
        Initialize the Vmagent class.
        NOTE Every features should be common to every agents Manager/Defender/Attacker

        Args:
            **kwargs: Additional keyword arguments to pass to the superclass.
        """
        self.agent_type = kwargs['category']
        self.name = kwargs['name']

        # HERE CREATE COMMON ATTRIBUTES RELATIVE TO PATH 

        remote_name,VM_conf_path = self._create_remote_attributes()
        
        ossec_conf_path,base_conf_path = self._create_ossec_conf_attributes()

        # TODO log attributes after cron job : alert_log_file_path
        # TOHAVE Dynamica argument parsing
        super().__init__(remote_name = remote_name, VM_conf_path = VM_conf_path, ossec_conf_path = ossec_conf_path, base_conf_path = base_conf_path,**kwargs)


    def _create_remote_attributes(self):
        """
        Dynamically create an instance of the Remote class based on the self.agent_type.
        NOTE : By default remote_name of the VM is the name of the agent
        """
        VM_conf_path = getattr(variables, f"PATH_TO_VM_OSSEC_AGENT_{self.agent_type.upper()}")

        remote_name = self.name

        return remote_name,VM_conf_path
    
        
    def _create_ossec_conf_attributes(self):
        """
        Dynamically create an instance of the Ossec_conf class based on the self.agent_type.
        """

        ossec_conf_path = getattr(variables, f"PATH_TO_OSSEC_AGENT_{self.agent_type.upper()}")

        base_conf_path = getattr(variables, f"PATH_TO_OSSEC_AGENT_BASE_{self.agent_type.upper()}")

        return ossec_conf_path,base_conf_path
    


    