
import time
from utils import simulate_file_change,test_who_data,configure_audit,manage_ip_in_hosts_allow

# HERE Common classes to every VM agents
from agents_elements.vmagents.log import Log
from agents_elements.vmagents.ossec_conf import Ossec_conf

class Fim(Log,Ossec_conf):
    """
    FIM (File Integrity Monitoring) Vmagent class that inherits from Agents.
    - Common to every vmagents
    """

    
    def __init__(self, **kwargs):
        """
        Initialize the Fim class.

        Args:
            **kwargs: Additional keyword arguments to pass to the superclass.
        """
        super().__init__(**kwargs)

    def simulate_file_change(self, monitored_path: str):
        """
        Simulate a file change in the monitored directory and check for alerts.

        Args:
            monitored_path (str): Path of the directory to monitor.
        """
        return self.run_function_on_remote_host(simulate_file_change,[monitored_path])

    def test_who_data(self):
        """
        Test the configuration to ensure that the alert is raised.
        
        NOTE: 
            - To ensure that audit, is reavealed you need to modify a file via the user, not just log in.
            - To run on the defender
        """
       
        # Ensure audit is configured
        return self.run_function_on_remote_host(test_who_data)
       

    def configure_audit(self):
        """
        Configure audit to ensure it is not disabled by default and key rules are in place.
        [Doc]: https://documentation.wazuh.com/current/user-manual/capabilities/file-integrity/advanced-settings.html

        NOTE: 
            - To run on defender
        """
        return self.run_function_on_remote_host('configure_audit')

    def manage_ip_in_hosts_allow(self, ip_address: str):
        """
        Ensures the given IP address is rewritten in /etc/hosts.allow.
        Any existing occurrences of the IP address are removed, and the IP is added anew.

        Args:
            ip_address (str): The IP address to add or update.
        NOTE: 
            Run it on manager
        """
        
        return self.run_function_on_remote_host(manage_ip_in_hosts_allow,[ip_address])
