#!/bin/bash
# To be used only for VM
cd /vagrant/

# Source the logging.sh file from the home directory
if [ -f "logging.sh" ]; then
  echo "Sourcing logging.sh from logging.sh"
  source logging.sh
else
  echo "Error: logging.sh not found in /vagrant"
  exit 1
fi

# Source the utils.sh file from the home directory
if [ -f "utils.sh" ]; then
  echo "Sourcing utils.sh from utils.sh"
  source utils.sh
else
  echo "Error: utils.sh not found in /vagrant"
  exit 1
fi

# Function to source a file and log the action
source_file() {
  local file_path=$1
  if [ -f "$file_path" ]; then
    log $DEBUG_LEVEL $VERBOSE_DEBUG "Sourcing $file_path"
    source "$file_path"
  else
    log $DEBUG_LEVEL $VERBOSE_ERROR "Error: $file_path not found"
    exit 1
  fi
}

# Source additional files specified as arguments
if [ $# -gt 0 ]; then
  for arg in "$@"; do
    if [ "$arg" == "*" ]; then
      # Source every file in the /vagrant directory
      for file in *.sh; do
        source_file "$file"
      done
    else
      source_file "$arg"
    fi
  done
fi

# ## Example usage ##
# # Source the sourcer.sh file with specific arguments
# source /vagrant/sourcer.sh variables.sh another_script.sh
# # Source every source files
# source /vagrant/sourcer.sh *
# # Source only the default source files
# source /vagrant/sourcer.sh