#!/usr/bin/bash
#TOHAVE Automatizing program description : TAG DESCRIPTION
# Define verbosity levels
VERBOSE_INFO=1
VERBOSE_DEBUG=3
VERBOSE_WARNING=2
VERBOSE_ERROR=4

# Set the default debugging level
export DEBUG_LEVEL=$VERBOSE_DEBUG  # Change this to VERBOSE_INFO, VERBOSE_WARNING, or VERBOSE_ERROR as needed

# Define the log function
log() {
  local DEBUG_LEVEL=$1
  local verbose_type=$2
  local message=$3
  local timestamp=$(date +"%Y-%m-%d %H:%M:%S")

  # Always log errors
  if [ $verbose_type -eq $VERBOSE_ERROR ]; then
    echo "[$timestamp] ERROR: $message"
    if [ -n "$LOG_FILE" ]; then
      echo "[$timestamp] ERROR: $message" >> "$LOG_FILE"
    fi
  elif [ $DEBUG_LEVEL -ge $verbose_type ]; then
    case $verbose_type in
      $VERBOSE_DEBUG)
        echo "[$timestamp] DEBUG: $message"
       
        ;;
      $VERBOSE_INFO)
        echo "[$timestamp] INFO: $message"
       
        ;;
      $VERBOSE_WARNING)
        echo "[$timestamp] WARNING: $message"
        if [ -n "$LOG_FILE" ]; then
          echo "[$timestamp] WARNING: $message" >> "$LOG_FILE"
        fi
        ;;
      *)
        echo "[$timestamp] UNKNOWN: $message"
        if [ -n "$LOG_FILE" ]; then
          echo "[$timestamp] UNKNOWN: $message" >> "$LOG_FILE"
        fi
        ;;
    esac
  fi
}

# Define log directory
# INFO Always absolute path ! Start with /
LOG_DIR="/vagrant/log"

# Check if the log directory exists
if [ ! -d "$LOG_DIR" ]; then
    # If it doesn't exist, create the log directory
    sudo mkdir -p "$LOG_DIR"
    sudo chmod 755 "$LOG_DIR"  # Adjust permissions as necessary
    log $DEBUG_LEVEL $VERBOSE_INFO "Log directory created at $LOG_DIR"
else
    log $DEBUG_LEVEL $VERBOSE_INFO "Check for logs in  $LOG_DIR"
fi

## HERE Default logs ##
VM_hostname=$(hostname)
Current_dir=$(pwd)
log $DEBUG_LEVEL $VERBOSE_DEBUG "Current directory: $Current_dir"
log $DEBUG_LEVEL $VERBOSE_DEBUG "Current Machine hostname: $VM_hostname"

# Example usage
# DEBUG_LEVEL=2  # Set the debug level

# log $DEBUG_LEVEL $VERBOSE_DEBUG "This is a debug message"
# log $DEBUG_LEVEL $VERBOSE_INFO "This is an info message"
# log $DEBUG_LEVEL $VERBOSE_WARNING "This is a warning message"
# log $DEBUG_LEVEL $VERBOSE_ERROR "This is an error message"
