#!/bin/bash
# Typical Bash Script running in provisioning machine

# Get the script filename (without the path) for dynamic naming
if [[ -z "$1" ]]; then
  # If no argument is provided, use $0 to get the script name
  SCRIPT_NAME="${0##*/}"
else
  # If an argument is provided, use it as the script name
  SCRIPT_NAME="$1"
fi

BASENAME="${SCRIPT_NAME%.*}"  # Remove the file extension


# Go to root
cd /

# -------------------------------------------------
# HERE: Source necessary variables
# -------------------------------------------------

# This loads the DEBUG_LEVEL and other variables from sourcer.sh and variables.sh
source /vagrant/sourcer.sh variables.sh utils.sh

# -------------------------------------------------
# HERE: Description
# -------------------------------------------------

log $DEBUG_LEVEL $VERBOSE_INFO "Starting script execution: $SCRIPT_NAME"

# HERE: Define paths for logs and backups
LOG_FILE="$PATH_TO_LOG_DIR/${BASENAME}.log"
initialize_log_file "$LOG_FILE"
TIMESTAMP=$(date +%Y%m%d_%H%M%S)  # Timestamp for uniqueness
# Initialize error count
ERROR_COUNT=0

# -------------------------------------------------
# HERE: Beginning of script
# -------------------------------------------------

# Add firewall command 
log $DEBUG_LEVEL $VERBOSE_DEBUG "Checking firewall-drop command in Victim agent..."
add_command "firewall-drop" "firewall-drop" "yes"

# Add an active response on the manager
log $DEBUG_LEVEL $VERBOSE_DEBUG "Adding active response for DVWA attack in Wazuh..."
add_active_response "firewall-drop" "local" "100012,100013,100014" "360"

# Add local rules for DVWA attack
log $DEBUG_LEVEL $VERBOSE_DEBUG "Adding local rules for DVWA attack in Wazuh..."


add_local_rules "$PATH_TO_LOCAL_RULES_TELER"
#AGENT_CONF file still not syncrhonising.
#add_local_file "syslog" $PATH_TO_TELER_LOGS $PATH_TO_SERVER_VICTIM_AGENT_CONF_FILE

#HACK Cron - Job not working..., no point in syncronizing when it is a script already running on the server ....
#synchronize_file $PATH_TO_VICTIM_AGENT_CONF_FILE $PATH_TO_SERVER_VICTIM_AGENT_CONF_FILE

# End of Script
if [ $ERROR_COUNT -eq 0 ]; then
    log $DEBUG_LEVEL $VERBOSE_INFO "$SCRIPT_NAME successfully realized."
else
    log $DEBUG_LEVEL $VERBOSE_INFO "Errors encountered during script execution: $SCRIPT_NAME. Total errors: $ERROR_COUNT"
fi
