#!/bin/bash
# Typical Bash Script running in provisioning machine

# Get the script filename (without the path) for dynamic naming
if [[ -z "$1" ]]; then
  # If no argument is provided, use $0 to get the script name
  SCRIPT_NAME="${0##*/}"
else
  # If an argument is provided, use it as the script name
  SCRIPT_NAME="$1"
fi

BASENAME="${SCRIPT_NAME%.*}"  # Remove the file extension


# Go to root
cd /

# -------------------------------------------------
# HERE: Source necessary variables
# -------------------------------------------------

# This loads the DEBUG_LEVEL and other variables from sourcer.sh and variables.sh
source /vagrant/sourcer.sh variables.sh

# -------------------------------------------------
# HERE: Description
# -------------------------------------------------

log $DEBUG_LEVEL $VERBOSE_INFO "Starting script execution: $SCRIPT_NAME"

# HERE: Define paths for logs and backups
LOG_FILE="$PATH_TO_LOG_DIR/${BASENAME}.log"
initialize_log_file "$LOG_FILE"
TIMESTAMP=$(date +%Y%m%d_%H%M%S)  # Timestamp for uniqueness

# Initialize error count
ERROR_COUNT=0

# -------------------------------------------------
# HERE: Beginning of script
# -------------------------------------------------

#
# Activate the firewall-drop command in Wazuh if not already activated
log $DEBUG_LEVEL $VERBOSE_DEBUG "Checking firewall-drop command in Wazuh..."
add_command "firewall-drop" "firewall-drop" "yes"

# Activate the new rule in Wazuh if not already activated
log $DEBUG_LEVEL $VERBOSE_DEBUG "Checking new rule 5763 in Wazuh..."
add_active_response "firewall-drop" "local" "5763" "180"

# Restart Wazuh manager
log $DEBUG_LEVEL $VERBOSE_DEBUG "Restarting manager..."
sudo systemctl restart wazuh-manager

# End of Script
if [ $ERROR_COUNT -eq 0 ]; then
    log $DEBUG_LEVEL $VERBOSE_INFO "Manager script executed successfully: $SCRIPT_NAME"
else
    log $DEBUG_LEVEL $VERBOSE_INFO "Errors encountered during script execution: $SCRIPT_NAME. Total errors: $ERROR_COUNT"
fi
