#!/bin/bash


source logging.sh
source variables.sh
source utils.sh

## DESCRIPTION ##
log $DEBUG_LEVEL $VERBOSE_INFO "Testing ssh connection from the host to the VM..."

# Getting current machine name
# HACK Not implemented for final tests , not needed.
#host_hostname=$(hostname)
host_hostname=root
# Check if NODES is set
if [ -z "$NODES" ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "The NODES variable is not set."
  return 1
else 
  log $DEBUG_LEVEL $VERBOSE_DEBUG "The NODES are : ${NODES[@]}"
fi


# Iterate over each node in NODES
for vm_hostname in ${NODES[@]}; do
  log $DEBUG_LEVEL $VERBOSE_INFO "VM hostname found: $vm_hostname"

  # Test SSH connection from host to VM
  test_ssh_connection "$host_hostname" "$vm_hostname"
done