#!/bin/bash
# Source the sourcer.sh file
source /vagrant/sourcer.sh variables.sh utils.sh

## DESCRIPTION ##
log $DEBUG_LEVEL $VERBOSE_INFO "Testing ssh connection from the VM to the host..."

# Read the keys.txt file to get the hostname
host_hostname=koraty
# Check if NODES is set
if [ -z "$NODES" ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "The NODES variable is not set."
  return 1
else 
  log $DEBUG_LEVEL $VERBOSE_DEBUG "The NODES are : ${NODES[@]}"
fi


# Iterate over each node in NODES
for vm_hostname in ${NODES[@]}; do
  log $DEBUG_LEVEL $VERBOSE_INFO "VM hostname found: $vm_hostname"

  # Test SSH connection from host to VM
  test_ssh_connection "$vm_hostname" "$host_hostname" 
done