#!/bin/bash
# TOHAVE IT is a cron job , you can unify both scripts : cron jobs and logrotation.
# TOTEST
cd /
# Source the logging script if it’s separate, or directly define the log function here
source /vagrant/sourcer.sh variables.sh
# You're in vagrant folder

# Variables
CONF_SOURCE="$PATH_TO_LOGROTATION_FOLDER/config_manager_logrotate.conf"  # Path to the logrotate config file on your system
CONF_DEST=$PATH_TO_LOGROTATION_VM_FOLDER           # Destination path for the logrotate config

# Check if source file exists
if [ -f "$CONF_SOURCE" ]; then
    log $DEBUG_LEVEL $VERBOSE_DEBUG "Source configuration file found. Proceeding with the copy."
else
    log $DEBUG_LEVEL $VERBOSE_ERROR "Source configuration file not found at $CONF_SOURCE."
    return 1
fi

# Copy configuration to the logrotate directory
sudo cp "$CONF_SOURCE" "$CONF_DEST"
if [ $? -eq 0 ]; then
    log $DEBUG_LEVEL $VERBOSE_DEBUG "Logrotate configuration copied successfully to $CONF_DEST."
else
    log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to copy logrotate configuration."
    return 1
fi

# Set permissions
sudo chmod 644 "$CONF_DEST"
if [ $? -eq 0 ]; then
    log $DEBUG_LEVEL $VERBOSE_DEBUG "Permissions set to 644 for $CONF_DEST."
else
    log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to set permissions on $CONF_DEST."
    return 1
fi

# Test logrotate configuration
sudo logrotate --debug "$CONF_DEST"
if [ $? -eq 0 ]; then
    log $DEBUG_LEVEL $VERBOSE_DEBUG "Logrotate configuration verified successfully."
else
    log $DEBUG_LEVEL $VERBOSE_ERROR "Error: Logrotate configuration test failed."
    return 1
fi

log $DEBUG_LEVEL $VERBOSE_DEBUG "Logrotate setup complete."
