#!/bin/bash
# NOTE Check associated log files to ensure each cron jobs are running 
# Always full path in cron jobs!
# TOHAVE DICTIONARY FOR PATH (LOGS)

cd /
# Source the logging script if it’s separate, or directly define the log function here
source /vagrant/sourcer.sh variables.sh
error_occured=0

## DESCRIPTION ##
log $DEBUG_LEVEL $VERBOSE_INFO "Starting cron job setup on $(hostname)"
LOG_FILE="$PATH_TO_LOG_DIR/config_manager.log"

# Print the path of the cron file
log $DEBUG_LEVEL $VERBOSE_DEBUG "Cron file path: $PATH_TO_CRON_FILE"
log $DEBUG_LEVEL $VERBOSE_DEBUG "Contents of $PATH_TO_CRON_FILE explicited in log file" 

# Print the contents of the cron file before modification
if [ -f "$PATH_TO_CRON_FILE" ]; then
    log $DEBUG_LEVEL $VERBOSE_DEBUG "Contents of $PATH_TO_CRON_FILE before modification:" 
    cat "$PATH_TO_CRON_FILE" 
else
    log $DEBUG_LEVEL $VERBOSE_DEBUG "Cron file $PATH_TO_CRON_FILE does not exist, will be created."
fi

if [ -f "$LOG_FILE" ]; then
    sudo rm "$LOG_FILE"
    log $DEBUG_LEVEL $VERBOSE_INFO "Removed old log file $LOG_FILE"
fi

#HERE  Write all cron jobs to the cron job file
sudo tee $PATH_TO_CRON_FILE > /dev/null <<EOF
cd /vagrant/
source sourcer.sh variables.sh
LOG_FILE=$PATH_TO_CRON_JOB_LOGS
# Syncronize agent.confs between host and server
#Victim
check_file_existence $LOG_FILE
* * * * * root inotifywait -m -e modify "$PATH_TO_VICTIM_AGENT_CONF_FILE" | while read; do synchronize_file "$PATH_TO_VICTIM_AGENT_CONF_FILE" "$PATH_TO_SERVER_VICTIM_AGENT_CONF_FILE" >> "$PATH_TO_CRON_JOB_LOGS" 2>&1; done

# Add additional cron jobs here as needed
# SURICATA #
# sudo tee /etc/cron.d/config_customs_rules_update.sh <<EOF
# 0 3 * * * root /vagrant/VM/configs/config_customs_rules_update.sh
EOF


# Print the contents of the cron file after modification
log $DEBUG_LEVEL $VERBOSE_DEBUG "Contents of $PATH_TO_CRON_FILE after modification:" 
cat "$PATH_TO_CRON_FILE" 

if [ $? -eq 0 ]; then
    log $DEBUG_LEVEL $VERBOSE_INFO "Successfully set up cron jobs in $PATH_TO_CRON_FILE" 
else
    log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to write cron jobs to $PATH_TO_CRON_FILE" 
    ((error_occured++))  # Increment the error counter
fi

# Set the correct permissions and log
sudo chmod 644 "$PATH_TO_CRON_FILE"
if [ $? -eq 0 ]; then
    log $DEBUG_LEVEL $VERBOSE_DEBUG "Set permissions on $PATH_TO_CRON_FILE to 644" 
else
    log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to set permissions on $PATH_TO_CRON_FILE" 
    ((error_occured++))  # Increment the error counter
fi

# Restart cron to apply the new jobs and log
sudo systemctl restart cron
if [ $? -eq 0 ]; then
    log $DEBUG_LEVEL $VERBOSE_INFO "Cron service restarted successfully" 
else
    log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to restart cron service" 
    ((error_occured++))  # Increment the error counter
fi

# Log total errors encountered
if [ $error_occured -gt 0 ]; then
    log $DEBUG_LEVEL $VERBOSE_WARNING "Total errors encountered during cron job setup: $error_occured - info at $LOG_FILE"
else
    log $DEBUG_LEVEL $VERBOSE_INFO "Cron job setup completed with no errors. - info at $LOG_FILE"
fi

log $DEBUG_LEVEL $VERBOSE_INFO "Cron job setup completed on $(hostname)"
