#!/usr/bin/bash

#TOTEST saving API credentials
#TODO Add an auto_update to the conf file and agent file
#TODO modify analysisd.decoder to 1024 in local_internal_options.conf : https://documentation.wazuh.com/current/user-manual/reference/internal-options.html#analysisd

# Change the working directory to the root directory
cd /

# Source the sourcer.sh file with specific arguments
source /vagrant/sourcer.sh variables.sh

# Capture the Wazuh server's IP address | use the private network IP address (the second one)
WAZUH_SERVER_SSH_IP=$(hostname -i | awk '{print $1}') # SSH address used for SSH connection
MANAGER_IP=$(hostname -i | awk '{print $2}')

# Log the values of the variables for debugging
log $DEBUG_LEVEL $VERBOSE_INFO "WAZUH_SERVER_SSH_IP: $WAZUH_SERVER_SSH_IP"
log $DEBUG_LEVEL $VERBOSE_INFO "PATH_TO_CREDENTIALS: $PATH_TO_CREDENTIALS"

echo "Node: $(hostname) - IP: $MANAGER_IP - SSH_IP:$WAZUH_SERVER_SSH_IP" >> $PATH_TO_CREDENTIALS

# WAZUH_INDEXER_IP, WAZUH_DASHBOARD_IP, and any other IPs can similarly be extracted from credentials.txt if needed.
WAZUH_INDEXER_IP=$MANAGER_IP
WAZUH_DASHBOARD_IP=$MANAGER_IP

# Log the values of the variables for debugging
log $DEBUG_LEVEL $VERBOSE_INFO "WAZUH_INDEXER_IP: $WAZUH_INDEXER_IP"
log $DEBUG_LEVEL $VERBOSE_INFO "WAZUH_DASHBOARD_IP: $WAZUH_DASHBOARD_IP"

# Download the installation script and config file
curl -sO $WAZUH_MANAGER_INSTALL_SCRIPT_URL
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to download the installation script from $WAZUH_MANAGER_INSTALL_SCRIPT_URL"
  exit 1
fi

curl -sO $WAZUH_MANAGER_CONFIG_SCRIPT_URL
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to download the config script from $WAZUH_MANAGER_CONFIG_SCRIPT_URL"
  exit 1
fi

# Ensure that SSH server is configured to accept public key authentication
sudo sed -i '/^#\?PubkeyAuthentication /c\PubkeyAuthentication yes' /etc/ssh/sshd_config
sudo sed -i '/^#\?AuthorizedKeysFile /c\AuthorizedKeysFile .ssh/authorized_keys' /etc/ssh/sshd_config

# Restart the SSH service to apply changes
sudo systemctl restart sshd
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to restart the SSH service"
  exit 1
fi

# Create a new config.yml file with dynamic IP addresses using echo
echo 'nodes:
  # Wazuh indexer nodes
  indexer:
    - name: $MANAGER_NAME
      ip: "'"$WAZUH_INDEXER_IP"'"

  server:
    - name: $MANAGER_NAME
      ip: "'"$MANAGER_IP"'"

  # Wazuh dashboard nodes
  dashboard:
    - name: $MANAGER_NAME
      ip: "'"$WAZUH_DASHBOARD_IP"'"
' > config.yml

# Run the Wazuh installation script to generate config files
bash wazuh-install.sh --generate-config-files
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to generate config files"
  exit 1
fi

# Install the specified version of Wazuh
bash wazuh-install.sh --wazuh-indexer $MANAGER_NAME
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to install Wazuh indexer"
  exit 1
fi

# Start the Wazuh cluster
bash wazuh-install.sh --start-cluster
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to start the Wazuh cluster"
  exit 1
fi

# Extract the Wazuh dashboard admin passwords and save them
tar -axf wazuh-install-files.tar wazuh-install-files/wazuh-passwords.txt -O | grep -P "\'admin\'" -A 1 >> $PATH_TO_CREDENTIALS
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to extract Wazuh dashboard admin passwords"
  return
fi

# Extract the Wazuh API admin passwords and save them
tar -axf wazuh-install-files.tar wazuh-install-files/wazuh-passwords.txt -O | grep -P "\'wazuh\'" -A 1 >> $PATH_TO_CREDENTIALS
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to extract Wazuh API admin passwords"
  return
fi

# Set the Wazuh server
bash wazuh-install.sh --wazuh-server $MANAGER_NAME
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to set the Wazuh server"
  exit 1
fi

# Set the Wazuh dashboard
bash wazuh-install.sh --wazuh-dashboard $MANAGER_NAME
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to set the Wazuh dashboard"
  exit 1
fi

# Remove installer files here:
rm -f wazuh-install.sh wazuh-install-files.tar

# Restart the Wazuh dashboard service
sudo systemctl restart wazuh-dashboard
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to restart the Wazuh dashboard service"
  exit 1
fi

#TOTEST
# Copy the files.yml from the host to the Wazuh manager
# If using a shared folder via Vagrant, the file is already accessible within /vagrant
sudo cp /vagrant/VM/configs/manager/yml/files.yml /var/ossec/etc/shared/
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to copy files.yml to /var/ossec/etc/shared/"
  return
fi

sudo chmod 640 /var/ossec/etc/shared/files.yml
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL $VERBOSE_ERROR "Failed to change permissions of files.yml"
  return
fi
