#!/usr/bin/bash

# Change the working directory to the vagrant directory
cd /

# Source the sourcer.sh file with specific arguments
source /vagrant/sourcer.sh variables.sh

# Ensure that SSH agent is configured to accept public key authentication
sudo sed -i '/^#\?PubkeyAuthentication /c\PubkeyAuthentication yes' /etc/ssh/sshd_config
sudo sed -i '/^#\?AuthorizedKeysFile /c\AuthorizedKeysFile .ssh/authorized_keys' /etc/ssh/sshd_config

# Capture the Wazuh agent's IP address
WAZUH_AGENT_SSH_IP=$(hostname -i | awk '{print $1}') # SSH address used for SSH connection
WAZUH_AGENT_IP=$(hostname -i | awk '{print $2}') # Private network IP address used for VM

# Log the values of the variables for debugging
log $DEBUG_LEVEL $VERBOSE_INFO "WAZUH_AGENT_SSH_IP: $WAZUH_AGENT_SSH_IP"
log $DEBUG_LEVEL $VERBOSE_INFO "WAZUH_AGENT_IP: $WAZUH_AGENT_IP"

echo "Node: $(hostname) - IP: $WAZUH_AGENT_IP - SSH_IP:$WAZUH_AGENT_SSH_IP" >> $PATH_TO_CREDENTIALS

## DRAFT dynamic port allocation ##

# # Capture the SSH port from the sshd_config file
# WAZUH_AGENT_SSH_PORT=$(grep "^Port" /etc/ssh/sshd_config | awk '{print $2}') # Retrieve the SSH port

# # Append the information to the credentials file
# echo "Node: $(hostname) - IP: $WAZUH_AGENT_IP - SSH_IP:$WAZUH_AGENT_SSH_IP - SSH_Port:$WAZUH_AGENT_SSH_PORT" >> $PATH_TO_CREDENTIALS
## END ##

# Retrieve the Wazuh server IP from the credentials file
MANAGER_IP=$(grep "Node: $MANAGER_NAME" $PATH_TO_CREDENTIALS | awk '{print $5}')

# Log the retrieved Wazuh server IP for debugging
log $DEBUG_LEVEL $VERBOSE_INFO "Wazuh Server IP: $MANAGER_IP"

echo "Wazuh Server IP: $MANAGER_IP"

# Add echo statement for node hostname assignment
echo "Node hostname '$(hostname)' assigned to the following server: '$MANAGER_NAME'"

# Add GPG key and repository using the repository URL from the config
curl -s https://packages.wazuh.com/key/GPG-KEY-WAZUH | gpg --no-default-keyring --keyring gnupg-ring:/usr/share/keyrings/wazuh.gpg --import
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL  $VERBOSE_ERROR "Failed to import GPG key"
  exit 1
fi

chmod 644 /usr/share/keyrings/wazuh.gpg
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL  $VERBOSE_ERROR "Failed to set permissions on GPG key"
  exit 1
fi

echo "deb [signed-by=/usr/share/keyrings/wazuh.gpg] $WAZUH_AGENT_REPO_URL stable main" | tee /etc/apt/sources.list.d/wazuh.list
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL  $VERBOSE_ERROR "Failed to add Wazuh repository"
  exit 1
fi

# Update package list
apt-get update
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL  $VERBOSE_ERROR "Failed to update package list"
  return
fi

# Install the Wazuh agent version that matches the manager
# FOR LAST VERSION 
#WAZUH_MANAGER="$MANAGER_IP" apt-get install -y wazuh-agent
# FOR SPECIFIED VERSION
WAZUH_MANAGER="$MANAGER_IP" apt-get install -y wazuh-agent=4.8*
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL  $VERBOSE_ERROR "Failed to install Wazuh agent"
  exit 1
fi

# Enable and start the Wazuh agent service
systemctl daemon-reload
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL  $VERBOSE_ERROR "Failed to reload systemd daemon"
  exit 1
fi

systemctl enable wazuh-agent
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL  $VERBOSE_ERROR "Failed to enable Wazuh agent service"
  exit 1
fi

systemctl start wazuh-agent
if [ $? -ne 0 ]; then
  log $DEBUG_LEVEL  $VERBOSE_ERROR "Failed to start Wazuh agent service"
  exit 1
fi
