#!/usr/bin/bash
###############################################################
#  TITRE: 
#
#  AUTEUR:   Xavier
#  VERSION: 
#  CREATION:  
#  MODIFIE: 
#
#  DESCRIPTION: 
###############################################################



# Variables ###################################################

NODE_EXPORTER_VERSION="1.3.1"

# Functions ###################################################


node_exporter_install(){
sudo useradd -rs /bin/false node_exporter
wget -q https://github.com/prometheus/node_exporter/releases/download/v${NODE_EXPORTER_VERSION}/node_exporter-${NODE_EXPORTER_VERSION}.linux-amd64.tar.gz 2>&1 >/dev/null
tar -xzf node_exporter-${NODE_EXPORTER_VERSION}.linux-amd64.tar.gz 2>&1 >/dev/null
mv node_exporter-${NODE_EXPORTER_VERSION}.linux-amd64/node_exporter /usr/local/bin/
chown node_exporter:node_exporter /usr/local/bin/node_exporter
}


node_exporter_systemd(){
echo "
[Unit]
Description=Node Exporter
After=network-online.target

[Service]
User=node_exporter
Group=node_exporter
Type=simple
ExecStart=/usr/local/bin/node_exporter

[Install]
WantedBy=multi-user.target
" > /etc/systemd/system/node_exporter.service
}


node_exporter_restart(){
systemctl daemon-reload
systemctl enable node_exporter
systemctl restart node_exporter
}

# Let's Go !! #################################################
if ! id "node_exporter" &>/dev/null; then
	node_exporter_install
	node_exporter_systemd
	node_exporter_restart
fi
