# Project Progress - Update

**Date**: December 10, 2024

## Overview

The multi-agent system project is progressing with the setup of various agents for cybersecurity simulations, including Attacker, Defender, Evaluator, and Manager. The architecture is organized to handle logs, commands, and various integrations.

### Current Architecture

- **agents/**  
  Core agent classes for Attacker, Defender, Evaluator, and Manager.  
  Includes specialized modules for error handling and logging within each agent's context.

- **common/**  
  Contains utilities for graph generation, command execution, OSSEC configuration, and LLM integration.

- **integrations/**  
  Integrates with Mininet for network simulation.

- **logs/**  
  Centralized logging directory to track agent actions and system activities.

- **main.py**  
  Main entry point for executing the multi-agent system setup and interaction.

- **typography.py**  
  Provides dynamic logging setup and error tracking across agents.

### Recent Updates

- Completed the setup for logging and error handling across all agent classes using the `Typography` class.
- Added dynamic log rotation and file management.
- Introduced decorators for method logging and error tracking.
- Integrated Mininet simulation for agent interactions.

### Next Steps

- Further refine agent interactions and introduce more specific behaviors for each agent.
- Expand integrations with additional tools for monitoring and network attack simulations.

**Date**: December 12, 2024

### Updated `Agents` Class

1. **Class Initialization**:
   - The `Agents` class now correctly initializes with `name`, `ip_address`, `category`, `max_bytes`, and `backup_count`.
   - The `category` attribute holds the dynamically created instance of the corresponding class based on the category.
   - The `instance` attribute holds the category name as a string.

2. **Dynamic Instance Creation**:
   - The `_create_instance` method dynamically creates an instance of the corresponding class based on the category.
   - The `_create_ossec_conf_instance` method dynamically creates an instance of the `Ossec_conf` class based on the category.

3. **Instance Registration**:
   - The `_register_instance` class method registers an agent instance with the `Agents` superclass.
   - The `get_instance` class method retrieves an agent instance by category.

4. **Communication Methods**:
   - The `get_evaluator`, `get_attacker`, `get_defender`, `get_manager`, and `get_all_instances` methods allow agents to communicate with each other and retrieve specific agent instances.
   - The `synchronize_with_VM` method synchronizes the configuration file with the VM using the Evaluator agent.
   - The `verify_conf_file_via_bash` method verifies the configuration file consistency via a bash script.
   - The `synchronize_df_with_conf_file` method synchronizes the dataframes with the desired configuration file.
   - The `add_fim_configuration` method adds FIM configuration for a specific path in `ossec.conf`.
   - The `compress_tree` and `compress_xml` methods handle compression of XML tags.
   - The `compress_elements` method compresses elements within a parent based on the tags to compress.

### Updated `Log` Class

1. **Class Initialization**:
   - The `Log` class now correctly initializes with `log_file`, `max_bytes`, and `backup_count`.
   - It sets up logging with the appropriate logging level and handlers.

2. **Logging Methods**:
   - The `check_alerts` method checks the alerts log for the specified rule ID.
   - The `extract_time` method extracts the time part from the timestamp.
   - The `get_rule_id` method retrieves the last log entry for the current date for the provided rule ID.
   - The `check_fim_change` method checks if the specified directory was modified regarding rule ID 550.
   - The `is_time_consistent` method compares the time of the log retrieval and the actual time.
   - The `parse_rule_id` method parses the log file to extract information based on the rule ID.

These updates ensure that the `Agents` class manages all agent instances and facilitates communication between them. The `Log` class handles logging, parsing, and analyzing logs from Wazuh. Both classes now correctly handle the roles of `category` and `instance`, ensuring proper logging and communication between agents.

**Date**:  17/12
Here’s a proposed structure for an `update.md` file based on the new class hierarchy and methods implemented:

---

# Update: Class Hierarchy and New Methods

## Overview

This document outlines the updated hierarchy of classes within the project, detailing the new methods that have been implemented at each level of the hierarchy. The structure reflects the organization and responsibilities of different components, such as the `Agent_type`, `Agent`, and their associated submodules, with an emphasis on the methods added for enhanced functionality.

## Class Hierarchy

The following hierarchy represents the architecture of the system, with the main `Agent_type` class at the root level and various specialized components, such as `Fim` and `Agents`, beneath it.

### Agent_type (Level 0)
The `Agent_type` class serves as the central controller for managing all operations. It provides initialization and configuration functions.

#### Methods:
- `__init__`: The constructor for initializing the Agent_type instance.
  
---

### Agent (Level 1)
The `Agent` class represents the various agents in the system. It interacts with other subcomponents, such as `Fim`, which provides further specialization.

#### Subcomponents:
- **Fim (Level 2)**: Responsible for handling file integrity monitoring (FIM) tasks. It includes functions for managing changes to files and configuring security measures.

#### Methods in Fim:
- `check_fim_change`: Checks for file integrity changes.
- `configure_audit`: Configures auditing of system changes.
- `manage_ip_in_hosts_allow`: Manages IP addresses allowed in the system.
- `simulate_file_change`: Simulates a file change for testing purposes.
- `test_who_data`: Tests data related to who’s accessing files or systems.

---

### Agents (Level 3)
The `Agents` class is a specialized component under the `Agent` class. It handles the creation and management of individual agents, such as attackers or defenders.

#### Methods in Agents:
- `_create_instance`: Creates an instance of an agent.
- `_create_ossec_conf_instance`: Creates an instance of the OSSEC configuration for the agent.
- `_create_remote_instance`: Creates a remote instance of the agent.
- `_detect_valid_types`: Detects valid agent types.
- `get_all_instances`: Retrieves all agent instances.
- `get_attacker`: Retrieves the attacker agent instance.
- `get_defender`: Retrieves the defender agent instance.
- `get_evaluator`: Retrieves the evaluator agent instance.
- `get_manager`: Retrieves the manager agent instance.
- `initialize`: Initializes the agent instance.
- `interact_with_llm`: Interacts with the Large Language Model (LLM) system.
- `modify_ossec`: Modifies OSSEC configurations for the agent.
- `start`: Starts the agent.
- `stop`: Stops the agent.

---

### Command (Level 4)
The `Command` class is responsible for executing system commands and managing subprocesses.

#### Methods in Command:
- `_run_subprocess`: Executes a subprocess.
- `_sanitize_command`: Sanitizes a command before execution.
- `check_and_install_packages`: Checks for required packages and installs them.
- `kill_related_subprocesses`: Kills subprocesses related to the command.
- `restart`: Restarts the command execution.
- `run_command`: Runs a command.
- `run_command_with_pipe`: Runs a command with piped input/output.

---

### Typography (Level 5)
The `Typography` class handles data formatting and presentation, particularly related to data frames.

#### Methods in Typography:
- `to_dataframe`: Converts the data into a dataframe format for further processing or display.

---

### Object (Level 6)
The `object` class represents the lowest-level class in this hierarchy and doesn’t contain any specific methods yet, but is structured to be extended in the future.

---

## New Functionalities Implemented

The new methods and functionalities implemented across the different levels of this class hierarchy provide a broad range of capabilities. Some key highlights include:

- **File Integrity Monitoring**: The `Fim` class provides various methods for managing file changes and ensuring the integrity of files in the system. Methods like `check_fim_change` and `configure_audit` are integral to system security.
  
- **Agent Management**: The `Agents` class implements several methods related to the creation, initialization, and interaction of agents, including attackers and defenders. The methods in this class provide the necessary hooks to manage the lifecycle of agents within the system.

- **Command Execution**: The `Command` class adds new functionality for running and managing system commands. Methods such as `run_command_with_pipe` and `check_and_install_packages` enhance the flexibility and control over subprocesses within the system.

- **Data Presentation**: The `Typography` class introduces a method for converting data into a dataframe format, enabling easier analysis and visualization of data.

## Architecture Breakdown

The architecture reflects a layered structure where:

1. **Manager**: The highest-level controller that manages the entire operation.
2. **Agent**: The core operational unit responsible for interacting with the system and other components like `Fim`.
3. **Fim**: Handles specialized tasks related to file integrity and auditing.
4. **Agents**: Handles individual agent instances (attacker, defender, etc.).
5. **Command**: Provides utility functions for executing and managing system commands.
6. **Typography**: A utility class for formatting and presenting data in structured formats like dataframes.
7. **Object**: Placeholder for future extensions or subclasses.

## Next Steps

1. **Further Extension of `Object`**: The `object` class is designed to be extended. Future updates will provide additional functionality at this level.
2. **Integration with External Tools**: Future integration with external tools such as logging, monitoring, and threat detection will further enhance the capabilities of these classes.
3. **Testing and Validation**: Extensive testing is required to ensure that all the methods function as expected, especially in edge cases.


### Update: December 18, 2024

#### Major Changes and Updates:

1. **Class Refactoring:**
   - Introduced `VMAgent` class, inheriting from `Remote`, to define VM-specific agent types.  
   - Evaluator agents are now part of the `Agents` hierarchy but are **not** derived from `VMAgent`. This separates VM-specific functionalities from other agent types.

2. **Manager Class Hierarchy:**
   - **Level 0:** `Manager`  
   - **Level 1+:** Extensive method tree with clear modularization:
     - `VMAgent` handles VM-based functionalities.  
     - `Fim`, `Log`, and `Ossec_conf` modules provide specialized methods, encapsulating core Wazuh configurations, file integrity monitoring (FIM), and logging functionalities.  
     - Integration with `Agents` for managing attacker, defender, and evaluator logic.  

3. **Directory Restructuring:**
   - Modularized and reorganized the directory to reflect logical components:
     - **`agents_elements/agent_types`**: Includes specific agent types (attacker, defender, evaluator, manager).  
     - **`agents_elements/vmagents`**: Contains VM-related modules (`fim.py`, `log.py`, `ossec_conf.py`, `vmagent.py`).  
     - **`prototype_configuration`**: Houses scenario configurations and utility scripts.

4. **Tests and Validation:**
   - Extended test suite for `Manager` and its submodules:
     - Validation of `ossec.conf` generation and synchronization.
     - Verification of file integrity monitoring simulations, log analysis, and active response configurations.

5. **Scripts and Utilities:**
   - Updated `main.py` to align with new class hierarchy, emphasizing modularity and reusability.
   - Utility scripts (`utils.py`, `utils_tests.py`) refined to integrate seamlessly with the new structure.

6. **Documentation:**
   - Added detailed `README` for the updated hierarchy and usage patterns.
   - `methods.txt` generated to document available methods for `Manager` and its submodules.

#### Next Steps:
- Complete integration testing for `Agents` interacting with `Manager` under different scenarios (e.g., FIM, attack simulation).
- Enhance `Evaluator` logic for better scoring and decision-making in game-theory-based scenarios.
- Expand documentation for external integrations (e.g., Mininet, LLM).
- Objective will be integrating YARA for malware detection via fim class. And leveraging a response via LLM integration.
- SQL injection integration ? 