Here's the updated section to include information about `tests.sh` and a mention of a backup folder in the `update_notes.md`:

### Update File (`update_notes.md`)

```markdown
# Update Notes

## Overview

This update includes several new implementations and restructuring to improve the management and automation of the VMs and the host machine. The key changes include:

1. **SSH Key Management**: Automated generation and distribution of SSH keys for secure communication between VMs and the host machine.
2. **Directory Tree Restructuring**: A more organized directory structure for better management of scripts and configurations.
3. **Cron Job Setup**: Automated setup of cron jobs for scheduled tasks.
4. **Tests**: Added scripts to test SSH connections and other functionalities.
5. **Logger Implementation**: Introduced a logging mechanism to track script execution and errors.
6. **Sourcer Enhancement**: Improved sourcing of shared functions and variables for better code modularity.
7. **Vagrant File Restructuring**: Enhanced the Vagrant file for clearer provisioning and configuration of VMs.
8. **Backup Folder**: A dedicated backup folder has been established to store critical configuration files and logs for safety.

## SSH Key Management

### Implementation

- **Host Machine**:
  - The `setup_host.sh` script generates SSH keys on the host machine if they don't exist and stores the public key in `keys.txt`.
  - The `setup_host_finish.sh` script reads the `keys.txt` file and adds the keys to the host machine's `authorized_keys` file.

- **VMs**:
  - The `setup_ssh_keys.sh` script generates SSH keys on VMs, collects their public keys, and stores them in `keys.txt`.
  - The script also distributes the public keys to the `authorized_keys` file on each VM.

### Benefits

- Automated and secure SSH key management.
- Ensures seamless SSH communication between VMs and the host machine.

## Directory Tree Restructuring

### New Structure

```
.
├── cleaner.sh
├── common
│   └── tests
│       ├── tests.sh
│       ├── test_ssh_host_to_VM.sh
│       └── test_ssh_VM_to_host.sh
├── ephemere
│   ├── bin
│   ├── bin.txt
│   ├── credentials.txt
│   ├── keys.txt
│   └── log
├── host
│   ├── configs
│   │   └── generate_ssh_config.sh
│   └── setups
│       └── setup_host_finish.sh
├── log
│   ├── config_manager.log
│   ├── nmap_scan.log
│   └── setup_host.log
├── logging.sh
├── make_executable.sh
├── requirements.txt
├── setup_host.sh
├── sourcer.sh
├── src
│   ├── attacks
│   │   └── bruteforce_script.py
│   ├── host-wazuh-management
│   │   ├── agent.conf
│   │   ├── get_agent_keep_alive.py
│   │   └── ossec.conf
│   └── main.py
├── typo.sh
├── utils.sh
├── Vagrantfile
├── variables.sh
└── VM
    ├── configs
    │   ├── agents
    │   │   ├── config_agent.sh
    │   │   └── yml
    │   │       └── suricata.yml
    │   ├── config_customs_rules_update.sh
    │   └── manager
    │       ├── conf
    │       │   ├── attacker
    │       │   │   └── conf
    │       │   │       └── agent.conf
    │       │   ├── default
    │       │   │   └── agent.conf
    │       │   └── defender
    │       │       └── conf
    │       │           └── agent.conf
    │       ├── config_manager.sh
    │       └── yml
    │           └── files.yml
    ├── installers
    │   ├── install_node_exporter.sh
    │   ├── install_wazuh_agent.sh
    │   ├── install_wazuh_server.sh
    │   └── install_xavki.sh
    ├── setups
    │   ├── setup_cron_job.sh
    │   └── setup_ssh_keys.sh
    └── tests
        └── snort-scan.sh
```

### Benefits

- Better organization of scripts and configurations.
- Easier management and maintenance.

## Cron Job Setup

### Implementation

- The `setup_cron_job.sh` script sets up cron jobs for scheduled tasks.
- The script is copied to the VMs and made executable during provisioning.

### Benefits

- Automated setup of cron jobs for scheduled tasks.
- Ensures that necessary tasks are performed at the scheduled times.

## Tests

### Implementation

- The `tests.sh` script provides an overall testing framework for verifying the functionality and connectivity of various components.
- It includes specific tests for SSH connections between the VMs and the host machine, as well as other functional tests to ensure the integrity of the setup.

### Benefits

- Comprehensive testing framework ensures all components are functioning as expected.
- Automated testing reduces the likelihood of issues going unnoticed during deployments.

## Logger Implementation

### Details

- Introduced a `logging.sh` script that provides a unified logging mechanism for all scripts.
- Logs execution details, errors, and debug information to facilitate troubleshooting.

## Sourcer Enhancement

### Details

- Enhanced the `sourcer.sh` functionality to improve the modularity of scripts by ensuring that shared functions and variables are easily accessible.

## Vagrant File Restructuring

### Details

- The Vagrant file has been restructured for clarity, making it easier to understand and modify VM provisioning and configuration.

## Backup Folder

### Implementation

- A backup folder has been created to store important configuration files and logs.
- This backup strategy helps ensure critical data is retained and recoverable in case of any issues.

## Summary

This update introduces several new features and improvements to enhance the management and automation of the VMs and the host machine. Key changes include the restructuring of the directory tree, implementation of SSH key management, integration of a unified logging system, improved modularity with the sourcer script, and a restructured Vagrant file for clearer VM configuration. Additionally, the inclusion of a comprehensive testing framework and a dedicated backup folder enhances the security and reliability of the environment. These enhancements collectively contribute to a more organized, secure, and efficient environment for managing VMs and their interactions with the host machine.

---
```
