# Update on Log Rotation Implementation - November 7, 2024

I have implemented a log rotation concept to manage log files efficiently. This setup ensures that log files are rotated based on their size rather than on a time schedule.

### Key Details:
- Log files will be rotated when they reach a specified size limit, preventing excessive disk usage.
- The log rotation configuration is located at:  
  `export PATH_TO_LOGROTATION_VM_FOLDER="/etc/logrotate.d/config_manager"`
  
This approach helps maintain manageable log sizes while preserving essential log data for troubleshooting and monitoring.

---

# Python Script for CSV Provisioning - November 7, 2024

I have created Python scripts to handle the provisioning of CSV files for node management. The scripts are designed to dynamically assign roles (server, defender, attacker) to nodes and generate a CSV file accordingly.

### Key Details:
- The CSV file is generated with the following columns: `Node` and `Type`.
- The first node is always designated as a **server**; subsequent nodes alternate between **defender** and **attacker** roles.
- The Python script used is `generate_nodes_info_csv`, which takes a file path and node list as arguments and writes the information to a CSV file.
  
This update allows for better management of node configurations and ensures that the data is organized and easily accessible for further use.

---

# NS2I Rule Compliance - November 7, 2024

I am currently setting up a brute-force scenario within a new scenario folder to comply with NS2I rules. This setup is focused on ensuring that all actions within the environment follow the required network security standards and methodologies.

### Key Details:
- The brute-force scenario will simulate attacks while adhering to the NS2I framework.
- The scenario folder structure and setup are designed to be in line with the compliance rules, facilitating both testing and analysis.

This initiative helps create more realistic attack simulations and ensures the environment complies with required security protocols.

---

# Brute-Force Attack Scenario Implementation - November 7, 2024

I have created a new script to implement the brute-force attack scenario. The script is designed to automate the simulation of brute-force attacks within the network environment and dynamically manage different node types such as **server**, **attacker**, and **defender**.

### Key Details:
- The brute-force attack scenario is based on a set of predefined node roles, which are defined in a CSV file that is provisioned using a Python script.
- Depending on the node type (server, defender, attacker), different scripts are executed via SSH to simulate attacks and defenses.
- The implementation ensures that the simulation adheres to network security protocols while providing real-world testing scenarios for the environment.

This new file improves the automation of attack and defense simulations, making the process more flexible and scalable for future testing scenarios.


# Update Summary 13/11

## Work Done

THOSE ARE ONLY DRAFTS
2. **Reinforcement Learning Environment**:
   - Defined state, action, and reward spaces for the RL environment.
   - Implemented the `RLEnvironment` class to manage the environment.
   - Set up the environment to reset and step through actions.

3. **Attacker and Defender Initialization**:
   - Implemented the `Attacker` class with methods for various attack actions (e.g., network scan, SSH brute force, web scraping).
   - Implemented the `Victim` class with methods for updating configurations, pushing rules, and executing commands via SSH.
   - Initialized RL models for both attackers and defenders.

4. **DVWA, Teler, and Nikto Integration**:
   - Pulled and ran the Docker container for DVWA on victim VMs.
   - Installed Teler and Nikto on the attacker VMs or the host machine.
   - Implemented methods in the `Victim` class to simulate web attacks using Teler and Nikto.

5. **Reinforcement Learning Loop**:
   - Implemented the main loop in `main.py` to handle training episodes.
   - Integrated the `update` method in the `Victim` class to handle different types of actions.
   - Logged relevant data for analysis (e.g., signatures, headers, corrupted IPs).
   - Implemented saving and loading of RL models periodically.


