import logging
from variables import DEBUG_LEVEL
import os
# Use getattr() to dynamically access the logging level
log_level = getattr(logging, DEBUG_LEVEL, logging.INFO)  # Default to logging.INFO if not found

# Set up logging
logging.basicConfig(
    format='%(asctime)s - %(levelname)s - %(message)s',
    level=log_level,
    handlers=[logging.StreamHandler()]  # Logs to console by default
)

# Go to the right directory : IMPORTANT 
os.chdir('vagrant/src')