#!/bin/bash
# Typical Bash Script running in provisionning machine

# Get the script filename (without the path) for dynamic naming
if [[ -z "$1" ]]; then
  # If no argument is provided, use $0 to get the script name
  SCRIPT_NAME="${0##*/}"
else
  # If an argument is provided, use it as the script name
  SCRIPT_NAME="$1"
fi

BASENAME="${SCRIPT_NAME%.*}"  # Remove the file extension


# Go to root
cd /
# -------------------------------------------------
# HERE: Source necessary variables
# -------------------------------------------------

# This loads the DEBUG_LEVEL and other variables from sourcer.sh and variables.sh
source /vagrant/sourcer.sh variables.sh

# -------------------------------------------------
# HERE: References Section
# -------------------------------------------------
# Add your references below:
# 1. [Link to Source 1](https://www.example.com)
# 2. [Link to Source 2](https://www.example2.com)
# 3. [Link to Source 3](https://www.example3.com)

# -------------------------------------------------
# HERE: Description
# -------------------------------------------------

log $DEBUG_LEVEL $VERBOSE_INFO "Starting script execution: $SCRIPT_NAME"

# -------------------------------------------------
# HERE: Define paths and other local constants
# -------------------------------------------------

LOG_FILE="$PATH_TO_LOG_DIR/${BASENAME}.log"
initialize_log_file "$LOG_FILE"
TIMESTAMP=$(date +%Y%m%d_%H%M%S)  # Timestamp for uniqueness
BACKUP_FILE="$PATH_TO_BACKUP_FOLDER/${BASENAME}_$TIMESTAMP.bak"
ERROR_COUNT=0

# -------------------------------------------------
# HERE: Backup Section
# -------------------------------------------------
# Ensures the backup folder exists, then backs up SSH configuration files

# Create backup folder if it doesn't exist
if [ -d "$PATH_TO_BACKUP_FOLDER" ]; then
    # BACK UP NECESSARY FILES
else
    log $DEBUG_LEVEL $VERBOSE_ERROR "No backup folder found. Please create a backup folder at: $PATH_TO_BACKUP_FOLDER"
fi

# -------------------------------------------------
# HERE: Check for requirements
# -------------------------------------------------
check_and_install_package "x"
check_file_existence "x1" "x2" ...


# -------------------------------------------------
# HERE: Kill backend processes
# -------------------------------------------------

log $DEBUG_LEVEL $VERBOSE_DEBUG "Cleaning back_end_process logs..."
# Clean the logs
> $PATH_TO_BACK_END_PROCESSES_LOGS

log $DEBUG_LEVEL $VERBOSE_DEBUG "Killing previous back_end_process processes..."
if pgrep -f back_end_process ; then
  pgrep -f back_end_process | xargs kill -9
  log $DEBUG_LEVEL $VERBOSE_DEBUG "back_end_process process was running : killed."
else
    log $DEBUG_LEVEL $VERBOSE_DEBUG "back_end_process process wasn't running."
fi

# -------------------------------------------------
# HERE: Log Saving Section
# -------------------------------------------------
# Placeholder for further log saving instructions
# ...

# -------------------------------------------------
# HERE: Beginning of script
# -------------------------------------------------


# -------------------------------------------------
#HERE Wazuh Logs analysis
# -------------------------------------------------

rule_id="?"
log $DEBUG_LEVEL $VERBOSE_INFO "Retrieving manager logs: $PATH_TO_ALERT_LOGS and Rule ID: $rule_id"

# Call the parse_rule_id function and increment ERROR_COUNT if it returns 1
parse_rule_id "$log_file_path" "$rule_id"
if [ $? -ne 0 ]; then
  ERROR_COUNT=$((ERROR_COUNT + 1))
fi


# -------------------------------------------------
# HERE Cleaning
# -------------------------------------------------


# -------------------------------------------------
# End of Script
# -------------------------------------------------

if [ $ERROR_COUNT -eq 0 ]; then
    log $DEBUG_LEVEL $VERBOSE_INFO "$SCRIPT_NAME successfully realized."
else
    log $DEBUG_LEVEL $VERBOSE_INFO "Errors encountered during script execution: $SCRIPT_NAME. Total errors: $ERROR_COUNT"
fi

