import torch
import pandas as pd
import matplotlib
matplotlib.use('TkAgg')
import matplotlib.pyplot as plt
import seaborn as sns
from sklearn.preprocessing import MinMaxScaler,StandardScaler,LabelEncoder
import math
import numpy as np
from plot_module import plot_matrix_grid
from sdv.metadata import Metadata
from sdv.sampling import Condition
from sdv.single_table import TVAESynthesizer
from scipy.spatial.distance import jensenshannon
from concurrent.futures import ProcessPoolExecutor
import time
from tqdm import tqdm

all_continous_features = ["THICKNESS_TULUS [mm]", "CONTOUR_SPEED [mm/min]", "LASER_POWER [W]",
                          "CONTOUR_GAS_PRESSURE [bar]", "CONTOUR_NOZZLE_DISTANCE [mm]", "CONTOUR_FOCAL [mm]"]
categorical_features=["MATERIAL_NAME_TULUS","NOZZLE_TYPE"]


greedy_burr=pd.read_excel("greedy_subset_Burr.xlsx")
greedy_burr["DEFECT_TYPE"]="Burr"
greedy_plasma=pd.read_excel("greedy_subset_Plasma.xlsx")
greedy_plasma["DEFECT_TYPE"]="Plasma"
greedy_cutting_loss=pd.read_excel("greedy_subset_Cutting loss.xlsx")
greedy_cutting_loss["DEFECT_TYPE"]="Cutting loss"
greedy_cutting_torn=pd.read_excel("greedy_subset_Cutting torn.xlsx")
greedy_cutting_torn["DEFECT_TYPE"]="Cutting torn"
greedy_no_defects=pd.read_excel("greedy_subset_No Defects.xlsx")
greedy_no_defects["DEFECT_TYPE"]="No Defects"

final_greedy=pd.concat([greedy_burr.copy(),greedy_plasma.copy(),greedy_cutting_loss.copy(),
                greedy_cutting_torn.copy(),greedy_no_defects.copy() ],ignore_index=True)

print("final_greedy shape:",final_greedy.shape)
print("final_greedy columns:",final_greedy.columns)
print(final_greedy["DEFECT_TYPE"].value_counts())
final_greedy.to_excel("final_greedy_all_defects.xlsx",index=False)