
import seaborn as sns
from matplotlib import pyplot as plt
import pandas as pd
from sklearn.decomposition import PCA

features_to_plot = [
        "THICKNESS_TULUS [mm]",
        'CONTOUR_SPEED [mm/min]',
        "LASER_POWER [W]",
        'CONTOUR_GAS_PRESSURE [bar]',
        'CONTOUR_FOCAL [mm]',
        
    ]

label_map = {
    'CONTOUR_SPEED [mm/min]': 'Contour Speed (mm/min)',
    'LASER_POWER [W]': 'Laser Power (W)',
    'CONTOUR_GAS_PRESSURE [bar]': 'Contour Gas Pressure (bar)',
    'CONTOUR_FOCAL [mm]': 'Contour Focal (mm)',
    'THICKNESS_TULUS [mm]': 'Thickness Tulus (mm)',
}


real_data=pd.read_excel("merged_files.xlsx").reset_index(drop=True)
cleaned_data=pd.read_excel("outlier_detection_output/final_data_cleaned.xlsx").reset_index(drop=True)
real_data=real_data[cleaned_data.columns]
print(f"real_data columns: {real_data.columns}")
print(f"cleaned_data columns: {cleaned_data.columns}")
print(f"real_data length: {len(real_data)}")
print(f"cleaned_data length: {len(cleaned_data)}")
diff = cleaned_data.copy().merge(real_data.copy(), how='outer', indicator=True)
#cleaned_minus_real = diff[diff['_merge'] == 'left_only'].drop(columns=['_merge']).reset_index(drop=True)
cleaned_minus_real=cleaned_data.copy()
print(f"final_data length after concat: {len(cleaned_minus_real)}")
for defect in cleaned_minus_real['DEFECT_TYPE'].unique():
    print(f"Defect: {defect}, Count: {len(cleaned_minus_real[cleaned_minus_real['DEFECT_TYPE'] == defect])}")
    for name, data in [('Synthetic', cleaned_minus_real[cleaned_minus_real['DEFECT_TYPE']==defect]), ('Real', real_data[real_data['DEFECT_TYPE']==defect])]:
            df_scatter = data[features_to_plot].copy()
            g = sns.pairplot(df_scatter)
            # Imposta etichette con unità per ogni asse
            for i, var in enumerate(features_to_plot):
                for ax in g.axes[i, :]:
                    ax.set_ylabel(label_map[var])
                for ax in g.axes[:, i]:
                    ax.set_xlabel(label_map[var])
            plt.suptitle(f'Scatter Matrix - {name} Data', y=1.02)
            plt.tight_layout()
            plt.savefig(f'scatter_outlier_detection/scatter_{name.lower()}_{defect}.png')