t=0:T_pde;
Nt=T_pde/dt;
x=-L:dx:L;
Nx=2*L/dx;
y=0:dy:1;
Ny=1/dy;

Nx_u=2*Ru/dx; %numero punti di griglia con cellule non infette, deve essere PARI
Ny_u=6; %numero punti di griglia epigenetica con cellule non infette
Nx_I=2*Ri/dx; %numero punti di griglia con cellule infette, deve essere PARI


u1=zeros(Nx+1,Ny+1,T_pde+1);
u2=zeros(Nx+1,T_pde+1);
mu=zeros(Nx+1);
mu_time = zeros(Nx+1, T_pde+1);

u=[zeros((Nx-Nx_u)/2,Ny+1)
    h_uninf*ones(Nx_u+1,Ny+1)
    zeros((Nx-Nx_u)/2,Ny+1)];

i=[zeros((Nx-Nx_I)/2,1)
    h_inf*ones(Nx_I+1,1) 
    zeros((Nx-Nx_I)/2,1)];

u1(:,:,1)=u;
u2(:,1)=i;

beta_val=beta_func(y);
r_val=r_func(y);

vu=2*sqrt(Du*p);
vi=2*sqrt(Di*(beta_val*K-q));


phi=@(I)(zeta*I./(p*eta+zeta*I));
%%

% v = VideoWriter('pde_etazeta.avi'); 
% % v.FrameRate = 10; 
% open(v);
% 

minAx=0; 
maxAx=1000;
tempi_da_salvare= [251, 501, 1001];

for k=0:Nt 
    rho=sum(u,2)*dy+i; 

    % DIFFUSIONE SPAZIALE
    vicino_destra=[u(2:Nx+1,:);u(Nx,:)];
    vicino_sinistra=[u(2,:);u(1:Nx,:)];
    u=u+Du*(vicino_sinistra+vicino_destra-2*u)*dt/(dx^2);

    vicino_destra=[i(2:Nx+1);i(Nx)];
    vicino_sinistra=[i(2);i(1:Nx)];
    i=i+Di*(vicino_sinistra+vicino_destra-2*i)*dt/(dx^2);

    % DIFFUSIONE EPIGENETICA
    vicino_destra=[u(:,2:Ny+1) u(:,Ny)];
    vicino_sinistra=[u(:,2) u(:,1:Ny)];
    u=u+Dy*(vicino_sinistra+vicino_destra-2*u)*dt/(dy^2);


    % REAZIONE
    u=u+dt*(p*(ones(Nx+1,1)*r_val-rho*ones(1,Ny+1)/K).*u-(ones(Nx+1,1)*beta_val).*u.*(i*ones(1,Ny+1)));
%     u=u+dt*(p*(ones(Nx+1,1)*r_val-rho*ones(1,Ny+1)/K).*u);
    i=i+dt*(sum((ones(Nx+1,1)*beta_val).*u,2)*dy.*i-q*i);

    if (mod(k,1/dt)==0)
        u1(:,:,k*dt+1)=u;
        u2(:,k*dt+1)=i;
  
%         figure(1)
%         clf
%         sgtitle('t='+string(k*dt))
%         %subplot(1,2,1)
%         plot(x,sum(u,2)*dy,'LineWidth',1)
%         axis([-L L minAx maxAx])
%         hold on    
%         plot(x,i)
%         legend('u','i')
% %         legend

        figure(1)
        clf
        sgtitle('t='+string(k*dt))
        subplot(1,2,1)
        plot(x,sum(u,2)*dy,'LineWidth',1)
        axis([-L L minAx maxAx])
        hold on    
        plot(x,i)
        legend('u','i')
%         legend
        
        subplot(1,2,2)
        mu=u*y'./sum(u,2);
        plot(x,mu, '--k', 'LineWidth', 1)
        axis([-L L 0 1])
        legend('\mu')

%         mu_time(:, k*dt + 1) = mu;


%       frame = getframe(figure(1));  % Cattura il frame dalla figura
%       writeVideo(v, frame);
% 
        if ismember(k*dt, tempi_da_salvare)
            filename = ['plot_pde1D_' num2str(k*dt) '.png']; % Nome del file
        
            %Salva in alta risoluzione (1200 DPI)
            exportgraphics(gcf, filename, 'Resolution', 1200);
        end


    end

end

% writematrix(mu_time, 'media_epi_PDE.csv');
% writematrix(u1, 'uninfected.csv');
% writematrix(u2, 'infected.csv');

% close(v);