function w = passeggiata_dueD_smorzata(v, thetaU)
% Funzione che prende in input una matrice v con valori interi positivi di
% dimensioni almeno 3x3 e restituisce una matrice w ottenuta compiendo una
% passeggiata aleatoria simmetrica con probabilità di restare sul posto
% pari a 1-theta.

% Otteniamo le dimensioni della matrice v
[n, m] = size(v);

% Inizializziamo la matrice w
w = zeros(n, m);

% Probabilità per ogni direzione
prob_r = thetaU/2 * ones(n, m);  % Probabilità di andare a destra
prob_l = thetaU/2 * ones(n, m);  % Probabilità di andare a sinistra
%prob_stay = (1 - thetaU) * ones(m,n); % Probabilità di rimanere fermi

% Aggiorniamo le probabilità per le posizioni di bordo
prob_r(:, end) = 0;  % Non possiamo andare a destra se siamo già a destra
prob_l(:, 1) = 0;     % Non possiamo andare a sinistra se siamo già a sinistra

%costruiamo la matrice delle probabilità di movimento

b= mnrnd(v(:), [prob_l(:) 1-prob_l(:)-prob_r(:) prob_r(:)]);

%passi in ogni direzione

b_r = reshape(b(:,3), [n,m]); %passo a dx
b_l = reshape(b(:,1), [n,m]); %passo a sx
b_stay = reshape(b(:,2), [n,m]); %fermo

% Ricostruiamo la matrice w
w = b_stay + [b_l(:, 2:end) zeros(n, 1)] + [zeros(n,1) b_r(:, 1:end-1)]; 
