function v = nascitamorte_pressione(v, P, K, p, r, q)
%Funzione che prende in input una matrice v a valori interi positivi, una
%matrice pressione P delle stesse dimensioni, una carrying capacity K, una 
%probabilità di nascita p e una di morte q e restituisce la matrice 
%ottenuta dopo riproduzione e morte. Se la pressione è superiore a K, le
%cellule muoiono prima a tasso p per riequilibrare.
%NB: le nascite precedono le morti, muoiono anche i neonati


v=v+binornd(v,p*(r-P/K).*(P/K<r));
v=v-binornd(v,p*(P/K-r).*(P/K>=r)); %muoiono le eventuali cellule in eccesso
v=binornd(v,1-q);



