function w = mutazioni_epigenetiche(v, thetaY)
    % Funzione che prende in input una matrice v con valori interi positivi di
    % dimensioni almeno 3x3 e restituisce una matrice w ottenuta compiendo una
    % passeggiata aleatoria verticale con probabilità di restare sul posto
    % pari a 1-theta, tenendo conto delle mutazioni epigenetiche.

    % Otteniamo le dimensioni della matrice v
    [n, m] = size(v);

    % Inizializziamo la matrice w
    w = zeros(n, m);

    % Probabilità per ogni direzione
    prob_up = thetaY/2 * ones(n, m);   % Probabilità di andare in alto
    prob_down = thetaY/2 * ones(n, m); % Probabilità di andare in basso
    %prob_stay = (1 - tethaY)*ones(n,m); % Probabilità di rimanere fermi

    % Aggiorniamo le probabilità per le posizioni di bordo
    prob_up(1, :) = 0;    % Non possiamo andare in alto se siamo già in alto
    prob_down(end, :) = 0; % Non possiamo andare in basso se siamo già in basso


    % Costruiamo la matrice delle probabilità di mutazioni 

    b= mnrnd(v(:), [prob_up(:) 1-prob_up(:)-prob_down(:) prob_down(:)]);

    % mutazioni nelle varie direzioni
    b_up = reshape(b(:,1), [n, m]);%mutazione su
    b_down = reshape(b(:,3), [n, m]); %mutazione giù
    b_stay = reshape(b(:,2), [n, m]); 

    % Ricostruiamo la matrice w tenendo conto delle mutazioni epigenetiche
    
    w = b_stay + [b_up(2:end, :); zeros(1,m)] + [zeros(1,m); b_down(1:end-1,:)];

end