function [U,I] = infezione_dued(U, I, beta)
%Funzione che prende in input due matrici U, I a valori interi positivi, una
%probabilità di infezione beta e restituisce la matrice ottenuta dopo
%l'infezione

% [n, m]=size(U); 

% Probabilità massima di infezione
% prob_max=0.9;
prob_max = 1;

% Rappresentiamo le matrici U e I come vettori
% U_vec = U(:);
% I_vec = I(:);

% Calcoliamo la probabilità di infezione per ogni elemento
prob_inf = min(prob_max, beta.* I);

% Calcoliamo il numero di infezioni usando una distribuzione binomiale
A = binornd(U, prob_inf);

% Aggiorniamo le matrici U e I
U = U - A;
I = I + sum(A);




end

