theta_1=2*Du*tau/delta^2;
theta_2=2*Di*tau/delta^2;
thetay= 2*Dy*tau/chi^2;

T=T_pde/tau;
grigliax=2*L/delta; %numeri pari
grigliay=1/chi;
grigliax_uninf=2*cell_uninf/delta; %numero punti di grigliax con cellule non infette, deve essere PARI
grigliax_inf=2*cell_inf/delta; %numero punti di grigliax con cellule infette, deve essere PARI
n_uninf=h_uninf*delta*chi; %numeri cellule non infette in ogni nodo, deve essere INTERO
n_inf=h_inf*delta; %numeri cellule infette in ogni nodo, deve essere INTERO
%NB: al momento considero +1 per coerenza con la PDE

r_vec=r_func(0:chi:1)';
beta_vec=beta_func(0:chi:1)';

U=zeros(grigliax+1,grigliay+1, T_pde+1);
I=zeros(grigliax+1, T_pde+1);
Mu=zeros(grigliax+1);
Mu_time = zeros(grigliax+1, T_pde+1);

U(:,:,1)=[zeros((grigliax-grigliax_uninf)/2,grigliay+1)
      n_uninf*ones(grigliax_uninf+1,grigliay+1) 
      zeros((grigliax-grigliax_uninf)/2,grigliay+1)];
I(:,1)=[zeros((grigliax-grigliax_inf)/2,1)
      n_inf*ones(grigliax_inf+1,1) 
      zeros((grigliax-grigliax_inf)/2,1)];

U_temp=U(:,:,1)';
I_temp=I(:,1)';

%U_mean = 0;

x=-L:dx:L;

y=0:dy:1;

minAx=0; 
maxAx=600;


%% 
% v2 = VideoWriter('abm_etazeta.avi'); 
% %v2.FrameRate = 10; 
% open(v2);
% 
tempi_da_salvare= [200, 360, 740,  1120, 1500];

for k=2:T+1
   P=sum(U_temp)+I_temp;
   U_temp=passeggiata_dueD_smorzata(U_temp,theta_1);
   I_temp=passeggiata_dueD_smorzata(I_temp,theta_2);

   U_temp=nascitamorte_pressione(U_temp, P, K*delta, p*tau, r_vec, 0);
   I_temp=nascitamorte_pressione(I_temp, P, K*delta, 0, 0, q*tau);

   U_temp=mutazioni_epigenetiche(U_temp, thetay);
   
   [U_temp,I_temp] = infezione_dued(U_temp, I_temp, beta_vec*tau/delta);
   

    if any(any(isnan(U_temp))) || any(isnan(I_temp))
        k
    end
    
    %we only save iterations at integer times
    t=(k-1)*tau;
    if t==floor(t)
        U(:, :, t+1)=U_temp';
        I(:,t+1)=I_temp';

        
%         figure(1)
%         clf
%         sgtitle('t='+string(t))
%         %subplot(1,2,1)
%         plot(-L:delta:L,sum(U_temp)/delta)
%         axis([-L L minAx maxAx])
%         hold on
%         plot(-L:delta:L,I_temp/delta)
%         %title('t='+string(t))
%         legend('U','I')

        figure(1)
        clf
        sgtitle('t='+string(t))
        subplot(1,2,1)
        plot(-L:delta:L,sum(U_temp)/delta)
        axis([-L L minAx maxAx])
        hold on
        plot(-L:delta:L,I_temp/delta)

        subplot(1,2,2)
        
        Mu = U_temp'*y'./sum(U_temp',2);

        plot(x,Mu, 'g', 'LineWidth', 1)
        axis([-L L 0 1])
        legend('\mu')

%         frame = getframe(figure(2));  % Cattura il frame dalla figura
%         writeVideo(v2, frame);
       
        if ismember(t, tempi_da_salvare)
           filename = ['plot_abm_etazeta_' num2str(t) '.png']; % Nome del file
        
           %Salva in alta risoluzione (300 DPI)
           exportgraphics(gcf, filename, 'Resolution', 1200);
        end
    end
end

% close(v2);

% writematrix(Mu_time, 'media_epi_ABM.csv');
% writematrix(U_temp, 'U.csv');
% writematrix(I_temp, 'I.csv');