import pandas as pd
import plotly.graph_objects as go
from dash.dependencies import Input, Output
import plotly.express as px
import matplotlib.pyplot as plt
import numpy as np
from scipy.interpolate import make_interp_spline
import matplotlib.image as mpimg

#raffinare il modello: quindi aggiungere la dipendenza della potenza/corrente al cavo, quindi valutare il voltaggio e poi la corrente 
#massima che deve trasportare il nostro cavo (quindi conoscendo potenza e tensione vado a valutare la corrente).
#Dopodiché vado anche a raffinare i costi di operazione per le diverse tecnologie. Quindi auto-lavaggio aumentare il CAPEX ma allo stesso tempo diminuisce
#l'opex. Dopodiché confronto dei costi e NPV nelle varie località. f


def get_data_function():
    Ceuta= pd.read_excel('Locations\Ceuta.xlsx')
    Gotland= pd.read_excel('Locations\Gotland.xlsx')
    Gulf_Gabes= pd.read_excel('Locations\Gulf_Gabes.xlsx')
    Jersey= pd.read_excel('Locations\Jersey.xlsx')
    Pantelleria= pd.read_excel('Locations\Pantelleria.xlsx')
    Zadar= pd.read_excel('Locations\Zadar.xlsx')

    Atoll_Maldives= pd.read_excel('Class_1\Atoll_Maldives.xlsx')
    BawahReserve_Indonesia= pd.read_excel('Class_1\BawahReserve_Indonesia.xlsx')
    Buksin_Bay_Korea= pd.read_excel('Class_1\Buksin_Bay_Korea.xlsx')

    Changhua_TAIWAN= pd.read_excel('Class_2\Changhua_TAIWAN.xlsx')
    Island_Nurai_UAE= pd.read_excel('Class_2\Island_Nurai_UAE.xlsx')

    Baa_Maldives= pd.read_excel('Class_3\Baa_Maldives.xlsx')
    Dutch_sea= pd.read_excel('Class_3\Dutch_sea.xlsx')

    month_order = [
        "January", "February", "March", "April", "May", "June",
        "July", "August", "September", "October", "November", "December"
    ]
    Ceuta["Month"] = pd.Categorical(Ceuta["Month"], categories=month_order, ordered=True)
    Gotland["Month"] = pd.Categorical(Gotland["Month"], categories=month_order, ordered=True)
    Gulf_Gabes["Month"]= pd.Categorical(Gulf_Gabes["Month"], categories=month_order, ordered=True)
    Jersey["Month"] = pd.Categorical(Jersey["Month"], categories=month_order, ordered=True)
    Pantelleria["Month"] = pd.Categorical(Pantelleria["Month"], categories=month_order, ordered=True)
    Zadar["Month"] = pd.Categorical(Zadar["Month"], categories=month_order, ordered=True)

    Atoll_Maldives["Month"] = pd.Categorical(Atoll_Maldives["Month"], categories=month_order, ordered=True)
    BawahReserve_Indonesia["Month"] = pd.Categorical(BawahReserve_Indonesia["Month"], categories=month_order, ordered=True)
    Buksin_Bay_Korea["Month"]= pd.Categorical(Buksin_Bay_Korea["Month"], categories=month_order, ordered=True)


    Changhua_TAIWAN["Month"] = pd.Categorical(Changhua_TAIWAN["Month"], categories=month_order, ordered=True)
    Island_Nurai_UAE["Month"] = pd.Categorical(Island_Nurai_UAE["Month"], categories=month_order, ordered=True)

    Baa_Maldives["Month"] = pd.Categorical(Baa_Maldives["Month"], categories=month_order, ordered=True)
    Dutch_sea["Month"] = pd.Categorical(Dutch_sea["Month"], categories=month_order, ordered=True)
    return Ceuta,Gotland,Gulf_Gabes,Jersey,Pantelleria,Zadar,Atoll_Maldives,BawahReserve_Indonesia,Buksin_Bay_Korea,Changhua_TAIWAN,Island_Nurai_UAE,Baa_Maldives,Dutch_sea



def fun_average_monthly(Ceuta,Gotland,Gulf_Gabes,Jersey,Pantelleria,Zadar):
    average_monthly_hs_ceuta = Ceuta.groupby("Month")["Hs"].mean()
    average_monthly_hs_Gotland = Gotland.groupby("Month")["Hs"].mean()
    average_monthly_hs_Gulf_Gabes = Gulf_Gabes.groupby("Month")["Hs"].mean()
    average_monthly_hs_Jersey = Jersey.groupby("Month")["Hs"].mean()
    average_monthly_hs_Pantelleria = Pantelleria.groupby("Month")["Hs"].mean()
    average_monthly_hs_Zadar = Zadar.groupby("Month")["Hs"].mean()
    # Ensure each DataFrame has "Month" as a column
    average_monthly_hs_ceuta = average_monthly_hs_ceuta.reset_index()
    average_monthly_hs_Gotland = average_monthly_hs_Gotland.reset_index()
    average_monthly_hs_Gulf_Gabes = average_monthly_hs_Gulf_Gabes.reset_index()
    average_monthly_hs_Jersey = average_monthly_hs_Jersey.reset_index()
    average_monthly_hs_Pantelleria = average_monthly_hs_Pantelleria.reset_index()
    average_monthly_hs_Zadar = average_monthly_hs_Zadar.reset_index()
    average_monthly = pd.concat([average_monthly_hs_ceuta.set_index("Month"), average_monthly_hs_Gotland.set_index("Month"),
                    average_monthly_hs_Gulf_Gabes.set_index("Month"), average_monthly_hs_Jersey.set_index("Month"),
                    average_monthly_hs_Pantelleria.set_index("Month"), average_monthly_hs_Zadar.set_index("Month")], axis=1).reset_index()
    average_monthly.columns = ["Month", "Ceuta", "Gotland", "Gulf Gabes", "Jersey", "Pantelleria", "Zadar"]
    month_order = ["January", "February", "March", "April", "May", "June", 
    "July", "August", "September", "October", "November", "December"]
    # Ensure months are ordered correctly
    average_monthly["Month"] = pd.Categorical(average_monthly["Month"], categories=month_order, ordered=True)
    average_monthly = average_monthly.sort_values("Month")

    average_monthly_g_ceuta = Ceuta.groupby("Month")["G"].mean()
    average_monthly_g_Gotland = Gotland.groupby("Month")["G"].mean()
    average_monthly_g_Gulf_Gabes = Gulf_Gabes.groupby("Month")["G"].mean()
    average_monthly_g_Jersey = Jersey.groupby("Month")["G"].mean()
    average_monthly_g_Pantelleria = Pantelleria.groupby("Month")["G"].mean()
    average_monthly_g_Zadar = Zadar.groupby("Month")["G"].mean()
    # Ensure each DataFrame has "Month" as a column
    average_monthly_g_ceuta = average_monthly_g_ceuta.reset_index()
    average_monthly_g_Gotland = average_monthly_g_Gotland.reset_index()
    average_monthly_g_Gulf_Gabes = average_monthly_g_Gulf_Gabes.reset_index()
    average_monthly_g_Jersey = average_monthly_g_Jersey.reset_index()
    average_monthly_g_Pantelleria = average_monthly_g_Pantelleria.reset_index()
    average_monthly_g_Zadar = average_monthly_g_Zadar.reset_index()
    average_monthly_g = pd.concat([average_monthly_g_ceuta.set_index("Month"), average_monthly_g_Gotland.set_index("Month"),
                    average_monthly_g_Gulf_Gabes.set_index("Month"), average_monthly_g_Jersey.set_index("Month"),
                    average_monthly_g_Pantelleria.set_index("Month"), average_monthly_g_Zadar.set_index("Month")], axis=1).reset_index()
    average_monthly_g.columns = ["Month", "Ceuta", "Gotland", "Gulf Gabes", "Jersey", "Pantelleria", "Zadar"]  
    average_monthly_g["Month"] = pd.Categorical(average_monthly_g["Month"], categories=month_order, ordered=True)
    average_monthly_g = average_monthly_g.sort_values("Month")
    return average_monthly, average_monthly_g




def design_function(capacity):

        sea_depth=20
        N_modules= capacity*10**3/0.4 #Number of modules
        N_platforms= int(N_modules/70) #Number of pltaforms
        Chain_Length=sea_depth*1.4 #Total length of one single chain

        return  N_modules, N_platforms,Chain_Length


def mooring_cost_function(technology, N_platforms,Chain_Length):
    panel_type_mapping = {
        "Fixed": 1,
        "Dual-Axis Tracking System": 2.15,
        "Bifacial PV": 1.15,
        "Active Cooling": 1.2
    }

    C_Increase = panel_type_mapping.get(technology, None)

    #Cost of the mooring system
    C_chain=Chain_Length*18.2*2.75*N_platforms #Cost Chains
    C_anchors=736000*0.052/9.81*N_platforms #Cost anchors
    Mooring_Cost=(C_chain+C_anchors)*C_Increase

    return  Mooring_Cost



def platfrom_cost_function(technology, class_value, N_platforms):

    panel_type_mapping = {
        "Fixed": 1,
        "Dual-Axis Tracking System": 2.15,
        "Bifacial PV": 1.15
    }

    class_type_mapping = {
        "Class1": 1,
        "Class2": 0.55,
        "Class3": 1.4
    }

    C_Increase = panel_type_mapping.get(technology, None)
    C_class = class_type_mapping.get(class_value, None)

    #Cost Components System
    C_fp=11366*C_class #Cost one single floating platform

    #Cost platfroms
    Platfroms_Cost=N_platforms*C_fp*C_Increase

    return   Platfroms_Cost


def panel_cost_function(technology, N_modules):

    panel_type_mapping = {
        "Fixed": 1,
        "Dual-Axis Tracking System": 2.15,
        "Bifacial PV": 1.15,
        "Active Cooling": 1.2
    }

    C_Increase = panel_type_mapping.get(technology, None)

    C_PV=300 #Cost per unit PV

    #Cost PV Panels
    Panels_Cost=N_modules*C_PV*C_Increase

    return  Panels_Cost


def electrical_cost_function(technology, distance, capacity):

    panel_type_mapping = {
        "Fixed": 1,
        "Dual-Axis Tracking System": 2.15,
        "Bifacial PV": 1.15,
        "Active Cooling": 1.2
    }

    C_Increase = panel_type_mapping.get(technology, None)

    #Cost Components System
    C_cabm=2.18 #Cost of submarine Capble per meter and MW
    C_elt=157360 #Cost onshore substation per mw

    #Electrical System
    Eletrical_Cost=(C_elt*capacity+C_cabm*distance*capacity)*C_Increase

    return   Eletrical_Cost


def labour_cost_function(Mooring_Cost,Platfroms_Cost,Eletrical_Cost,Panels_Cost):
  
    #Total labour cost, equal to 5% of the total components cost
    C_labour=(Mooring_Cost+Platfroms_Cost+Eletrical_Cost+Panels_Cost)*0.05

    return   C_labour


def OPEX_function(distance,N_platforms,capacity,location):

    v_boat=20000 #m/h 
    c_boat=120 #e/h
    c_divers=90*4 #e/h 4 divers
    c_workers=50*3 #e/h i consider 3 workers
    T_install=0.5 #Time required to install each floating PV structure 

    if location in ['Ceuta','Jersey', 'Gulf Of Gabes','Zadar']:
        cost_SPR=N_platforms*(T_install+2*distance/v_boat)*(c_boat+c_divers+c_workers)
    else: cost_SPR=0

    #Yearly opertional Cost equal to $15 for each kw of nominal power

    Opex=(capacity*15*10**3+cost_SPR)/10**3  #result in kEuro

    return Opex



def NPV(production , C_EN , Opex , Capex, life_time):
        i=0.06
        years = list(range(0, life_time))  # Example: 25 years
        CC = [(prod * C_EN - Opex) / (1 + i) ** year for year, prod in zip(years, production)]
        NPV = [-Capex]
        # Compute cumulative NPV
        for d in range(1, len(years)):
            NPV.append(NPV[d - 1] + CC[d - 1])

        # Create a DataFrame with years and NPV
        npv_df = pd.DataFrame({'Year': years, 'NPV': NPV})

        return npv_df

def PBT_f(npv_df):
        # Identify where the NPV changes its sign
        npv_df['Sign'] = np.sign(npv_df['NPV'])  # Get the sign of each NPV value (-1, 0, 1)
        npv_df['Sign_Change'] = npv_df['Sign'].diff().fillna(0).astype(bool)  # Check for a change in sign
        npv_df.loc[0, 'Sign_Change'] = False
        # Extract the rows where a sign change occurs
        sign_change_years = npv_df[npv_df['Sign_Change'] & (npv_df['Sign'] != 0)]

        # Check if there is any sign change
        if not sign_change_years.empty:
            # Save only the Year and NPV columns
            result = sign_change_years['Year'].iloc[0] 
        else:
            # If no sign change, return "NO FEASIBLE"
            result = "NO FEASIBLE"
        return result




def calculate_lcoe(life_time, capex, opex, production):

    years=list(range(0, life_time))
    discount_rate=0.06
    # Calculate discounted OPEX and production
    discounted_opex = [opex / (1 + discount_rate) ** year for year in years]
    discounted_production = [production / (1 + discount_rate) ** year for year, production in zip(years, production)]

    # Exclude the last year for discounted production sum
    discounted_production_sum = sum(discounted_production[:-1])

    # Calculate LCOE
    lcoe = (capex + sum(discounted_opex)) / discounted_production_sum

    return lcoe


def power_data (location_value):
    data = pd.read_csv(f'Power/{location_value}.csv')

    if location_value=='Ceuta':
        data=data.loc[~data["Month"].isin(["January", "February", "March", 'April'])]

    if location_value=='Zadar':
        data=data.loc[~data["Month"].isin(["January", "February",  'March', "November", "December"])]
        
    if location_value=='Gulf_Gabes':
        data=data.loc[~data["Month"].isin(["May", "February", "March", 'April'])]

    if location_value=='Pantelleria':
        data=data

    if location_value=='Gotland':
         data=data 

    if location_value=='Jersey':
        data=data.loc[~data["Month"].isin(["February", "January",'December', 'November','March'])]

    return data


def energy_analysis():
    Ceuta= pd.read_csv('PV\Ceuta.CSV')
    Gotland =pd.read_csv('PV\Gotland.CSV')
    Gulf_Gabes=pd.read_csv('PV\Gulf_Gabes.CSV')
    Jersey=pd.read_csv('PV\Jersey.CSV')
    Pantelleria=pd.read_csv('PV\Pantelleria.CSV')
    Zadar=pd.read_csv('PV\Zadar.CSV')

    #we assign the data column, (day, month, hour)
    def assign_date(df):
        date_range = pd.date_range(start='2010-01-01 00:00', end='2020-12-31 23:00', freq='H')

        # Assign it to a new column
        df['Datetime'] = date_range

        # Extract Day, Month, and Hour
        df['Day'] = df['Datetime'].dt.day
        df['Month'] = df['Datetime'].dt.month
        df['Hour'] = df['Datetime'].dt.hour
        return df 
    
    Ceuta=assign_date(Ceuta)
    Gotland=assign_date(Gotland)
    Gulf_Gabes=assign_date(Gulf_Gabes)
    Jersey=assign_date(Jersey)
    Pantelleria=assign_date(Pantelleria)
    Zadar=assign_date(Zadar)

    #get the average of each hour over 10 years
    avg_hourly_energy_Ceuta = Ceuta.groupby(['Month', 'Day', 'Hour'])['P'].mean().reset_index()
    avg_hourly_energy_Gotland = Gotland.groupby(['Month', 'Day', 'Hour'])['P'].mean().reset_index()
    avg_hourly_energy_Gulf_Gabes = Gulf_Gabes.groupby(['Month', 'Day', 'Hour'])['P'].mean().reset_index()
    avg_hourly_energy_Pantelleria = Pantelleria.groupby(['Month', 'Day', 'Hour'])['P'].mean().reset_index()
    avg_hourly_energy_Zadar = Zadar.groupby(['Month', 'Day', 'Hour'])['P'].mean().reset_index()
    avg_hourly_energy_Jersey = Jersey.groupby(['Month', 'Day', 'Hour'])['P'].mean().reset_index()

    #some for eeach day
    daily_energy_Cauta = avg_hourly_energy_Ceuta.groupby(['Month', 'Day'])['P'].sum().reset_index()
    daily_energy_Gotland = avg_hourly_energy_Gotland.groupby(['Month', 'Day'])['P'].sum().reset_index()
    daily_energy_Gulf_Gabes = avg_hourly_energy_Gulf_Gabes.groupby(['Month', 'Day'])['P'].sum().reset_index()
    daily_energy_Pantelleria = avg_hourly_energy_Pantelleria.groupby(['Month', 'Day'])['P'].sum().reset_index()
    daily_energy_Zadar = avg_hourly_energy_Zadar.groupby(['Month', 'Day'])['P'].sum().reset_index()
    daily_energy_Jersey = avg_hourly_energy_Jersey.groupby(['Month', 'Day'])['P'].sum().reset_index()

    #I need this to have the date column to add later 
    daily_energy_Cauta['Date']=pd.date_range(start='2024-01-01', periods=len(daily_energy_Cauta), freq='D')
    # First, assign location names and prepare the 'P' columns
    daily_energy_Cauta['Ceuta'] = daily_energy_Cauta['P']
    daily_energy_Gotland['Gotland'] = daily_energy_Gotland['P']
    daily_energy_Gulf_Gabes['Gulf_Gabes'] = daily_energy_Gulf_Gabes['P']
    daily_energy_Pantelleria['Pantelleria'] = daily_energy_Pantelleria['P']
    daily_energy_Zadar['Zadar'] = daily_energy_Zadar['P']
    daily_energy_Jersey['Jersey'] = daily_energy_Jersey['P']

    # Combine into one DataFrame using the Date column from Ceuta
    combined_energy = pd.DataFrame({
        'Month':daily_energy_Cauta['Month'],
        'Date': daily_energy_Cauta['Date'],
        'Ceuta': daily_energy_Cauta['Ceuta'],
        'Gotland': daily_energy_Gotland['Gotland'],
        'Gulf_Gabes': daily_energy_Gulf_Gabes['Gulf_Gabes'],
        'Pantelleria': daily_energy_Pantelleria['Pantelleria'],
        'Zadar': daily_energy_Zadar['Zadar'],
        'Jersey': daily_energy_Jersey['Jersey']
    })
    
    return combined_energy