import pandas as pd
import plotly.graph_objects as go
from dash.dependencies import Input, Output
import plotly.express as px
import matplotlib.pyplot as plt
import numpy as np
from scipy.interpolate import make_interp_spline
import matplotlib.image as mpimg

#we assign the data column, (day, month, hour)
def assign_date(df):
    date_range = pd.date_range(start='2010-01-01 00:00', end='2020-12-31 23:00', freq='H')

    # Assign it to a new column
    df['Datetime'] = date_range

    # Extract Day, Month, and Hour
    df['Day'] = df['Datetime'].dt.day
    df['Month'] = df['Datetime'].dt.month
    df['Hour'] = df['Datetime'].dt.hour
    return df 

def energy_analysis(Nominal):

    #1kw power in w range(1-1000)
    Ceuta= pd.read_csv('PV\Ceuta.CSV')
    Gotland =pd.read_csv('PV\Gotland.CSV')
    Gulf_Gabes=pd.read_csv('PV\Gulf_Gabes.CSV')
    Jersey=pd.read_csv('PV\Jersey.CSV')
    Pantelleria=pd.read_csv('PV\Pantelleria.CSV')
    Zadar=pd.read_csv('PV\Zadar.CSV')

    
    Ceuta=assign_date(Ceuta)
    Gotland=assign_date(Gotland)
    Gulf_Gabes=assign_date(Gulf_Gabes)
    Jersey=assign_date(Jersey)
    Pantelleria=assign_date(Pantelleria)
    Zadar=assign_date(Zadar)

    #get the average of each hour over 10 years
    avg_hourly_energy_Ceuta = Ceuta.groupby(['Month', 'Day', 'Hour'])['P'].mean().reset_index()
    avg_hourly_energy_Gotland = Gotland.groupby(['Month', 'Day', 'Hour'])['P'].mean().reset_index()
    avg_hourly_energy_Gulf_Gabes = Gulf_Gabes.groupby(['Month', 'Day', 'Hour'])['P'].mean().reset_index()
    avg_hourly_energy_Pantelleria = Pantelleria.groupby(['Month', 'Day', 'Hour'])['P'].mean().reset_index()
    avg_hourly_energy_Zadar = Zadar.groupby(['Month', 'Day', 'Hour'])['P'].mean().reset_index()
    avg_hourly_energy_Jersey = Jersey.groupby(['Month', 'Day', 'Hour'])['P'].mean().reset_index()

    #some for eeach day
    daily_energy_Cauta = avg_hourly_energy_Ceuta.groupby(['Month', 'Day'])['P'].sum().reset_index()
    daily_energy_Gotland = avg_hourly_energy_Gotland.groupby(['Month', 'Day'])['P'].sum().reset_index()
    daily_energy_Gulf_Gabes = avg_hourly_energy_Gulf_Gabes.groupby(['Month', 'Day'])['P'].sum().reset_index()
    daily_energy_Pantelleria = avg_hourly_energy_Pantelleria.groupby(['Month', 'Day'])['P'].sum().reset_index()
    daily_energy_Zadar = avg_hourly_energy_Zadar.groupby(['Month', 'Day'])['P'].sum().reset_index()
    daily_energy_Jersey = avg_hourly_energy_Jersey.groupby(['Month', 'Day'])['P'].sum().reset_index()

    #I need this to have the date column to add later 
    daily_energy_Cauta['Date']=pd.date_range(start='2024-01-01', periods=len(daily_energy_Cauta), freq='D')
    # First, assign location names and prepare the 'P' columns
    daily_energy_Cauta['Ceuta'] = daily_energy_Cauta['P']*Nominal/10**6
    daily_energy_Gotland['Gotland'] = daily_energy_Gotland['P']*Nominal/10**6
    daily_energy_Gulf_Gabes['Gulf_Gabes'] = daily_energy_Gulf_Gabes['P']*Nominal/10**6
    daily_energy_Pantelleria['Pantelleria'] = daily_energy_Pantelleria['P']*Nominal/10**6
    daily_energy_Zadar['Zadar'] = daily_energy_Zadar['P']*Nominal/10**6
    daily_energy_Jersey['Jersey'] = daily_energy_Jersey['P']*Nominal/10**6

    # Combine into one DataFrame using the Date column from Ceuta
    combined_energy = pd.DataFrame({
        'Month':daily_energy_Cauta['Month'],
        'Date': daily_energy_Cauta['Date'],
        'Ceuta': daily_energy_Cauta['Ceuta'],
        'Gotland': daily_energy_Gotland['Gotland'],
        'Gulf_Gabes': daily_energy_Gulf_Gabes['Gulf_Gabes'],
        'Pantelleria': daily_energy_Pantelleria['Pantelleria'],
        'Zadar': daily_energy_Zadar['Zadar'],
        'Jersey': daily_energy_Jersey['Jersey']
    })
    
    return combined_energy


def irradiance_analysis():
    Ceuta= pd.read_excel('..\Locations\Ceuta.xlsx')
    Gotland= pd.read_excel('..\Locations\Gotland.xlsx')
    Gulf_Gabes= pd.read_excel('..\Locations\Gulf_Gabes.xlsx')
    Jersey= pd.read_excel('..\Locations\Jersey.xlsx')
    Pantelleria= pd.read_excel('..\Locations\Pantelleria.xlsx')
    Zadar= pd.read_excel('..\Locations\Zadar.xlsx')
    
    month_order = [
        "January", "February", "March", "April", "May", "June",
        "July", "August", "September", "October", "November", "December"
    ]
    Ceuta["Month"] = pd.Categorical(Ceuta["Month"], categories=month_order, ordered=True)
    Gotland["Month"] = pd.Categorical(Gotland["Month"], categories=month_order, ordered=True)
    Gulf_Gabes["Month"]= pd.Categorical(Gulf_Gabes["Month"], categories=month_order, ordered=True)
    Jersey["Month"] = pd.Categorical(Jersey["Month"], categories=month_order, ordered=True)
    Pantelleria["Month"] = pd.Categorical(Pantelleria["Month"], categories=month_order, ordered=True)
    Zadar["Month"] = pd.Categorical(Zadar["Month"], categories=month_order, ordered=True)
    # Define your target locations and their corresponding DataFrames
    target_locations = {
        "Ceuta": Ceuta,
        "Gotland": Gotland,
        "Gulf of Gabes": Gulf_Gabes,
        "Jersey": Jersey,
        "Pantelleria": Pantelleria,
        "Zadar": Zadar
    }

    # Create an empty list to hold the summary data
    irradiance_summary = []

    # Loop over each DataFrame and analyze the 'G' (irradiance) column
    for name, df in target_locations.items():
        g_stats = df['G'].describe()  # Summary statistics for the 'G' column
        irradiance_summary.append({
            "Location": name,
            "Count": g_stats['count'],
            "Mean [W/m²]": g_stats['mean'],
            "Std Dev": g_stats['std'],
            "Max [W/m²]": g_stats['max']
        })

    # Convert the summary to a DataFrame for easy viewing or export
    irradiance_summary_df = pd.DataFrame(irradiance_summary)    
    
    
    
    avg_hourly_irradiance_Ceuta = Ceuta.groupby(['Month', 'Day', 'Hour'])['G'].mean().reset_index()
    avg_hourly_irradiance_Gotland = Gotland.groupby(['Month', 'Day', 'Hour'])['G'].mean().reset_index()
    avg_hourly_irradiance_Gulf_Gabes = Gulf_Gabes.groupby(['Month', 'Day', 'Hour'])['G'].mean().reset_index()
    avg_hourly_irradiance_Pantelleria = Pantelleria.groupby(['Month', 'Day', 'Hour'])['G'].mean().reset_index()
    avg_hourly_irradiance_Zadar = Zadar.groupby(['Month', 'Day', 'Hour'])['G'].mean().reset_index()
    avg_hourly_irradiance_Jersey = Jersey.groupby(['Month', 'Day', 'Hour'])['G'].mean().reset_index()

    daily_irradiance_Cauta = avg_hourly_irradiance_Ceuta.groupby(['Month', 'Day'])['G'].sum().reset_index()
    daily_irradiance_Gotland = avg_hourly_irradiance_Gotland.groupby(['Month', 'Day'])['G'].sum().reset_index()
    daily_irradiance_Gulf_Gabes = avg_hourly_irradiance_Gulf_Gabes.groupby(['Month', 'Day'])['G'].sum().reset_index()
    daily_irradiance_Pantelleria = avg_hourly_irradiance_Pantelleria.groupby(['Month', 'Day'])['G'].sum().reset_index()
    daily_irradiance_Zadar = avg_hourly_irradiance_Zadar.groupby(['Month', 'Day'])['G'].sum().reset_index()
    daily_irradiance_Jersey = avg_hourly_irradiance_Jersey.groupby(['Month', 'Day'])['G'].sum().reset_index()   
    
    
    daily_irradiance_Cauta['Date'] = pd.date_range(start='2024-01-01', periods=len(daily_irradiance_Cauta), freq='D')
    daily_irradiance_Cauta = daily_irradiance_Cauta.drop(columns=['Month', 'Day'])
    # First, assign location names and prepare the 'G' columns
    daily_irradiance_Cauta['Ceuta'] = daily_irradiance_Cauta['G']
    daily_irradiance_Gotland['Gotland'] = daily_irradiance_Gotland['G']
    daily_irradiance_Gulf_Gabes['Gulf_Gabes'] = daily_irradiance_Gulf_Gabes['G']
    daily_irradiance_Pantelleria['Pantelleria'] = daily_irradiance_Pantelleria['G']
    daily_irradiance_Zadar['Zadar'] = daily_irradiance_Zadar['G']
    daily_irradiance_Jersey['Jersey'] = daily_irradiance_Jersey['G']

    # Combine into one DataFrame using the Date column from Ceuta
    combined_irradiance = pd.DataFrame({
        'Date': daily_irradiance_Cauta['Date'],
        'Ceuta': daily_irradiance_Cauta['Ceuta'],
        'Gotland': daily_irradiance_Gotland['Gotland'],
        'Gulf_Gabes': daily_irradiance_Gulf_Gabes['Gulf_Gabes'],
        'Pantelleria': daily_irradiance_Pantelleria['Pantelleria'],
        'Zadar': daily_irradiance_Zadar['Zadar'],
        'Jersey': daily_irradiance_Jersey['Jersey']
    })
        
    combined_irradiance = combined_irradiance[combined_irradiance['Pantelleria'] != 0].reset_index(drop=True)

    return combined_irradiance