/*Codice Diamond generale*/

ods html close; 
ods html;
proc iml;

start Fun(var) global(pd, q, N);
   alpha = var[1]; beta = var[2];
ll_Z=j(N+1,2,.); /* crea una matrice con N+1 righe e 2 colonne tutta piena di punti . */
ll_X=j(N+1,2,.);
ll_Y=j(N+1,2,.);
     do ll=0 to N;  /* sto calcolando "Z" per ogni valore di ll, poi dovremo sommarli tutti per avere Z finale, dal momento che Z  una sommatoria */
         coeff_bin= comb(N, ll);
         A= (alpha - beta/2)*ll;
         B= (beta/2 * ((ll)##2));
         ll_Z[ll+1,1]=ll;
         ll_Z[ll+1,2]= coeff_bin * exp (A+B); /* Calcola ll_Z */
         ll_X[ll+1,1]=ll;
         ll_X[ll+1,2]= coeff_bin * ll * exp (A+B); /* Calcola ll_X */
         ll_Y[ll+1,1]=ll;
         ll_Y[ll+1,2]= coeff_bin * (1/2*ll) * (ll-1) * exp (A+B); /* Calcola ll_Y */
     end;
   Z= sum(ll_Z[, 2]); /* calcolo Z */
   *print Z; /*Il primo Z che viene calcolato  quello ottenuto con alpha e beta iniziali posti pari a 0,01 (x0)*/
   X= sum(ll_X[, 2]); /* calcolo X */
   Y= sum(ll_Y[, 2]); /* calcolo X */ 
   f = j(1, 2, .);         /* return a ROW VECTOR */
   f[1] = pd- (1/(Z * N)* X);
   f[2] = q - (2/(Z * N *(N-1)) * Y);

return (f);
finish;
N=20; 
pd=.4; 
p0=pd;
con = {.   .,   /* Alpha e Beta possono assumere qualsiasi valore --> equazioni dandelion*/
         .      .};
x0 = {.01 .01 };           /* initial guess */
optn = {2               /* solve least square problem that has 2 components */
        1};             /* amount of printing */
print con;
free allpmf; /*inizializzazione della matrice allpdf*/
do ro=0.01 to 0.41 by .1; /* Faccio un grande ciclo che itera in base a rho per calcolare q e pmf, in quanto le due variabili dipendono da rho. Quindi in base alla correlazione rho tra i default si avr una distribuzione di probabilit diversa*/
       I=pd*(1-pd);
       L=p0*(1-p0);
       q=(sqrt(I)*sqrt(L)*ro)+(pd*p0);
       Soln = j(1,2,.);
       call nlphqn(rc, Soln, "Fun", x0, optn) blc=con;  /* or use NLPLM */
       print Soln;
       alpha=Soln[1];
       beta=Soln[2];
ll_Z=j(N+1,2,.); /* crea una matrice con N+1 righe e 2 colonne tutta piena di punti . */
do ll=0 to N;  /* sto calcolando "Z" per ogni valore di ll, poi dovremo sommarli tutti per avere Z finale, dal momento che Z  una sommatoria */
		  coeff_bin= comb(N, ll);
		  A= (alpha - beta/2)*ll;
		  B= (beta/2 * ((ll)##2));	
		  ll_Z[ll+1,1]=ll;
		  ll_Z[ll+1,2]= coeff_bin * exp (A+B); /* Calcola ll_Z */
		  print ll_Z;
	   end;
       Z = sum(ll_Z[, 2]); /* calcolo Z */
       print Z; 

       pmf=j(N+1,3,.); /* crea una matrice con N+1 righe e 3 colonne tutta piena di punti . */
       do ll=0 to N;
             coeff_bin= comb(N, ll);
             I=pd*(1-pd);
             L=p0*(1-p0);
             q=(sqrt(I)*sqrt(L)*ro)+(pd*p0);
	 A= (alpha - beta/2)*ll;
             B= (beta/2 * ((ll)##2));
	 pmf[ll+1,1]=ll;
	 pmf[ll+1,2]= (coeff_bin * exp (A+B)) / Z;
	 pmf[ll+1,3]=ro;	
       end;
   allpmf=allpmf//pmf; /*appende due matrici una sotto l'altra per le varie correlazioni*/
end;
/* Salviamo questi valori in macrovariabili */
CALL SYMPUTX("N", N);
CALL SYMPUTX("PD", pd);

lossNorm=allpmf[,1]/N*100; /* normalizzazione del valore sull'asse x*/
allpmf=allpmf||lossNorm; /* accosta i due vettori colonna per colonna*/
print allpmf; 
create plt_pdf from allpmf[colname={"somma" "pmf" "rho" "lossnorm"}]; /* Creazione del dataset con i nomi delle colonne */
append from allpmf;
close plt_pdf; /* Chiusura del dataset */
quit;
/* Codice per il grafico */
proc sgplot data=plt_pdf;
series x=lossnorm y=pmf / group=rho lineattrs=(thickness=2); /* Traccia il grafico a LINEE*/
    title "Distribuzione di Probabilit N=&N PD=&PD"; 
    xaxis label = "Loss %";
    yaxis label = "Loss probability";
run;

 
