/* Codice SAS per visualizzare il punto di massima entropia prendendo in considerazione rispettivamente prima due poi tre variabili */

ods html close;
ods html;

proc iml;

/* entropia per p su due valori */
free ents2;
do p0=0.01 to .99 by .01;
	ent=-(p0*log(p0)+(1-p0)*log(1-p0));
	ents2=ents2//(p0||ent);
end;
*print ents2;

create plt2 from ents2[colname={p0 entropy}];
append from ents2;
close plt2;



/* entropia per p su tre valori */
free ents3;
do p0=0.01 to .99 by .01;
	do p1=0.01 to 1-p0-0.01 by .01;
		p2=1-p0-p1;
		ent=-(p0*log(p0)+ p1*log(p1)+p2*log(p2));
		ents3=ents3//(p0||p1||p2||ent);
	end;
end;
*print ents3;

create plt3 from ents3[colname={p0 p1 p2 entropy}];
append from ents3;
close plt3;


submit;
	proc sgplot data=plt2;
	scatter x=p0 y=entropy;
	run;

	proc sgplot data=plt3;
	scatter x=p0 y=entropy;
	run;

endsubmit;
