#[cfg(test)]
mod integration_tests {
    use std::fs::{File, OpenOptions};
    use std::io;
    use std::io::{Read, Seek, SeekFrom, Write};
    use std::path::Path;
    use std::ptr::read;
    use super::*;
    use kcimpl::turbof::turbo_simulation::TurboSimulation;
    use kcimpl::turbof::mapints::mapint;
    use kcimpl::turbof::utils::generate_binary_vector;
    use log::error;
    use sysinfo::{Pid, SystemExt};

    #[test]
    fn test_mapint_i32_n_bit_matlab() {
        let perm = vec![8701, 5201, 4800, 2901, 3201, 1404, 8402, 3303, 9003, 503, 3804, 1005, 9302, 2305, 6104, 5104, 3002, 9702, 4602, 4301, 604, 5504, 1503, 9601, 8900, 6005, 1303, 2005, 1605, 1103, 704, 7104, 3505, 9801, 2404, 4403, 7602, 2799, 5603, 2502, 3703, 6804, 7502, 8499, 8799, 7703, 204, 903, 9200, 2201, 8198, 6501, 9901, 5901, 7299, 5699, 6997, 5397, 3399, 6200, 2698, 3599, 3999, 2597, 7800, 9499, 99, 7397, 5795, 2096, 4098, 6698, 5295, 4497, 1895, 6900, 299, 3899, 1699, 400, 4700, 9399, 8004, 7203, 6601, 9100, 7903, 4199, 6399, 8102, 1, 8601, 4899, 1202, 8301, 1800, 800, 6301, 4998, 3101, 8701, 5201, 4800, 2901, 3201, 1404, 8401, 3303, 9003, 503, 3804, 1005, 9302, 2305, 6104, 5104, 3002, 9701, 4602, 4301, 604, 5504, 1503, 9602, 8900, 6006, 1304, 2005, 1605, 1103, 704, 7104, 3504, 9801, 2404, 4403, 7602, 2800, 5603, 2501, 3704, 6803, 7503, 8499, 8800, 7702, 203, 903, 9200, 2201, 8197, 6501, 5902, 7299, 5700, 6999, 5399, 3401, 6201, 2699, 3601, 3999, 2598, 7800, 9501, 100, 7398, 5797, 2097, 4099, 6699, 5296, 4498, 1897, 6901, 299, 3900, 1699, 401, 4701, 9400, 4599, 8003, 7204, 6602, 9100, 7903, 4199, 6399, 8102, 2, 8601, 4898, 1202, 8301, 1800, 800, 6301, 4998, 3101, 8701, 5201, 4800, 2901, 3201, 1404, 8401, 3303, 3606, 9002, 502, 3803, 1004, 9301, 2304, 6103, 5103, 3002, 9700, 4602, 4300, 603, 5503, 1502, 9600, 8899, 6005, 1304, 2003, 1603, 1102, 702, 7103, 3503, 2403, 4404, 7601, 2800, 5603, 2500, 3703, 6802, 7503, 8499, 8800, 7701, 203, 903, 9200, 2201, 8197, 6501, 5902, 7299, 5701, 6999, 5399, 3400, 6200, 2699, 3602, 3999, 2598, 7800, 9501, 99, 7399, 5797, 2097, 4099, 6698, 5297, 4497, 1897, 6902, 299, 3900, 1699, 401, 4700, 9401, 4499, 8003, 7204, 6602, 9100, 7902, 4199, 6399, 8101, 2, 8601, 4898, 1202, 8301, 1800, 800, 6301, 4998, 3101, 8701, 5201, 4800, 2901, 3201, 1404, 8402, 3302, 3606, 9001, 502, 3803, 1004, 9301, 2303, 6103, 5103, 3002, 4602, 4302, 603, 5504, 1502, 9601, 8900, 6006, 1305, 2005, 1604, 1104, 703, 7103, 3505, 2403, 4404, 7601, 2801, 5604, 2501, 3704, 6804, 7503, 2108, 8499, 8800, 7701, 203, 902, 9200, 2202, 8197, 6501, 5902, 7300, 5701, 7000, 5399, 3401, 6200, 2699, 3601, 4000, 2598, 7799, 9501, 98, 7400, 5797, 2097, 4100, 6698, 5297, 4497, 1897, 6902, 299, 3899, 1700, 401, 4699, 9401, 4399, 8002, 7204, 6602, 9100, 7902, 4199, 6400, 8101, 2, 8601, 4898, 1202, 8301, 1800, 800, 6301, 4999, 3101, 8701, 5201, 4801, 2901, 3200, 1403, 8402, 3302, 304, 9001, 502, 3803, 1005, 9301, 2303, 6103, 5103, 3002, 4602, 4302, 603, 5504, 1502, 8901, 6007, 1306, 2006, 1606, 1106, 704, 7104, 3505, 2403, 4405, 7602, 2803, 5605, 2503, 3704, 6805, 7503, 9107, 8501, 8801, 7701, 204, 903, 9202, 2202, 8198, 6501, 5903, 7302, 5702, 7000, 5400, 3403, 6201, 2700, 3601, 4002, 2599, 7800, 9503, 99, 7401, 5799, 2099, 4100, 6700, 5298, 4497, 1898, 6904, 300, 3900, 1701, 402, 4700, 9402, 4300, 8003, 7205, 6603, 9101, 7902, 4200, 6401, 8102, 7702, 2, 8601, 4899, 1202, 8301, 1800, 800, 6301, 4999, 3101, 8701, 5201, 4801, 2901, 3200, 1403, 8402, 3302, 304, 9001, 501, 3803, 1005, 9300, 2302, 6103, 5103, 3002, 4603, 4303, 603, 5504, 1502, 8901, 6007, 1305, 2006, 1606, 1107, 704, 7104, 3505, 2404, 4404, 7601, 2803, 5605, 2503, 3704, 6805, 7503, 2109, 8501, 8801, 7700, 205, 904, 9202, 2201, 8198, 6500, 5902, 7301, 5702, 7000, 5401, 3402, 6201, 2700, 3600, 4002, 2598, 7799, 100, 7401, 5800, 2100, 4101, 6701, 5299, 4497, 1899, 3998, 6904, 300, 3901, 1701, 402, 4700, 9403, 7904, 8003, 7206, 6604, 9102, 7902, 4200, 6401, 8101, 8203, 2, 8601, 4899, 1202, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2901, 3200, 1403, 8402, 3302, 304, 9001, 501, 3803, 1005, 9300, 2303, 6103, 5103, 3001, 4603, 4302, 603, 5505, 1502, 8901, 6007, 1305, 2005, 1605, 1107, 704, 7104, 3504, 2404, 4403, 7600, 2803, 5605, 2503, 3705, 6804, 7502, 7405, 8501, 8801, 7699, 205, 905, 9202, 2201, 8199, 6501, 5902, 7300, 5702, 7001, 5401, 3401, 6201, 2700, 3600, 4002, 2598, 7799, 100, 7401, 5799, 8898, 2099, 4099, 6701, 5299, 4496, 1899, 6402, 6903, 299, 3900, 1700, 401, 4700, 7904, 8002, 7206, 6604, 9102, 7902, 4200, 6401, 8101, 8203, 2, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2900, 3200, 8306, 1402, 8401, 3301, 302, 9000, 500, 3802, 1004, 2302, 6103, 5103, 3001, 4603, 4302, 602, 5505, 1501, 8902, 6007, 1305, 2004, 1606, 1106, 705, 7103, 3504, 2404, 4404, 7600, 2804, 5605, 2504, 3706, 6804, 7501, 2108, 8501, 8801, 7699, 204, 906, 9202, 2202, 8200, 6501, 5902, 7300, 5701, 7002, 5401, 3400, 6200, 2701, 3601, 4001, 2598, 7799, 100, 7400, 5799, 6798, 2099, 4099, 6701, 5299, 4496, 1899, 6403, 6903, 299, 3900, 1700, 401, 4700, 7903, 8002, 7205, 6605, 9102, 7901, 4199, 6402, 8101, 8203, 2, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2900, 3200, 8306, 1402, 8401, 3301, 302, 8999, 500, 3802, 1003, 2302, 6103, 5103, 3002, 4603, 4303, 603, 5505, 1502, 8903, 6007, 1305, 2003, 1606, 1106, 706, 7102, 3505, 2405, 4404, 7601, 2803, 5605, 2504, 3706, 6805, 7500, 8108, 8501, 8802, 7699, 204, 905, 2203, 8201, 6502, 5903, 7300, 5702, 7002, 5402, 3401, 6201, 2703, 3603, 4002, 2600, 7800, 101, 7401, 5800, 6800, 2100, 4099, 6702, 5300, 4498, 1900, 3296, 1397, 6904, 299, 3899, 1701, 400, 4701, 7903, 8002, 7205, 6605, 9102, 7901, 4198, 6402, 8101, 8203, 2, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2900, 3200, 2909, 1402, 8400, 3301, 8801, 8999, 501, 3802, 1003, 2303, 6103, 5103, 3002, 4603, 4303, 603, 5505, 1502, 8902, 6006, 1304, 2004, 1606, 1107, 707, 7102, 3505, 2405, 4404, 7600, 2803, 5605, 2504, 3707, 6805, 7501, 6410, 8501, 8802, 7699, 204, 904, 2203, 8201, 6501, 5903, 7300, 5702, 7001, 5402, 3402, 6202, 2702, 3603, 4001, 2601, 7800, 101, 7400, 5800, 7297, 2100, 4098, 6702, 5301, 4498, 6493, 1899, 4494, 1396, 6903, 297, 3898, 1700, 399, 4700, 7902, 8001, 7203, 6604, 7901, 4198, 6403, 8101, 8203, 2, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2900, 3200, 2909, 1402, 8400, 3301, 8800, 502, 1307, 3803, 1003, 2303, 6103, 5104, 3002, 4603, 4303, 603, 5505, 1502, 8902, 6005, 1305, 2004, 1605, 1107, 707, 7101, 3505, 2405, 4404, 7600, 2804, 5605, 2505, 3706, 6804, 7500, 611, 8501, 8802, 7699, 203, 903, 2204, 8202, 6501, 5902, 7299, 5702, 7001, 5401, 3403, 6202, 2703, 3603, 4000, 2601, 7801, 101, 7400, 5800, 7296, 2099, 4098, 6703, 5301, 4499, 1194, 1899, 4495, 3496, 6902, 297, 3897, 1700, 400, 4700, 7802, 8001, 7203, 6604, 7901, 4198, 6403, 8101, 8203, 2, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2900, 3200, 106, 1402, 8400, 3301, 8800, 502, 1307, 3802, 1003, 2303, 6103, 5104, 3002, 4603, 4303, 603, 5505, 1501, 6006, 1306, 2005, 1605, 1107, 707, 7101, 3507, 2407, 4406, 7601, 2804, 5606, 2505, 3707, 6804, 7501, 611, 8503, 8803, 7701, 204, 905, 2205, 8203, 6503, 5902, 7300, 5703, 7001, 5402, 4600, 3403, 6203, 2704, 3602, 4000, 2602, 7801, 100, 7400, 5799, 6800, 2099, 4098, 6703, 5300, 4499, 1194, 1899, 5895, 1397, 6902, 298, 3896, 1700, 401, 4700, 7702, 8000, 7202, 6605, 7901, 4199, 6403, 8101, 8203, 2, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2900, 3200, 106, 1401, 8400, 3301, 8600, 502, 8303, 3802, 1002, 2303, 6103, 5104, 3002, 4603, 4303, 602, 5505, 1500, 6006, 1306, 2006, 1604, 1108, 707, 7101, 3506, 2406, 4406, 7601, 2804, 5606, 2505, 3706, 6804, 7501, 6411, 8503, 7703, 206, 905, 2206, 8204, 6505, 5904, 7301, 5703, 7002, 5403, 5901, 3405, 6203, 2704, 3603, 4001, 2604, 7802, 101, 7401, 5800, 6801, 2100, 4099, 6703, 5301, 4500, 4894, 1899, 5897, 1398, 6902, 300, 3897, 1701, 5697, 401, 4701, 7602, 8000, 7202, 6605, 7901, 4199, 6403, 8101, 8203, 1, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5001, 3101, 5202, 4802, 2901, 3201, 108, 1402, 8401, 3302, 8601, 502, 8304, 3803, 1003, 1705, 2302, 6103, 5104, 3002, 4603, 4303, 602, 5505, 1499, 6006, 1305, 2006, 1605, 1108, 708, 7102, 3506, 2406, 4406, 7602, 2803, 5605, 2506, 3705, 6803, 7501, 6412, 8503, 7703, 207, 904, 2207, 8204, 6504, 5904, 7301, 5702, 7001, 5403, 4302, 3404, 6203, 2703, 3602, 4001, 2603, 7802, 102, 7401, 5801, 6800, 2101, 4099, 6703, 5301, 4500, 4895, 1899, 4496, 2795, 6902, 301, 3897, 1701, 2698, 401, 4701, 4600, 8000, 7202, 6604, 7901, 4200, 6404, 8101, 8203, 1, 8601, 4901, 1201, 8301, 1799, 800, 6301, 5001, 3101, 5202, 4802, 2901, 3201, 2605, 1402, 8401, 3302, 8401, 502, 8304, 3803, 1003, 1705, 2302, 6103, 5104, 3002, 4603, 4303, 602, 5504, 1500, 6005, 1304, 2006, 1605, 1108, 708, 7101, 3505, 2407, 4406, 7602, 2803, 5604, 2505, 3706, 6802, 7502, 610, 8503, 7703, 208, 904, 2206, 8205, 6503, 5904, 7301, 5703, 7001, 5403, 5902, 3404, 6204, 2702, 3601, 4001, 2603, 7803, 103, 7402, 5801, 5200, 2102, 4100, 6702, 5302, 4501, 1196, 1899, 5898, 1398, 6901, 300, 3898, 1700, 2698, 400, 4701, 4600, 7998, 7999, 7200, 6603, 7900, 4199, 6403, 8100, 8202, 8201, 4901, 1201, 8301, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3200, 2604, 1402, 8400, 3302, 302, 501, 1305, 3802, 1002, 3805, 2302, 6102, 5103, 3001, 4603, 4302, 601, 5503, 1499, 6004, 1302, 2005, 1604, 1106, 706, 7100, 3503, 2405, 4405, 7601, 2803, 5604, 2504, 3705, 6800, 7501, 608, 7703, 207, 904, 2207, 8205, 6503, 5903, 7302, 5703, 7001, 5402, 4302, 3403, 6205, 2702, 3601, 4002, 2602, 7803, 104, 7402, 5802, 5200, 2102, 4100, 6702, 5302, 4501, 7994, 1900, 5898, 1398, 6901, 299, 3898, 1700, 2697, 400, 4702, 4500, 6603, 7999, 7200, 6602, 7900, 4199, 6403, 8101, 8202, 8201, 4901, 1201, 8301, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3201, 2604, 1402, 3302, 8106, 502, 1307, 3803, 1002, 3806, 2303, 6103, 5104, 3002, 4604, 4303, 601, 5504, 1500, 6005, 1304, 2005, 1606, 1106, 708, 7101, 3505, 2406, 4407, 7602, 2805, 5605, 2504, 3706, 6802, 7502, 6108, 607, 7703, 206, 905, 2208, 8205, 6502, 5903, 7303, 5704, 7001, 5402, 4303, 3402, 6204, 2703, 3601, 4002, 2602, 7803, 103, 7402, 5802, 5200, 2103, 4100, 6701, 5301, 4501, 5894, 1900, 4497, 1398, 6901, 299, 3899, 1700, 2697, 401, 4702, 6504, 6603, 8000, 7200, 6602, 7900, 4199, 6403, 8101, 7802, 7801, 4901, 1201, 8301, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3200, 7702, 1402, 3302, 303, 501, 1306, 3803, 1002, 3806, 2303, 6103, 5104, 3002, 4604, 4303, 602, 5504, 1501, 6005, 1304, 2005, 1606, 1105, 708, 7101, 3505, 2405, 4407, 7602, 2805, 5605, 2504, 5108, 3704, 6800, 7501, 6106, 1909, 7702, 204, 903, 2206, 8204, 6501, 5903, 7302, 5702, 7000, 5402, 4302, 3401, 6202, 2703, 3600, 4001, 2602, 7802, 101, 7401, 5801, 5198, 2103, 4099, 6700, 5300, 4501, 1195, 1899, 4497, 1396, 6900, 299, 3898, 1699, 2697, 400, 4700, 6503, 6601, 7999, 7199, 6600, 7900, 4198, 6401, 8100, 7801, 8098, 4900, 1200, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3200, 7702, 1403, 3302, 1109, 501, 1306, 3803, 1002, 1706, 2303, 6102, 5104, 3003, 4604, 4304, 602, 5504, 1501, 213, 6003, 1303, 2005, 1605, 1105, 707, 7101, 3504, 2404, 4406, 7601, 2805, 5603, 2504, 5106, 3704, 6799, 7500, 6104, 7908, 7701, 204, 901, 2205, 6500, 5904, 7302, 5702, 7001, 5402, 4302, 3401, 6202, 2703, 3600, 4001, 2603, 7803, 100, 7402, 5802, 5198, 2102, 4100, 6700, 5301, 4501, 1195, 1900, 4497, 1396, 6900, 299, 3898, 1699, 3588, 400, 4700, 6403, 5804, 7999, 7199, 6600, 7900, 4198, 6401, 8100, 7698, 6398, 4900, 1200, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2901, 3200, 7702, 1403, 3302, 1108, 501, 7404, 1306, 3802, 1002, 1704, 2302, 6101, 5103, 3001, 4603, 4303, 601, 5503, 1500, 6606, 6001, 1303, 2003, 1604, 1104, 705, 7100, 3503, 2404, 4405, 7600, 2803, 5602, 2504, 5104, 3704, 6798, 7499, 7201, 6205, 7701, 202, 900, 2203, 6499, 5902, 7302, 5702, 7001, 5402, 2301, 3400, 6200, 2702, 3600, 4001, 2602, 7802, 100, 7401, 5802, 5198, 2101, 4099, 6699, 5300, 4499, 1193, 1900, 4495, 5395, 6900, 298, 3897, 1698, 3588, 399, 4699, 4598, 5804, 7998, 7197, 6599, 7899, 4197, 6399, 7699, 4194, 4900, 1199, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3201, 2604, 1403, 3302, 302, 501, 7404, 5, 3802, 1001, 1704, 2302, 6100, 5103, 3001, 4603, 4303, 600, 5503, 1500, 4207, 6001, 1303, 2003, 1603, 1104, 704, 7100, 3504, 2404, 4405, 7601, 2803, 5603, 2504, 5105, 3704, 6798, 7499, 6102, 1908, 7701, 201, 901, 2203, 6499, 5901, 7302, 5703, 7001, 5401, 2302, 3400, 6200, 2701, 3600, 4001, 2602, 7802, 99, 7401, 5802, 4598, 2100, 4099, 6699, 5301, 4499, 1193, 1899, 4495, 896, 6900, 298, 3898, 1698, 4988, 399, 4700, 297, 5804, 6001, 7197, 6598, 7899, 4198, 6399, 7699, 6397, 4900, 1199, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3201, 1205, 2603, 1402, 3301, 301, 499, 5207, 4, 3801, 1000, 1704, 2301, 6099, 5102, 3001, 4602, 4302, 599, 5502, 1498, 3010, 5999, 1302, 2002, 1602, 1104, 702, 7099, 3503, 2403, 4404, 7601, 2801, 5602, 2504, 5803, 3703, 6798, 7499, 6100, 2106, 7700, 200, 900, 2203, 6498, 5900, 7301, 5701, 7000, 5400, 2302, 3400, 6198, 2700, 3599, 4000, 2600, 7802, 98, 7401, 5800, 1500, 2099, 4099, 6699, 5300, 4498, 1192, 1898, 4494, 6399, 6899, 297, 3897, 1697, 5697, 399, 4699, 4598, 5802, 5201, 7196, 6597, 4198, 6399, 5999, 6397, 4900, 1199, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3201, 1205, 7701, 1401, 3301, 301, 499, 5207, 3, 3801, 1001, 3804, 2301, 6099, 2402, 5101, 3000, 4601, 4301, 597, 5501, 1497, 206, 5997, 1301, 2001, 1602, 1103, 702, 7098, 3502, 2403, 4403, 7600, 2799, 5600, 2502, 5802, 3702, 6797, 7499, 6098, 5903, 7699, 199, 899, 2203, 6497, 5898, 7300, 5699, 7000, 5400, 2301, 3399, 6197, 2698, 3598, 4000, 2599, 98, 7402, 5800, 3499, 2099, 4099, 6699, 5300, 4499, 1193, 1898, 3695, 3994, 6898, 298, 3897, 1697, 5696, 399, 4699, 297, 5802, 5201, 7196, 6597, 4197, 6398, 3795, 6396, 4900, 1199, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2901, 3201, 1205, 2603, 1401, 3301, 101, 499, 4209, 706, 3801, 1001, 3805, 2301, 6100, 2402, 5101, 3000, 4601, 4301, 598, 5500, 1498, 6905, 5997, 1300, 2002, 1601, 1103, 702, 7098, 3502, 2402, 4403, 7600, 2800, 5599, 2502, 5801, 3702, 6797, 7499, 6804, 7400, 201, 901, 2204, 6499, 5899, 7302, 5700, 7001, 5402, 2303, 3400, 6198, 2698, 3600, 4001, 2599, 99, 7403, 5800, 4597, 2101, 4099, 6700, 5301, 4500, 3194, 1898, 7190, 1397, 6899, 299, 3899, 1698, 5697, 400, 4700, 298, 6599, 5202, 7197, 6598, 4198, 6399, 7497, 7496, 2599, 4900, 1199, 1799, 799, 6301, 5001, 3101, 7201, 5201, 4801, 2901, 3201, 1204, 2603, 1401, 3301, 3100, 500, 7402, 1304, 3801, 1001, 3805, 2301, 6099, 7500, 5101, 3000, 4601, 4301, 598, 5499, 1497, 2113, 5998, 1300, 2002, 1601, 1103, 702, 7098, 3502, 2402, 4403, 2801, 5600, 2502, 409, 3703, 6798, 7500, 6806, 5799, 201, 902, 2206, 6501, 5899, 7303, 5700, 7002, 5402, 2303, 3401, 6199, 2699, 3601, 4001, 2599, 101, 7404, 5801, 5201, 2101, 4100, 7197, 6700, 5302, 4499, 5797, 1898, 1097, 690, 6899, 299, 3899, 1698, 5696, 400, 4701, 4599, 6599, 4601, 7198, 6598, 4198, 6399, 3797, 3796, 7203, 4901, 1199, 1799, 799, 6301, 5001, 3101, 7201, 5201, 4801, 2901, 3201, 1204, 703, 1401, 3301, 3100, 500, 7402, 2807, 3801, 1001, 3805, 2302, 6099, 2402, 5101, 3000, 4601, 4301, 598, 5499, 1497, 3713, 5997, 1301, 2002, 1601, 1102, 703, 7099, 3503, 2401, 4402, 2801, 5599, 2501, 6409, 3703, 6798, 6100, 6496, 201, 903, 2206, 5700, 6501, 5899, 7303, 5700, 7002, 5401, 5104, 3402, 6199, 2699, 3601, 4001, 2599, 101, 7405, 5800, 7299, 2101, 4100, 3396, 6701, 5302, 4499, 4397, 1899, 3697, 1397, 6898, 299, 3898, 1697, 5696, 400, 4700, 4600, 6598, 4602, 7198, 6597, 4199, 6399, 3797, 3796, 7203, 4901, 1199, 1799, 799, 6301, 5001, 3101, 7201, 5201, 4801, 2901, 3201, 1204, 703, 1401, 3301, 3100, 500, 4209, 1305, 3801, 1000, 3805, 2301, 6099, 2402, 5101, 3000, 4601, 4301, 599, 5498, 1497, 6298, 1710, 5996, 1299, 2002, 1600, 1101, 702, 7099, 3502, 2399, 4400, 2800, 5597, 2501, 5800, 3702, 6797, 6099, 6495, 200, 903, 2205, 5698, 6500, 5898, 7303, 5698, 7002, 5400, 1602, 3401, 6199, 2698, 3601, 4000, 2598, 100, 5800, 6800, 2100, 4100, 3396, 6701, 5301, 4500, 3194, 1899, 4496, 690, 6898, 299, 3898, 1697, 490, 400, 4701, 4599, 6199, 4602, 7198, 6597, 4199, 6399, 3796, 3795, 7203, 4901, 1199, 1799, 799, 6301, 5001, 3101, 7201, 5201, 4801, 2901, 3201, 1204, 703, 1401, 3301, 3100, 501, 5206, 1305, 3801, 1000, 1704, 2301, 6099, 2104, 5100, 3000, 4601, 4301, 599, 5498, 1497, 6298, 508, 5996, 1299, 2001, 1601, 1102, 702, 7098, 3502, 2400, 4401, 2801, 5597, 2501, 5799, 3702, 6797, 5107, 6505, 201, 902, 2204, 4003, 6501, 5898, 5699, 7003, 5400, 2503, 3402, 6200, 2699, 3602, 4001, 2599, 101, 5801, 7201, 2101, 4101, 4999, 6701, 5302, 4501, 1197, 1900, 5895, 692, 6900, 300, 3899, 1699, 2695, 400, 4702, 4601, 3198, 4604, 7199, 6598, 4200, 6400, 5999, 1, 7204, 4902, 5602, 1199, 1799, 799, 6301, 5001, 3101, 3702, 5201, 4801, 2901, 3201, 6303, 1903, 1401, 3301, 1199, 502, 1406, 707, 3801, 1001, 3805, 2301, 6099, 2103, 5099, 3000, 4601, 4301, 599, 5498, 1498, 6998, 1404, 5996, 1299, 2001, 1601, 1101, 702, 7098, 3502, 2400, 4401, 2801, 5598, 2501, 6211, 3702, 6798, 4508, 6405, 201, 903, 2203, 5698, 6501, 5898, 5699, 7003, 5400, 5103, 3402, 6200, 2700, 3601, 4001, 2599, 101, 5801, 1998, 2100, 4100, 4999, 6702, 5301, 4502, 4896, 1899, 4498, 1397, 6900, 299, 3900, 1699, 498, 1096, 399, 4701, 4500, 6596, 4603, 6598, 4200, 6400, 5999, 1, 103, 4902, 300, 1199, 1799, 799, 6301, 5001, 3101, 3702, 5201, 4801, 2901, 3201, 6303, 7001, 1401, 3301, 1199, 502, 1904, 3, 3801, 1001, 1704, 2301, 6099, 2103, 5099, 3000, 4601, 4301, 599, 5499, 1498, 6298, 6404, 5997, 1299, 2000, 1601, 1101, 701, 3503, 2401, 4402, 2802, 5598, 2501, 5800, 3703, 6800, 5908, 5799, 202, 905, 2205, 4003, 6502, 5900, 5700, 7005, 5400, 2302, 3403, 6201, 2701, 3602, 4001, 2601, 102, 5802, 2097, 2100, 4101, 3399, 6704, 5302, 4503, 3694, 1900, 5897, 1398, 6901, 300, 3901, 1700, 2697, 2299, 400, 4702, 4601, 6599, 5202, 6599, 4202, 6401, 3499, 5999, 1, 3802, 4902, 300, 1199, 1799, 799, 6301, 5001, 3101, 5701, 5201, 4801, 2901, 3201, 6302, 1903, 1401, 3301, 1199, 502, 1903, 2, 3801, 1001, 1704, 2301, 6099, 2104, 5098, 3000, 4601, 4301, 598, 5498, 1498, 3405, 2809, 3011, 5996, 1299, 1998, 1601, 1099, 700, 3502, 2400, 4400, 2801, 5597, 2501, 5799, 3702, 6799, 1709, 6495, 202, 903, 2204, 4001, 6501, 5900, 5699, 5400, 4302, 3402, 6202, 2701, 3602, 4001, 2601, 101, 5803, 6804, 2100, 4102, 3398, 6704, 5301, 4503, 4896, 1899, 5897, 3198, 6902, 300, 3901, 1699, 994, 3597, 400, 4703, 4501, 6600, 5202, 6600, 4202, 6401, 5203, 5999, 1, 3802, 4902, 300, 1199, 1799, 799, 6301, 5001, 3101, 5701, 5201, 4801, 2901, 3201, 703, 1903, 1401, 3301, 3100, 501, 1903, 2802, 3801, 1001, 3805, 2301, 6099, 2403, 5098, 3001, 4601, 4301, 2402, 597, 5497, 1498, 1809, 1802, 3010, 5995, 1298, 1998, 1599, 1098, 700, 3501, 2400, 4399, 2800, 5596, 2501, 5406, 3701, 6798, 607, 6495, 201, 902, 2203, 4001, 6501, 5899, 5699, 5399, 1202, 3401, 6201, 2700, 3601, 4001, 2600, 100, 5802, 5200, 2099, 4101, 3397, 6703, 5300, 4502, 4895, 1897, 4498, 3996, 300, 3901, 1699, 5698, 3598, 400, 4703, 4401, 5201, 5201, 6600, 4203, 6401, 5202, 5599, 5598, 2601, 4902, 300, 1199, 1799, 799, 6301, 5001, 3101, 5701, 5201, 4801, 2901, 3201, 703, 3, 1401, 3301, 3100, 501, 104, 3, 3801, 1001, 4802, 2301, 6099, 2403, 5098, 3001, 4600, 4301, 2402, 598, 5497, 1498, 1405, 2809, 603, 5995, 1298, 1998, 1599, 1099, 699, 3501, 2400, 4399, 2801, 5596, 2501, 708, 3700, 5298, 6606, 5497, 201, 901, 2202, 3403, 6501, 5899, 5700, 5399, 5899, 3401, 6201, 2701, 3601, 4001, 2600, 100, 5802, 5200, 2099, 4102, 4398, 6704, 5300, 4503, 3692, 1897, 4499, 192, 300, 3902, 1698, 6286, 1398, 400, 4702, 4602, 5002, 5998, 6600, 4203, 6402, 5202, 5599, 5598, 2601, 4902, 300, 1199, 1798, 799, 6301, 5001, 3101, 5701, 5200, 4801, 2901, 3201, 4, 503, 1401, 3301, 3100, 501, 5905, 5804, 3801, 1001, 4801, 2301, 6099, 2403, 5099, 3001, 4599, 4301, 6403, 597, 5497, 1499, 701, 7, 5702, 5995, 1299, 1998, 1598, 1099, 699, 3501, 2400, 4399, 2801, 5597, 2501, 6003, 3699, 5298, 205, 1407, 202, 901, 2203, 4801, 6501, 5900, 5700, 5399, 4598, 3401, 6201, 2701, 3600, 4002, 2601, 101, 5802, 6601, 2099, 4102, 4895, 5301, 4504, 1197, 1898, 3698, 898, 301, 3903, 1698, 5699, 88, 401, 4703, 4602, 3299, 5999, 6601, 4204, 6403, 899, 4803, 5599, 5598, 2601, 4902, 300, 1199, 1798, 799, 6301, 5001, 3101, 5701, 5200, 4801, 2901, 3201, 6302, 503, 1402, 3301, 2900, 501, 104, 304, 3801, 1001, 1002, 2301, 6099, 2403, 5098, 3001, 4599, 4301, 2402, 597, 5497, 1498, 5397, 1309, 2509, 5995, 1298, 1998, 1597, 1099, 698, 3500, 2400, 4398, 2801, 5597, 2501, 4405, 3700, 5298, 6100, 6496, 201, 902, 2203, 4801, 6501, 5900, 5700, 5400, 5900, 3401, 6202, 2701, 3600, 4001, 2601, 102, 5803, 1398, 2100, 4102, 4894, 5301, 4503, 3197, 1899, 3699, 6402, 301, 3904, 1698, 5698, 5797, 401, 4702, 4502, 595, 5999, 5701, 4204, 6403, 3100, 5304, 5599, 5598, 2601, 4901, 300, 1199, 1798, 799, 6301, 5001, 3101, 5701, 5201, 4801, 2901, 3201, 6302, 5602, 1401, 3301, 302, 501, 1908, 1807, 3801, 1001, 2504, 2301, 6099, 2403, 5098, 3001, 4598, 4300, 2402, 597, 5497, 1498, 2, 1309, 2109, 5995, 1299, 1999, 1598, 1100, 698, 3499, 2400, 4397, 2801, 5597, 2501, 5097, 3700, 5406, 5298, 5598, 6304, 201, 902, 2202, 4799, 5900, 5701, 5401, 4301, 3400, 6202, 2702, 3601, 4001, 2601, 102, 5803, 1500, 2100, 4103, 4398, 5302, 4503, 3197, 1899, 396, 6403, 302, 3904, 1698, 6388, 5797, 401, 4702, 4402, 3300, 5201, 4505, 4205, 6403, 3100, 5304, 4801, 4800, 6301, 4901, 5602, 1199, 1799, 799, 6301, 5001, 3101, 5701, 5201, 4801, 2901, 3201, 703, 6301, 1401, 3301, 302, 501, 1908, 3208, 3801, 1001, 2505, 2301, 6099, 2104, 5098, 3001, 4598, 4299, 4199, 597, 5497, 1499, 704, 1101, 4105, 5996, 1298, 1999, 1598, 1099, 699, 3500, 2401, 4397, 2801, 5597, 2501, 2002, 3700, 5299, 5299, 306, 804, 5600, 201, 901, 2201, 3202, 5899, 5700, 5400, 4003, 3399, 6201, 2701, 3600, 4001, 2601, 102, 5802, 1499, 2099, 4103, 4397, 5301, 4501, 4095, 1899, 4094, 3997, 300, 3903, 1698, 5997, 6096, 400, 4700, 4301, 3299, 5200, 4503, 4204, 3101, 5304, 4801, 4800, 6301, 4901, 5602, 1199, 1799, 799, 6301, 5001, 3101, 5701, 5201, 4800, 2901, 3201, 703, 1203, 1401, 3301, 302, 501, 2903, 4205, 3801, 1001, 2505, 2301, 6098, 2404, 5098, 3001, 4598, 4299, 3902, 598, 5497, 1499, 2412, 202, 4104, 5997, 1297, 1999, 1598, 1099, 699, 3500, 2401, 4396, 2801, 5597, 2501, 5097, 3699, 5299, 5299, 5896, 5798, 5600, 200, 902, 2201, 3201, 5900, 5700, 5400, 5900, 3400, 6202, 2700, 3601, 4002, 2601, 103, 5803, 5200, 2099, 4103, 4396, 5301, 4501, 4095, 1899, 1098, 3998, 300, 3903, 1698, 2698, 1096, 400, 4700, 4599, 4686, 5999, 4503, 4204, 4803, 5304, 4402, 4401, 5901, 4901, 5602, 1199, 1800, 799, 4497, 5001, 3101, 5701, 5201, 4800, 2901, 3201, 703, 1203, 1401, 3301, 102, 501, 1903, 405, 3801, 1002, 2505, 2301, 6098, 2104, 5098, 3001, 4599, 4298, 2700, 598, 5497, 1499, 5398, 202, 4103, 5996, 1298, 1999, 1598, 1098, 699, 3500, 2401, 4395, 2801, 5597, 2501, 4101, 3699, 5299, 4997, 2098, 5297, 5600, 200, 901, 2201, 3200, 5900, 5700, 5401, 5900, 3400, 2701, 3601, 4002, 2601, 103, 5805, 5201, 2101, 4103, 3802, 5302, 4501, 5801, 1900, 1098, 398, 301, 3905, 1700, 2699, 1096, 400, 4701, 4600, 3200, 3804, 802, 4205, 4803, 5305, 4904, 1, 5902, 4902, 5603, 1199, 1801, 800, 97, 5002, 1198, 3101, 5701, 5201, 4801, 2901, 3201, 5602, 702, 1401, 3301, 102, 501, 1903, 3, 3801, 1001, 3499, 2301, 2105, 5099, 3002, 4599, 4299, 1998, 599, 5498, 1500, 4698, 810, 3312, 5997, 1299, 2000, 1600, 1098, 701, 5899, 3499, 2401, 4395, 2801, 5597, 2501, 3897, 3700, 5600, 5299, 2098, 4997, 3204, 199, 901, 2201, 4500, 5900, 5701, 5401, 5900, 3401, 2701, 3601, 4001, 2601, 103, 5805, 5201, 2101, 4103, 1699, 5303, 4501, 5801, 1900, 3700, 5902, 300, 3905, 1700, 500, 1095, 400, 4701, 4500, 3201, 2598, 802, 4204, 4803, 5305, 4904, 1, 5502, 4902, 3402, 1199, 1801, 800, 97, 5002, 1198, 3101, 5701, 5201, 4801, 2901, 3201, 5602, 702, 1401, 3301, 402, 501, 1911, 2802, 3801, 1001, 3499, 2301, 2405, 5099, 3002, 4599, 4299, 2404, 600, 5498, 1501, 5399, 1104, 3312, 1300, 2002, 1601, 1100, 701, 5900, 3500, 2402, 4397, 2802, 1602, 5598, 2501, 3896, 3700, 5601, 5299, 5897, 5595, 5601, 199, 900, 2201, 2902, 5901, 5701, 5401, 1200, 3400, 2701, 3602, 4001, 2601, 102, 5805, 798, 2101, 4102, 4301, 5303, 4501, 3197, 1901, 3701, 5903, 300, 3904, 1700, 500, 1095, 401, 4701, 4400, 3200, 3805, 802, 4204, 4803, 5305, 4904, 1, 5502, 4902, 3402, 1199, 1801, 800, 97, 5002, 1198, 3101, 5701, 5201, 4801, 2901, 3201, 504, 703, 1401, 3301, 402, 501, 3307, 1802, 3800, 1001, 701, 2301, 802, 5099, 3002, 4599, 4300, 2404, 600, 5498, 1501, 5399, 4197, 5307, 1300, 2003, 1601, 1100, 701, 300, 3500, 2402, 4396, 2801, 1602, 5599, 2501, 909, 3699, 5299, 5299, 4894, 4997, 5601, 200, 899, 2201, 1804, 5702, 5402, 3201, 3401, 2702, 3604, 4001, 2602, 103, 5807, 1502, 2103, 4103, 5004, 5303, 4502, 3199, 1902, 396, 3595, 302, 3905, 1701, 1499, 1096, 402, 4702, 4301, 1800, 2600, 3103, 801, 4203, 4803, 5202, 4904, 1, 5800, 4902, 3402, 1200, 1801, 800, 97, 5002, 1199, 3101, 5701, 5201, 4801, 2901, 3201, 2204, 702, 1401, 3301, 202, 501, 2309, 2802, 3800, 1001, 404, 2301, 802, 5099, 3002, 4599, 4299, 2404, 601, 5499, 1501, 303, 4198, 2111, 1301, 2003, 1601, 1100, 700, 3102, 3500, 2402, 4396, 2800, 1602, 5599, 2501, 2002, 3698, 5299, 4198, 5194, 1797, 5601, 201, 900, 2200, 4500, 5703, 5403, 4298, 3402, 2701, 3603, 4001, 2602, 1096, 103, 901, 2103, 4102, 2797, 5304, 4502, 3199, 1902, 1099, 599, 302, 3904, 1702, 1696, 2800, 402, 4702, 1701, 3102, 3994, 2503, 800, 4203, 4803, 5202, 4504, 1, 4099, 4902, 4103, 1200, 1801, 799, 4097, 5002, 1199, 3101, 2202, 5201, 4801, 2901, 3201, 2004, 5601, 1401, 3301, 202, 502, 5502, 2802, 3799, 1001, 700, 2301, 2903, 5099, 3002, 4599, 4299, 2404, 600, 5498, 1501, 304, 4197, 1608, 1301, 2003, 1601, 1100, 699, 5598, 3499, 2402, 4396, 2801, 1602, 5599, 2501, 799, 3698, 5601, 4198, 2098, 5596, 5103, 201, 900, 2199, 3201, 2199, 5403, 4298, 3403, 2701, 3602, 4000, 2601, 3602, 104, 1502, 2102, 4102, 4999, 5305, 4503, 3992, 1903, 1099, 3707, 302, 3904, 1702, 500, 3801, 401, 4702, 1601, 5201, 4601, 2503, 800, 4203, 4803, 3504, 4504, 1, 5400, 4902, 3702, 1201, 1801, 799, 4097, 5002, 1200, 3101, 2202, 5201, 4801, 2901, 3201, 407, 503, 1401, 3301, 2, 501, 5502, 2802, 3799, 1001, 700, 2301, 3899, 5099, 3002, 4599, 4299, 2700, 600, 5498, 1501, 510, 4497, 2111, 1301, 2003, 1602, 1101, 700, 902, 3498, 2402, 4396, 2801, 1001, 2501, 3895, 3698, 5301, 5301, 2099, 4998, 4602, 203, 901, 4898, 2199, 3400, 2199, 5403, 4298, 3402, 2702, 3602, 4000, 2601, 3602, 103, 3206, 2102, 4102, 3401, 5305, 4503, 4401, 1903, 3295, 5403, 301, 3903, 1702, 499, 3801, 401, 4701, 1501, 5202, 4601, 2503, 800, 4202, 4803, 3504, 4504, 1, 3700, 4902, 2201, 1201, 1802, 799, 4097, 5002, 1200, 3101, 4201, 5201, 4801, 2901, 3201, 2404, 503, 1401, 3301, 2, 501, 1698, 2802, 3799, 1001, 3502, 2301, 203, 5099, 3002, 4599, 4299, 2403, 601, 1502, 3401, 3994, 1209, 1302, 2004, 1604, 1102, 701, 503, 3499, 2402, 4398, 2802, 4098, 2501, 3897, 3698, 5302, 5302, 4307, 3898, 806, 203, 901, 4, 2200, 4802, 1602, 5405, 4300, 3402, 2703, 3602, 4001, 2603, 2400, 104, 3507, 2103, 4103, 5001, 5306, 4504, 3497, 1903, 1101, 5405, 302, 3904, 1704, 4501, 598, 401, 4702, 1402, 3003, 4601, 5003, 802, 4203, 3105, 3505, 4505, 2, 1497, 4903, 3699, 1202, 1803, 801, 4098, 5003, 1201, 1702, 3101, 4201, 5201, 4801, 2901, 3201, 2404, 2, 1401, 3300, 302, 501, 100, 2208, 3800, 1001, 3501, 2301, 5301, 5099, 3002, 4599, 4299, 1801, 601, 1503, 3401, 3696, 4103, 1302, 2004, 1604, 1102, 701, 3701, 3498, 2401, 4398, 2801, 1301, 4310, 2501, 4099, 3696, 4502, 4200, 5197, 1798, 2006, 202, 901, 3797, 2199, 3996, 2199, 3202, 3402, 2704, 3602, 4001, 2603, 2400, 103, 3506, 2103, 4103, 5002, 5307, 4504, 4402, 1903, 1502, 3706, 301, 3904, 1704, 4500, 1099, 400, 4702, 2904, 3204, 4202, 5004, 4503, 4203, 3106, 1300, 4105, 2, 5198, 4903, 1495, 1202, 1803, 801, 4500, 5003, 1201, 1702, 3101, 4201, 5201, 4801, 2901, 3201, 1100, 2, 1401, 3300, 302, 501, 4505, 3205, 3799, 1001, 2002, 2301, 203, 5098, 3002, 4599, 4299, 2403, 601, 1503, 410, 2396, 4103, 1303, 2004, 1604, 1102, 701, 3702, 3497, 2402, 4398, 2801, 5006, 3497, 2501, 800, 3697, 2909, 4201, 2099, 4303, 4603, 201, 902, 3699, 2198, 3100, 1601, 4600, 3401, 2703, 3601, 4001, 2604, 1098, 103, 3506, 2103, 4104, 3400, 4506, 4904, 1904, 2903, 101, 301, 3905, 1704, 5191, 5097, 401, 4702, 3106, 1902, 2608, 5005, 4504, 4204, 902, 5002, 4106, 3, 1499, 4904, 3699, 1203, 1804, 803, 4501, 5004, 1602, 1201, 1702, 3101, 4201, 4802, 2902, 3202, 3604, 1100, 3, 1401, 3300, 102, 501, 4, 1705, 3799, 1001, 1204, 2301, 3899, 5098, 3001, 4599, 4299, 2403, 601, 1503, 2900, 2099, 305, 1304, 2004, 1604, 1102, 702, 504, 3497, 2402, 4398, 2802, 5007, 700, 2501, 3895, 3696, 3405, 4201, 3697, 805, 4603, 200, 902, 3797, 2197, 3997, 1600, 4301, 3401, 2703, 3601, 4002, 2603, 1099, 102, 3505, 2102, 4104, 2801, 4506, 3603, 1905, 2904, 3209, 301, 3905, 1704, 501, 1101, 401, 4702, 2510, 897, 4600, 5005, 3206, 4204, 902, 3701, 4106, 3, 1499, 4904, 3699, 1203, 1804, 803, 4501, 5004, 1602, 1201, 1702, 3101, 4201, 4802, 2902, 3202, 3603, 1100, 2, 1401, 3300, 102, 501, 3, 3, 3800, 1001, 700, 2301, 3899, 3001, 4600, 4300, 2101, 602, 1504, 3196, 3697, 1907, 1305, 2004, 1605, 1104, 703, 505, 3499, 2403, 4399, 2803, 4100, 701, 2501, 802, 3697, 4503, 2411, 3698, 806, 4604, 202, 903, 3798, 2199, 3398, 1601, 5000, 4802, 3400, 2704, 3601, 4002, 2603, 1099, 101, 3505, 2102, 4104, 5008, 4505, 3603, 1905, 2798, 1507, 301, 3906, 1704, 501, 1792, 402, 4703, 4502, 1903, 3206, 5005, 4504, 4204, 902, 5002, 1100, 2, 1498, 4904, 3698, 1203, 1804, 803, 98, 5004, 1602, 1201, 1702, 3101, 4201, 4802, 2902, 3202, 3603, 4203, 4901, 1401, 3300, 302, 501, 3, 1802, 3800, 1001, 700, 2301, 100, 3001, 4600, 4300, 1202, 602, 1504, 4600, 3195, 298, 4599, 1304, 2002, 1604, 1104, 702, 3701, 3497, 2401, 4398, 2801, 1004, 1603, 2500, 801, 3696, 2903, 4805, 3697, 4304, 2903, 201, 902, 3798, 2198, 4802, 2999, 1000, 4301, 3399, 2704, 3600, 4001, 2603, 3600, 100, 2804, 2102, 4103, 3099, 4505, 2300, 1903, 300, 3406, 301, 3905, 1704, 1501, 795, 401, 4702, 1803, 2903, 3205, 2506, 4503, 4203, 4602, 3699, 4800, 4799, 4906, 4903, 3597, 1203, 1803, 802, 97, 1602, 1202, 1702, 3101, 4201, 4802, 4707, 2901, 3201, 3603, 4201, 3101, 1400, 3300, 401, 500, 103, 801, 3799, 1000, 1204, 2300, 3898, 2999, 4600, 4299, 1201, 601, 1503, 4600, 3194, 1200, 301, 1303, 2001, 1603, 1103, 701, 3700, 3496, 2400, 4397, 2799, 3109, 1602, 2500, 800, 3695, 3595, 1907, 3697, 4303, 2303, 200, 901, 2100, 2197, 3997, 1400, 2397, 4300, 3398, 2702, 3599, 4000, 2603, 3599, 99, 4402, 2101, 4103, 1700, 4505, 2299, 1902, 299, 3405, 300, 3904, 1703, 299, 1100, 401, 4701, 4600, 3200, 3202, 2505, 3202, 4202, 3300, 3698, 1099, 3696, 3004, 4504, 1203, 1803, 802, 97, 1602, 1202, 1702, 3101, 4201, 210, 2902, 3202, 3604, 3, 3102, 1401, 3300, 102, 501, 3905, 1802, 3800, 1001, 2199, 2301, 100, 3000, 4600, 4300, 1501, 602, 1504, 612, 2897, 1201, 2997, 1304, 2307, 2001, 1603, 1103, 701, 3701, 3496, 2400, 4398, 2799, 4098, 1502, 2500, 3397, 3696, 4297, 4103, 3697, 4303, 3704, 199, 901, 1502, 2196, 1499, 1400, 999, 4300, 3398, 2701, 3600, 4001, 2602, 3600, 99, 4403, 2102, 4103, 1699, 4505, 3092, 1903, 4604, 3405, 301, 3903, 1703, 197, 1100, 401, 4702, 299, 1801, 3003, 2506, 3800, 4202, 3897, 1299, 1099, 1297, 1503, 4504, 1203, 1803, 802, 98, 1602, 1202, 1702, 3101, 4201, 4413, 2902, 3201, 3604, 1204, 702, 1401, 3300, 3100, 501, 909, 1802, 3800, 1001, 2199, 2301, 100, 3000, 4600, 4300, 1999, 602, 1504, 4600, 2595, 704, 1200, 1005, 1303, 2306, 2000, 1601, 1102, 701, 1303, 3495, 2399, 4398, 2797, 1002, 2202, 2498, 799, 3695, 499, 4405, 3697, 3394, 2900, 199, 900, 1501, 2196, 3193, 1399, 2398, 4300, 3397, 2700, 3599, 4000, 2600, 3599, 98, 3503, 2101, 4101, 997, 4504, 1003, 1902, 1205, 3404, 300, 3902, 1702, 3300, 599, 400, 299, 1802, 4000, 3102, 4599, 4202, 3299, 1299, 1098, 1097, 1503, 4504, 1203, 1803, 802, 98, 1602, 1202, 1702, 3101, 4201, 4013, 2902, 3201, 3604, 1704, 702, 1401, 3301, 402, 501, 2907, 1802, 3800, 1001, 604, 2301, 3899, 3001, 4302, 4499, 603, 1504, 3901, 1699, 706, 3696, 712, 1304, 1807, 2000, 1601, 1103, 703, 3299, 3497, 2399, 4399, 2797, 503, 2204, 2498, 800, 3696, 97, 3996, 498, 3396, 804, 201, 901, 1501, 2198, 3397, 2699, 2398, 3197, 3399, 1399, 2699, 3599, 4000, 2600, 3599, 99, 3503, 2101, 4102, 996, 4505, 201, 1903, 3406, 4402, 300, 3902, 1703, 495, 599, 400, 299, 1801, 4000, 3102, 3799, 4203, 3897, 1300, 3297, 3296, 3298, 2203, 1203, 1803, 803, 99, 1602, 1202, 1702, 3101, 4201, 1007, 2902, 3202, 1305, 1704, 702, 1401, 3301, 2900, 501, 8, 1802, 3799, 1001, 4202, 2301, 3899, 3000, 4301, 4201, 604, 1504, 1008, 2595, 3599, 3696, 806, 1304, 1407, 2000, 1601, 1103, 703, 207, 3497, 2398, 4399, 2797, 3100, 3304, 2498, 2401, 3696, 3192, 2600, 3698, 3396, 4198, 201, 900, 2899, 2199, 3998, 2699, 2397, 2302, 3399, 801, 2699, 3599, 4000, 2599, 797, 3598, 98, 1499, 2101, 4102, 3792, 602, 1903, 2905, 4300, 300, 3901, 1703, 399, 4297, 401, 299, 1201, 3202, 3101, 1803, 4203, 3897, 1300, 2898, 1, 3298, 2203, 1203, 1803, 803, 99, 1602, 1202, 1702, 3101, 4201, 2907, 2901, 3202, 804, 3503, 702, 1401, 3301, 202, 501, 1003, 1208, 3799, 1001, 400, 2300, 3899, 3000, 4301, 4200, 604, 1504, 1310, 997, 706, 4298, 1111, 1303, 1905, 2000, 1601, 1103, 703, 207, 3497, 2398, 2799, 3503, 2013, 2498, 801, 3697, 501, 3296, 3699, 4105, 1604, 202, 900, 2900, 2199, 1499, 2699, 800, 1604, 3400, 1, 2699, 3601, 4002, 2600, 2498, 1702, 99, 2099, 2103, 4103, 3294, 2003, 1904, 4303, 1400, 302, 3902, 1705, 2602, 3301, 402, 890, 199, 1702, 1300, 2504, 1803, 4203, 3299, 3501, 3495, 1, 3298, 2203, 1203, 1803, 803, 701, 1602, 1202, 1702, 3101, 4201, 2907, 2901, 3202, 2504, 3, 4201, 1401, 3301, 2700, 501, 3, 2205, 3799, 1001, 3198, 2300, 3899, 3000, 2001, 605, 1505, 710, 2396, 3211, 1398, 3298, 1303, 1906, 2001, 1602, 1104, 704, 3216, 3498, 2398, 2799, 2802, 2204, 2498, 802, 3698, 3598, 2300, 3699, 3696, 4100, 203, 901, 2901, 2199, 4001, 1103, 2102, 2505, 3401, 802, 2700, 3602, 4003, 2600, 2499, 3202, 99, 2100, 2996, 2103, 4103, 3294, 2004, 1904, 706, 1401, 302, 3903, 1705, 3904, 600, 402, 1701, 99, 3801, 2687, 2504, 3799, 4203, 3299, 3501, 898, 1, 3298, 2203, 1203, 1803, 803, 701, 1602, 1202, 1702, 3101, 702, 3210, 2902, 3202, 1910, 3, 3501, 1401, 3301, 2, 501, 3, 2800, 3799, 1001, 2202, 2299, 100, 3000, 2000, 605, 1505, 3905, 2597, 1806, 3299, 900, 1303, 407, 2000, 1601, 1103, 704, 3702, 3498, 2397, 2799, 1107, 3607, 2498, 3899, 3698, 2599, 2299, 3699, 3399, 2497, 203, 901, 1304, 2199, 4001, 3, 2101, 1605, 3402, 3502, 2700, 3602, 4003, 2600, 2100, 1603, 100, 3901, 2997, 2102, 4104, 1700, 1004, 3590, 1904, 1100, 1400, 301, 3902, 1704, 3583, 798, 402, 3600, 795, 3801, 1804, 3100, 3799, 3298, 600, 899, 1, 2500, 2103, 1203, 1803, 803, 1601, 1602, 1202, 1702, 3101, 702, 3210, 2902, 3202, 3408, 3, 2402, 1401, 3301, 2500, 501, 11, 3, 3799, 1001, 2201, 2299, 100, 3000, 3301, 605, 1505, 1008, 2596, 110, 406, 3298, 1303, 1408, 1999, 1601, 1204, 1101, 703, 3911, 3497, 2396, 2798, 2398, 3600, 2498, 3898, 3698, 799, 3296, 2598, 1305, 3202, 202, 900, 2602, 2197, 4000, 3403, 2100, 1604, 3401, 3501, 2699, 3601, 4003, 2599, 2101, 2106, 99, 2197, 1996, 2101, 1997, 3603, 899, 1904, 1496, 1401, 302, 3902, 1704, 98, 2898, 402, 1895, 3499, 3200, 598, 3899, 3799, 3298, 2304, 2498, 1, 2500, 2003, 1203, 1803, 803, 401, 1602, 1202, 1702, 3101, 2701, 1613, 2902, 3202, 3610, 3502, 2, 1401, 3300, 302, 501, 1407, 802, 3798, 1001, 702, 2299, 3898, 3000, 1999, 605, 1505, 1007, 2596, 811, 1098, 405, 1303, 1806, 1999, 1601, 1204, 1101, 703, 3703, 3497, 2397, 2798, 1106, 2201, 2497, 801, 3699, 299, 2599, 3399, 803, 2197, 202, 899, 1004, 2196, 3400, 1102, 501, 2300, 2794, 3400, 3500, 2698, 3601, 2599, 2705, 3601, 99, 3800, 1996, 2100, 1702, 798, 898, 1903, 2289, 2404, 302, 3903, 1705, 2801, 3486, 401, 3801, 3399, 2801, 1805, 1704, 3799, 901, 3501, 3095, 1, 2101, 1903, 1203, 1803, 803, 1999, 1602, 1202, 1702, 3101, 2701, 1003, 2902, 3202, 605, 3502, 2, 1401, 3300, 2300, 501, 409, 103, 3798, 1001, 1002, 2300, 1409, 3000, 3405, 1997, 604, 1504, 310, 2595, 411, 507, 600, 1301, 1903, 1997, 1600, 705, 1100, 702, 1303, 3497, 2395, 2798, 1601, 2199, 2496, 1998, 3698, 500, 199, 105, 801, 6, 201, 897, 1302, 2194, 3699, 2699, 500, 999, 3602, 3399, 3398, 2698, 3600, 2598, 703, 3799, 99, 3800, 193, 2099, 1995, 796, 2800, 1902, 200, 898, 300, 1705, 590, 2984, 401, 3802, 3299, 3604, 1103, 1902, 3199, 901, 3502, 498, 1, 3602, 1803, 1203, 1803, 803, 498, 1602, 1202, 1702, 3101, 2701, 1003, 2902, 3202, 1804, 1703, 2, 1401, 3300, 102, 501, 3602, 802, 1002, 401, 2300, 206, 3001, 3407, 1998, 605, 1505, 1011, 1599, 2201, 3109, 210, 1302, 1903, 1997, 1600, 1203, 1101, 702, 505, 3499, 2396, 2799, 3599, 1509, 2497, 3603, 3699, 2597, 2296, 408, 2903, 2893, 201, 899, 2902, 2195, 701, 3000, 501, 299, 202, 3401, 803, 2699, 3601, 2600, 2295, 1905, 100, 2196, 1099, 2099, 2102, 96, 2801, 1902, 1302, 900, 301, 1787, 1704, 501, 2997, 401, 1400, 3199, 3604, 1993, 1703, 3199, 3102, 2201, 499, 2, 3202, 3601, 1203, 1803, 803, 1301, 1602, 1202, 1702, 3101, 2701, 1003, 2902, 3202, 1105, 104, 2, 1401, 3300, 2100, 501, 3602, 802, 1002, 401, 2300, 1603, 3001, 1203, 506, 604, 1504, 1007, 1302, 2701, 2195, 805, 1302, 1902, 1997, 1599, 3503, 1100, 701, 505, 3498, 2396, 2799, 3599, 2902, 2497, 2804, 100, 2709, 2705, 1899, 1505, 201, 900, 2099, 2196, 3402, 1403, 1002, 300, 802, 3402, 603, 2700, 3603, 2601, 698, 2998, 100, 2197, 1596, 2100, 2904, 96, 900, 1903, 1103, 397, 599, 301, 1002, 1704, 2701, 2997, 402, 1401, 3505, 1804, 2600, 1703, 803, 3102, 200, 2098, 2, 3202, 3601, 1203, 1803, 803, 1301, 1602, 1202, 1702, 3101, 2701, 2604, 2611, 2901, 3201, 1104, 3202, 3500, 1400, 3299, 401, 500, 3096, 801, 1001, 700, 2299, 1602, 3000, 1599, 504, 603, 1502, 609, 2296, 609, 2304, 2397, 1301, 1901, 1997, 1598, 1103, 1099, 700, 503, 3497, 2395, 2798, 1599, 1503, 2497, 1997, 2701, 3298, 2105, 502, 905, 200, 899, 1501, 2195, 2000, 1598, 1206, 2092, 202, 3401, 602, 2699, 2601, 1100, 2096, 100, 2400, 1598, 2100, 2904, 2893, 2803, 1902, 3503, 100, 901, 302, 1002, 1703, 2700, 3197, 402, 1301, 1705, 400, 2600, 1103, 803, 903, 200, 2695, 2, 3500, 3201, 1203, 1803, 803, 101, 1602, 1202, 1702, 3101, 2701, 2604, 807, 2901, 3201, 2902, 309, 2800, 1399, 3299, 1899, 500, 199, 801, 1001, 899, 2299, 703, 3000, 1598, 404, 603, 1502, 3301, 2296, 1799, 596, 2707, 1300, 1902, 1996, 1597, 5, 1099, 700, 3098, 2397, 2799, 1599, 504, 2498, 1997, 2803, 201, 1405, 2595, 3095, 201, 899, 1, 2196, 403, 2196, 1306, 1599, 203, 3403, 806, 2701, 2602, 700, 2999, 101, 1701, 2203, 2101, 2104, 1105, 897, 2803, 1902, 1608, 100, 1904, 302, 500, 1703, 2700, 899, 402, 3292, 1605, 3298, 3002, 502, 3200, 903, 201, 98, 2, 1799, 2202, 1203, 1803, 803, 101, 1602, 1202, 1702, 3101, 2701, 2604, 1002, 2901, 3201, 1600, 303, 1701, 1399, 3299, 3098, 500, 2604, 207, 1001, 899, 2299, 1699, 3000, 216, 304, 603, 1501, 1111, 1300, 2700, 108, 107, 1299, 708, 1996, 1596, 3201, 1099, 700, 3197, 2397, 2799, 399, 1404, 2498, 1997, 1205, 1905, 3205, 103, 2894, 201, 900, 2601, 2197, 3102, 1598, 1702, 1298, 203, 806, 2702, 2604, 1104, 2401, 102, 1701, 2097, 2102, 2105, 1107, 2904, 902, 1903, 1105, 3099, 795, 96, 302, 501, 1702, 2700, 1700, 402, 3097, 1505, 3299, 3003, 503, 3200, 3103, 1903, 2804, 2, 3100, 2202, 1203, 1803, 803, 101, 1602, 1202, 1702, 3101, 2701, 2604, 1706, 2901, 3201, 1299, 303, 701, 1399, 3099, 501, 407, 2103, 1204, 1001, 2303, 2299, 1004, 3000, 2914, 1997, 603, 1501, 1110, 401, 2707, 107, 1505, 1299, 2005, 1996, 1596, 5, 1098, 699, 1599, 2397, 2799, 1893, 1599, 2498, 799, 501, 200, 308, 607, 1402, 200, 901, 3000, 2198, 1200, 3002, 502, 505, 202, 2204, 2702, 2604, 2406, 1998, 102, 1701, 3200, 2103, 2106, 107, 2905, 902, 1903, 698, 3099, 1996, 103, 302, 2496, 1702, 502, 1501, 403, 292, 1405, 99, 2503, 503, 804, 3103, 2405, 2804, 2, 1400, 2202, 1203, 1803, 803, 1303, 1602, 1202, 1702, 3101, 2701, 2604, 1303, 2901, 2004, 909, 702, 1400, 3100, 502, 408, 1902, 1800, 1002, 2903, 2300, 3102, 3000, 2516, 1998, 604, 1502, 1005, 2501, 2301, 1395, 2399, 1299, 2004, 1997, 1598, 1102, 1098, 700, 3099, 2398, 2801, 1894, 2596, 2499, 801, 3000, 200, 2505, 2797, 1898, 200, 903, 4, 2199, 703, 1401, 802, 2503, 2302, 305, 1, 2702, 2604, 2701, 2201, 101, 1701, 1598, 2103, 2005, 3, 1398, 903, 1903, 1491, 1294, 1494, 103, 303, 702, 1702, 1401, 1699, 402, 95, 94, 99, 1205, 3100, 804, 3103, 2405, 3102, 2, 2603, 2202, 1203, 1803, 803, 1203, 1602, 1202, 1702, 3101, 2701, 2604, 2601, 2901, 2004, 1203, 702, 1400, 2900, 502, 904, 1902, 3, 1001, 101, 2300, 2603, 3000, 1602, 505, 604, 1503, 1608, 2899, 506, 1395, 1698, 1298, 707, 1998, 1597, 6, 1098, 700, 702, 2398, 2802, 1005, 2596, 2499, 801, 501, 201, 1199, 2596, 907, 201, 902, 2102, 2199, 2803, 1598, 2102, 499, 2303, 2904, 1607, 2703, 103, 2603, 2303, 1098, 100, 1700, 997, 2102, 1099, 1, 2896, 902, 1903, 1103, 993, 1795, 400, 302, 701, 1701, 2702, 896, 402, 998, 400, 1203, 3002, 503, 804, 903, 2404, 1400, 1, 2602, 2201, 1202, 1802, 802, 101, 1601, 2500, 1701, 2701, 2303, 1003, 2901, 2004, 2609, 702, 1400, 303, 502, 903, 2697, 803, 513, 1000, 1898, 2299, 2899, 7, 505, 604, 1502, 808, 2899, 109, 1705, 2399, 1298, 1903, 1998, 1597, 2003, 1097, 700, 599, 2398, 2802, 400, 2401, 2499, 503, 2102, 1908, 1801, 1104, 2897, 201, 901, 1801, 2200, 2908, 2200, 2401, 1001, 2303, 5, 2407, 2703, 1999, 2604, 1401, 1097, 101, 1700, 1800, 2102, 2004, 2000, 2103, 901, 1903, 102, 698, 1497, 1403, 303, 702, 1701, 502, 699, 402, 2792, 300, 300, 899, 2499, 1102, 903, 2301, 2701, 1, 1398, 2201, 1202, 1802, 802, 101, 1601, 2500, 1701, 2701, 1302, 702, 2805, 2104, 2503, 1400, 304, 503, 904, 2006, 504, 2106, 1000, 903, 2300, 1700, 605, 506, 605, 1503, 1098, 1, 2703, 904, 2400, 1300, 2606, 1999, 1598, 7, 1097, 700, 599, 2399, 2803, 798, 1501, 2501, 505, 503, 202, 1003, 2799, 2707, 202, 902, 2101, 2201, 707, 2201, 999, 501, 1697, 2299, 707, 2606, 2703, 403, 2604, 1904, 1704, 101, 101, 1603, 2103, 2505, 1006, 498, 901, 1903, 903, 2296, 1996, 496, 303, 1893, 1702, 199, 999, 402, 2299, 200, 2399, 2596, 2500, 1102, 1502, 2301, 1001, 1, 1398, 2201, 1201, 1802, 802, 101, 1601, 2500, 1701, 2701, 1301, 702, 2704, 1504, 2512, 1400, 304, 503, 409, 1007, 315, 1404, 1000, 902, 2504, 2299, 1908, 305, 1404, 603, 1502, 696, 803, 1209, 1897, 603, 1298, 2206, 1998, 1597, 6, 1096, 698, 1201, 2399, 401, 2599, 2502, 800, 503, 1802, 2509, 609, 209, 201, 901, 903, 2201, 106, 1401, 2403, 1601, 2200, 999, 305, 1600, 2704, 1199, 2604, 2303, 1099, 102, 2700, 1502, 2103, 1204, 207, 1800, 1403, 1902, 908, 2297, 1996, 104, 303, 2698, 1702, 1600, 109, 402, 2605, 2300, 195, 2591, 1100, 804, 1502, 603, 2204, 1, 2602, 998, 1201, 1802, 802, 701, 1601, 2500, 1701, 1805, 1301, 2507, 905, 1004, 2503, 1401, 706, 503, 2324, 1008, 802, 2203, 1000, 1701, 2503, 2299, 100, 7, 504, 602, 207, 1501, 501, 1510, 9, 106, 1197, 1297, 800, 1997, 1597, 1704, 1096, 697, 198, 2399, 400, 1300, 2501, 1999, 1507, 1500, 2503, 804, 2200, 201, 899, 2405, 2200, 1102, 1600, 800, 1104, 2504, 304, 2006, 800, 303, 2605, 1307, 1703, 101, 507, 1503, 2102, 2105, 1005, 2605, 402, 1903, 2399, 2298, 1996, 1695, 303, 496, 1702, 988, 1901, 403, 2597, 2200, 1799, 2594, 1897, 803, 1502, 603, 1000, 2, 2496, 1992, 1201, 1802, 802, 701, 1601, 2500, 1701, 1805, 1303, 2203, 1002, 1301, 502, 912, 1400, 210, 501, 902, 1107, 2096, 2202, 1000, 1401, 2404, 2298, 199, 1006, 1499, 601, 1909, 1500, 499, 5, 699, 2109, 1496, 1296, 1903, 1996, 1596, 2, 1094, 695, 1891, 2398, 398, 2397, 2500, 1899, 1398, 2101, 899, 102, 2002, 201, 897, 2305, 2200, 1297, 2200, 2102, 901, 2303, 803, 304, 1301, 303, 1598, 2102, 101, 102, 1503, 2103, 1702, 1005, 1800, 95, 1903, 1697, 1490, 1699, 1294, 304, 495, 1701, 1797, 1901, 403, 86, 1700, 1400, 2402, 2500, 803, 1502, 1604, 2301, 2, 1897, 304, 1201, 1802, 802, 502, 1601, 2500, 1701, 1201, 1303, 2203, 1001, 1301, 106, 2, 1400, 2125, 501, 903, 1306, 705, 803, 999, 1000, 1509, 2297, 199, 2401, 1499, 600, 1413, 1500, 499, 1097, 793, 1500, 605, 1296, 598, 1996, 1596, 1702, 1094, 694, 395, 2398, 1703, 997, 901, 500, 2103, 1108, 3, 1399, 203, 898, 1597, 2201, 1899, 1600, 2403, 203, 993, 1704, 702, 301, 303, 2102, 1504, 103, 1703, 1100, 2105, 1803, 209, 1999, 1603, 1903, 7, 1491, 2097, 997, 305, 1895, 1702, 1798, 1901, 403, 1899, 399, 1301, 2203, 1200, 1600, 802, 1502, 1204, 601, 2, 1897, 304, 1201, 1802, 802, 302, 1601, 696, 1701, 1201, 1303, 2203, 1001, 1301, 106, 2, 1400, 302, 501, 902, 1901, 1604, 108, 999, 1000, 1104, 2297, 1698, 810, 1499, 600, 2014, 1500, 197, 1999, 1605, 1100, 300, 1297, 805, 1997, 1596, 1702, 1094, 694, 2098, 398, 1807, 2001, 2105, 201, 610, 1902, 2110, 1997, 202, 898, 898, 2201, 2103, 1601, 997, 206, 1805, 502, 403, 502, 701, 1201, 1000, 104, 2102, 1100, 2105, 1806, 2204, 2000, 900, 1904, 2304, 1895, 1385, 1900, 304, 700, 1702, 1500, 1901, 403, 1387, 1899, 2104, 593, 295, 404, 1900, 1502, 2005, 1804, 2, 1098, 304, 1201, 1802, 802, 1599, 1601, 1201, 500, 1201, 1302, 2203, 1902, 403, 1403, 2, 1400, 302, 501, 707, 1901, 1103, 2104, 1000, 302, 2004, 1699, 2101, 1201, 601, 2, 1501, 107, 2001, 911, 1501, 1103, 1298, 1908, 1999, 1597, 3, 1095, 696, 395, 299, 397, 193, 2002, 1111, 200, 1410, 600, 2006, 1295, 201, 898, 702, 2201, 795, 1601, 997, 2009, 1805, 1498, 1901, 1508, 899, 697, 1807, 104, 1096, 1004, 2105, 1103, 399, 1694, 600, 1905, 195, 1694, 1995, 1306, 304, 1293, 1701, 1500, 899, 402, 1696, 1900, 494, 1200, 685, 1099, 1403, 1502, 2005, 2098, 3, 994, 2201, 1201, 1802, 802, 1599, 1601, 1201, 500, 1201, 1302, 1602, 1902, 204, 507, 700, 1400, 304, 301, 500, 705, 913, 799, 2103, 999, 1799, 1703, 1698, 605, 1200, 601, 1602, 1500, 198, 297, 2011, 302, 1901, 1297, 1304, 1997, 1596, 900, 1095, 694, 296, 297, 205, 401, 300, 2001, 2103, 1306, 1100, 2113, 1594, 200, 897, 1, 9, 1403, 2105, 1007, 709, 504, 1009, 799, 905, 596, 697, 103, 99, 903, 2106, 1103, 1007, 294, 2098, 1905, 1804, 1896, 998, 1304, 303, 1694, 1701, 1500, 599, 402, 1400, 1900, 587, 1486, 1799, 1898, 1907, 204, 1996, 1499, 3, 997, 302, 1201, 1802, 802, 792, 301, 1201, 500, 1201, 1303, 1602, 1902, 2010, 508, 700, 1399, 304, 301, 501, 1603, 1803, 101, 2002, 999, 400, 1703, 1698, 1705, 513, 600, 704, 1500, 1696, 1699, 495, 997, 600, 1297, 794, 1997, 1596, 798, 1095, 694, 1998, 896, 194, 394, 1801, 2000, 1003, 202, 819, 102, 403, 1996, 198, 897, 1802, 598, 1404, 798, 609, 1808, 1507, 296, 1598, 699, 797, 201, 102, 898, 1503, 899, 1007, 202, 1806, 1905, 1199, 296, 586, 704, 303, 700, 1702, 302, 300, 401, 97, 1796, 1701, 1897, 1888, 2008, 801, 1797, 1699, 1499, 3, 997, 3, 1201, 1802, 802, 102, 301, 1201, 500, 1201, 1012, 1602, 1902, 803, 8, 701, 1399, 1203, 101, 500, 1701, 105, 1904, 900, 999, 1002, 1902, 197, 1807, 503, 600, 704, 1500, 799, 102, 196, 104, 1197, 1297, 1006, 1598, 1100, 1096, 695, 796, 602, 592, 1300, 606, 898, 1004, 401, 702, 305, 1609, 401, 198, 899, 1600, 495, 1602, 999, 797, 1203, 1805, 201, 1400, 397, 1804, 1005, 102, 1496, 1505, 304, 9, 706, 1298, 1907, 1200, 1097, 799, 1398, 303, 495, 1703, 501, 601, 402, 97, 404, 1799, 1899, 8, 1703, 802, 806, 1300, 701, 4, 998, 1504, 1803, 1201, 1802, 802, 1299, 301, 1201, 500, 1201, 209, 1602, 1301, 603, 1402, 212, 1399, 1202, 103, 500, 303, 1701, 1105, 900, 999, 999, 900, 197, 8, 208, 600, 306, 1500, 1207, 1097, 1700, 103, 603, 1297, 795, 1599, 695, 1096, 695, 794, 200, 992, 395, 998, 299, 510, 315, 1001, 996, 1813, 604, 299, 196, 898, 898, 1200, 1402, 800, 391, 1202, 1805, 907, 1601, 1397, 1701, 1607, 101, 696, 1204, 1801, 13, 692, 398, 900, 103, 492, 203, 303, 1187, 1703, 1504, 601, 402, 84, 404, 907, 1104, 202, 402, 1703, 806, 1300, 597, 4, 200, 304, 702, 1201, 1802, 802, 492, 301, 1201, 500, 1201, 924, 1102, 1601, 1300, 1502, 1401, 700, 1398, 1201, 1001, 500, 901, 1700, 402, 799, 998, 998, 899, 1696, 797, 404, 599, 1602, 1500, 1597, 1698, 196, 798, 1596, 1296, 1711, 1597, 1198, 1095, 695, 1696, 1698, 297, 394, 389, 1104, 1512, 495, 1104, 1103, 517, 606, 402, 195, 897, 512, 904, 1600, 799, 203, 605, 403, 1703, 1399, 495, 497, 1606, 99, 1704, 1605, 300, 1403, 200, 1396, 498, 401, 592, 1204, 302, 485, 1703, 1500, 1489, 401, 603, 402, 1004, 1104, 503, 1399, 1702, 1700, 397, 599, 3, 199, 303, 205, 1200, 802, 397, 101, 1201, 500, 1201, 1413, 101, 1601, 1300, 1502, 1000, 700, 1398, 1201, 1000, 500, 801, 299, 1201, 1209, 997, 596, 899, 799, 799, 99, 599, 1602, 1499, 1401, 698, 195, 403, 788, 1297, 1297, 1597, 1198, 1095, 695, 1100, 494, 297, 1300, 610, 498, 1098, 1407, 494, 197, 605, 2, 1601, 598, 194, 896, 295, 406, 1600, 798, 100, 1304, 1209, 300, 797, 102, 699, 1606, 98, 399, 1095, 998, 594, 1399, 900, 106, 1000, 491, 1203, 301, 1096, 401, 1499, 401, 802, 402, 904, 1505, 508, 407, 801, 900, 995, 599, 2, 597, 303, 902, 1200, 802, 799, 798, 1100, 1296, 1201, 1013, 100, 300, 1300, 403, 801, 700, 1398, 1201, 1196, 500, 701, 1302, 1094, 1399, 997, 998, 899, 1206, 5, 98, 599, 704, 1499, 501, 1006, 290, 1495, 507, 1298, 593, 1200, 1096, 696, 697, 393, 400, 1401, 998, 498, 1310, 707, 496, 198, 298, 698, 802, 398, 195, 897, 296, 1500, 104, 501, 203, 906, 199, 900, 799, 903, 698, 1096, 99, 100, 1396, 114, 1202, 1495, 901, 1297, 902, 1199, 202, 302, 1097, 413, 898, 500, 401, 1197, 486, 301, 1099, 599, 1208, 603, 305, 1501, 1106, 2, 1301, 303, 303, 1200, 802, 1303, 1199, 1100, 1296, 1201, 806, 100, 300, 800, 403, 1127, 401, 1398, 1424, 1196, 501, 900, 603, 700, 1299, 997, 1202, 899, 500, 1400, 597, 599, 911, 1007, 699, 196, 98, 1000, 1298, 501, 397, 1098, 697, 899, 896, 409, 1001, 293, 610, 603, 1007, 95, 601, 996, 1209, 203, 1103, 196, 898, 901, 901, 200, 999, 597, 1203, 906, 199, 1401, 605, 1102, 1204, 100, 101, 409, 1397, 491, 603, 599, 499, 708, 701, 1206, 304, 394, 185, 199, 1301, 402, 1207, 800, 386, 1198, 1002, 405, 1303, 1101, 497, 600, 1105, 2, 1301, 303, 303, 1200, 802, 1303, 299, 1100, 796, 1201, 307, 102, 300, 703, 403, 801, 506, 605, 1001, 502, 1004, 611, 603, 802, 998, 1202, 806, 800, 1304, 110, 600, 894, 1009, 808, 197, 206, 95, 1299, 106, 903, 1100, 698, 893, 395, 293, 127, 492, 195, 701, 311, 1203, 97, 201, 195, 307, 704, 198, 899, 1, 898, 97, 802, 91, 605, 496, 1004, 906, 910, 506, 6, 101, 398, 109, 1104, 414, 100, 402, 901, 488, 1095, 690, 305, 1296, 1289, 792, 784, 403, 305, 1201, 287, 497, 1004, 1300, 1303, 102, 398, 900, 600, 906, 1, 1301, 303, 303, 1200, 802, 1303, 299, 1100, 197, 1201, 412, 102, 1001, 98, 503, 798, 408, 1002, 1197, 502, 204, 1, 102, 806, 998, 100, 900, 800, 1201, 899, 804, 599, 813, 397, 501, 196, 997, 607, 403, 797, 1099, 698, 894, 101, 1094, 194, 797, 516, 906, 914, 498, 799, 1108, 1007, 303, 704, 199, 900, 94, 304, 1106, 504, 201, 201, 505, 503, 203, 1104, 801, 10, 102, 1105, 1203, 297, 412, 4, 401, 1211, 905, 502, 789, 305, 701, 705, 201, 100, 402, 591, 800, 398, 1197, 1113, 403, 501, 298, 298, 901, 1008, 199, 1, 901, 303, 303, 1200, 802, 199, 299, 1100, 197, 305, 210, 102, 101, 98, 310, 1099, 700, 602, 404, 501, 1009, 1, 308, 706, 997, 398, 111, 800, 100, 300, 404, 599, 194, 699, 2, 196, 996, 705, 301, 198, 1099, 698, 191, 396, 403, 994, 592, 489, 1007, 2, 402, 98, 196, 808, 298, 301, 703, 198, 899, 400, 708, 2, 802, 1100, 410, 502, 299, 801, 709, 503, 10, 101, 395, 1006, 506, 394, 905, 194, 298, 994, 502, 386, 303, 700, 192, 92, 687, 401, 896, 400, 1097, 1004, 1101, 103, 500, 103, 606, 595, 905, 902, 901, 203, 300, 302, 802, 903, 697, 700, 896, 305, 210, 101, 300, 98, 102, 911, 800, 304, 997, 501, 397, 796, 601, 802, 997, 500, 215, 800, 500, 992, 806, 599, 804, 296, 802, 692, 806, 203, 199, 996, 903, 699, 16, 592, 810, 399, 204, 892, 907, 103, 402, 501, 196, 597, 6, 1, 97, 198, 899, 403, 1, 411, 802, 614, 915, 501, 605, 604, 604, 98, 709, 101, 201, 195, 601, 504, 190, 903, 603, 894, 585, 991, 303, 1000, 706, 686, 185, 401, 1002, 1002, 997, 204, 1003, 103, 500, 299, 305, 99, 599, 902, 901, 103, 300, 805, 802, 298, 897, 700, 396, 901, 118, 601, 100, 299, 97, 5, 499, 799, 706, 203, 500, 396, 210, 698, 800, 2, 110, 316, 200, 300, 597, 599, 107, 721, 102, 897, 504, 292, 401, 898, 399, 700, 502, 102, 403, 798, 192, 212, 888, 510, 409, 501, 786, 500, 609, 605, 384, 198, 899, 602, 380, 302, 802, 499, 708, 801, 302, 605, 94, 701, 400, 101, 303, 496, 506, 87, 908, 904, 408, 402, 598, 85, 303, 195, 706, 705, 3, 400, 9, 801, 897, 695, 600, 402, 102, 901, 301, 398, 600, 505, 504, 3, 300, 200, 802, 99, 897, 700, 301, 5, 807, 601, 101, 299, 97, 5, 507, 399, 800, 796, 500, 194, 108, 496, 802, 699, 4, 503, 215, 199, 299, 804, 599, 512, 800, 108, 195, 306, 101, 499, 207, 102, 698, 698, 394, 401, 595, 796, 394, 499, 799, 211, 97, 200, 105, 97, 502, 295, 197, 798, 92, 3, 803, 498, 705, 801, 503, 802, 604, 709, 317, 102, 103, 799, 507, 195, 497, 401, 203, 605, 601, 797, 302, 704, 304, 702, 291, 400, 507, 708, 797, 802, 502, 500, 301, 397, 301, 497, 700, 102, 101, 102, 300, 1, 802, 391, 800, 700, 301, 5, 706, 601, 205, 399, 97, 415, 401, 96, 105, 505, 500, 409, 600, 501, 596, 499, 699, 707, 609, 607, 500, 303, 598, 1, 100, 605, 195, 103, 701, 592, 609, 692, 698, 94, 101, 402, 304, 196, 406, 200, 398, 402, 11, 197, 397, 97, 202, 299, 197, 693, 578, 701, 504, 201, 285, 392, 699, 712, 499, 100, 503, 102, 693, 504, 703, 4, 202, 694, 402, 191, 705, 202, 302, 104, 307, 689, 398, 401, 407, 196, 607, 501, 592, 694, 402, 700, 202, 587, 404, 504, 503, 700, 300, 199, 292, 601, 302, 397, 301, 601, 516, 601, 207, 602, 97, 402, 410, 400, 212, 599, 499, 495, 406, 207, 596, 2, 197, 207, 607, 603, 486, 95, 598, 1, 496, 616, 195, 387, 101, 396, 104, 302, 502, 105, 102, 590, 399, 306, 606, 502, 412, 308, 414, 583, 105, 605, 497, 198, 197, 605, 503, 188, 603, 601, 601, 99, 599, 406, 97, 308, 402, 102, 103, 397, 396, 401, 203, 300, 409, 501, 601, 202, 303, 91, 493, 95, 192, 401, 307, 81, 95, 490, 505, 489, 298, 497, 7, 499, 595, 198, 197, 603, 596, 193, 502, 198, 302, 189, 301, 3, 502, 2, 233, 100, 97, 96, 401, 200, 101, 309, 499, 95, 400, 305, 412, 197, 499, 500, 107, 495, 298, 503, 495, 397, 296, 196, 395, 312, 386, 507, 92, 106, 202, 111, 295, 371, 278, 206, 506, 301, 413, 1, 424, 490, 495, 94, 307, 199, 3, 199, 1, 11, 192, 401, 407, 201, 498, 503, 98, 326, 401, 103, 497, 407, 12, 209, 198, 104, 193, 205, 3, 502, 303, 111, 405, 495, 101, 401, 207, 187, 305, 305, 502, 396, 292, 389, 385, 387, 396, 199, 198, 486, 379, 403, 99, 398, 199, 202, 301, 103, 202, 302, 211, 300, 97, 408, 95, 102, 202, 198, 96, 95, 193, 198, 1, 397, 2, 412, 6, 87, 14, 390, 189, 108, 198, 305, 4, 200, 99, 5, 207, 207, 188, 281, 404, 5, 91, 298, 5, 1, 403, 100, 324, 195, 94, 100, 99, 199, 199, 104, 201, 412, 398, 11, 307, 105, 302, 405, 397, 408, 1, 104, 211, 2, 12, 199, 103, 96, 212, 191, 404, 390, 303, 205, 302, 194, 109, 402, 83, 297, 86, 210, 101, 202, 288, 401, 203, 104, 100, 299, 298, 193, 300, 299, 299, 398, 1, 202, 301, 301, 207, 302, 210, 301, 97, 204, 101, 13, 136, 98, 299, 298, 95, 308, 310, 306, 193, 302, 291, 198, 203, 190, 210, 197, 97, 294, 101, 107, 309, 7, 91, 208, 295, 7, 310, 8, 192, 203, 200, 289, 100, 100, 294, 107, 108, 104, 103, 199, 197, 115, 106, 203, 194, 297, 97, 299, 307, 101, 92, 310, 295, 1, 103, 201, 96, 106, 309, 191, 293, 209, 102, 104, 113, 303, 291, 10, 4, 278, 186, 297, 196, 201, 113, 299, 195, 299, 98, 205, 200, 3, 2, 204, 195, 200, 301, 301, 1, 202, 301, 245, 205, 101, 242, 1, 97, 134, 207, 200, 107, 35, 91, 102, 3, 211, 207, 92, 97, 2, 199, 3, 102, 113, 218, 3, 187, 184, 105, 192, 8, 207, 197, 186, 6, 203, 80, 96, 175, 194, 212, 1, 201, 207, 215, 86, 18, 108, 182, 104, 198, 13, 107, 98, 195, 87, 15, 95, 190, 100, 1, 110, 1, 2, 205, 102, 93, 7, 206, 108, 107, 1, 1, 185, 14, 5, 83, 205, 4, 87, 101, 197, 96, 203, 200, 108, 7, 89, 198, 1, 201, 194, 193, 100, 106, 96, 77, 4, 1, 189, 198, 104, 121, 38, 101, 1, 97, 34, 107, 99, 21, 8, 91, 94, 7, 6, 103, 101, 102, 93, 97, 8, 1, 15, 87, 96, 8, 89, 13, 2, 21, 1, 89, 92, 12, 100, 123, 9, 91, 82, 87, 89, 97, 10, 6, 90, 82, 98, 102, 102, 99, 4, 93, 24, 99, 99, 74, 104, 116, 5, 10, 95, 99, 106, 99, 103, 82, 13, 108, 92, 1, 107, 104, 112, 100, 92, 91, 105, 75, 87, 103, 97, 100, 13, 9, 104, 7, 100, 98, 11, 101, 98, 97, 100, 106, 2, 83, 4, 1, 102, 98, 1, 3, 43, 42, 3, 2, 1, 2, 9, 9, 7, 23, 21, 1, 8, 1, 3, 16, 1, 11, 2, 1, 1, 1, 9, 1, 19, 13, 13, 7, 1, 1, 1, 1, 5, 1, 4, 11, 20, 1, 6, 17, 6, 5, 21, 4, 12, 1, 10, 1, 1, 14, 1, 10, 7, 8, 10, 1, 1, 1, 5, 11, 9, 1, 1, 1, 1, 1, 11, 1, 9, 1, 1, 1, 15, 1, 3, 3, 1, 9, 1, 1, 11, 1, 9, 4, 2, 6, 1, 3, 1, 4, 1, 7, 6, 3, 1, 2, 1, 1
        ];
        //sottratto -1 da matlab trasposizioni
        let input = generate_binary_vector(10000);
        println!("input {:?}", input);
        let out = mapint(10000, input, perm);
        println!("out {:?}", out);
    }

    #[test]
    fn test_turbo_simulation_with_10_bit_interleaver_pn_sequence() {
        // Configurazione
        //let perm: Vec<i32> = vec![0,3,0,6,5,2,0,1,0,0]; // Permutazione interleaver
        let perm: Vec<i32> = vec![1, 4, 1, 7, 6, 3, 1, 2, 1, 1]; // Permutazione interleaver
        let block_size = 10; // Blocchi di 10 bit
        let simulation_length = 100; // Simulazione per un totale di 10 bit
        let error_probability = 0.1; // Probabilità di errore 10%
        let iterations = 3; // Numero di iterazioni di decodifica
        let rate = 1; // Rate 1/3
        let kyber_input = kyber_encryption_generation();

        // Creazione dell'oggetto TurboSimulation
        let simulation = TurboSimulation::new(
            kyber_input,
            perm,
            block_size,
            simulation_length,
            error_probability,
            iterations,
            rate,
        );

        // Esecuzione della simulazione
        let error_rate = simulation.run_simulation();

        // Validazione dei risultati
        println!("Error rate: {:?}", error_rate);
        // assert!(error_rate >= 0.0 && error_rate <= 1.0, "Invalid error rate");
    }

    #[test]
    fn test_turbo_simulation_matlab_10000() {
        // Configurazione
        //let perm: Vec<i32> = vec![1,4,1,7,6,3,1,2,1,1]; // Permutazione interleaver

        let perm = vec![
            8701, 5201, 4800, 2901, 3201, 1404, 8402, 3303, 9003, 503, 3804, 1005, 9302, 2305, 6104, 5104, 3002, 9702, 4602, 4301, 604, 5504, 1503, 9601, 8900, 6005, 1303, 2005, 1605, 1103, 704, 7104, 3505, 9801, 2404, 4403, 7602, 2799, 5603, 2502, 3703, 6804, 7502, 8499, 8799, 7703, 204, 903, 9200, 2201, 8198, 6501, 9901, 5901, 7299, 5699, 6997, 5397, 3399, 6200, 2698, 3599, 3999, 2597, 7800, 9499, 99, 7397, 5795, 2096, 4098, 6698, 5295, 4497, 1895, 6900, 299, 3899, 1699, 400, 4700, 9399, 8004, 7203, 6601, 9100, 7903, 4199, 6399, 8102, 1, 8601, 4899, 1202, 8301, 1800, 800, 6301, 4998, 3101, 8701, 5201, 4800, 2901, 3201, 1404, 8401, 3303, 9003, 503, 3804, 1005, 9302, 2305, 6104, 5104, 3002, 9701, 4602, 4301, 604, 5504, 1503, 9602, 8900, 6006, 1304, 2005, 1605, 1103, 704, 7104, 3504, 9801, 2404, 4403, 7602, 2800, 5603, 2501, 3704, 6803, 7503, 8499, 8800, 7702, 203, 903, 9200, 2201, 8197, 6501, 5902, 7299, 5700, 6999, 5399, 3401, 6201, 2699, 3601, 3999, 2598, 7800, 9501, 100, 7398, 5797, 2097, 4099, 6699, 5296, 4498, 1897, 6901, 299, 3900, 1699, 401, 4701, 9400, 4599, 8003, 7204, 6602, 9100, 7903, 4199, 6399, 8102, 2, 8601, 4898, 1202, 8301, 1800, 800, 6301, 4998, 3101, 8701, 5201, 4800, 2901, 3201, 1404, 8401, 3303, 3606, 9002, 502, 3803, 1004, 9301, 2304, 6103, 5103, 3002, 9700, 4602, 4300, 603, 5503, 1502, 9600, 8899, 6005, 1304, 2003, 1603, 1102, 702, 7103, 3503, 2403, 4404, 7601, 2800, 5603, 2500, 3703, 6802, 7503, 8499, 8800, 7701, 203, 903, 9200, 2201, 8197, 6501, 5902, 7299, 5701, 6999, 5399, 3400, 6200, 2699, 3602, 3999, 2598, 7800, 9501, 99, 7399, 5797, 2097, 4099, 6698, 5297, 4497, 1897, 6902, 299, 3900, 1699, 401, 4700, 9401, 4499, 8003, 7204, 6602, 9100, 7902, 4199, 6399, 8101, 2, 8601, 4898, 1202, 8301, 1800, 800, 6301, 4998, 3101, 8701, 5201, 4800, 2901, 3201, 1404, 8402, 3302, 3606, 9001, 502, 3803, 1004, 9301, 2303, 6103, 5103, 3002, 4602, 4302, 603, 5504, 1502, 9601, 8900, 6006, 1305, 2005, 1604, 1104, 703, 7103, 3505, 2403, 4404, 7601, 2801, 5604, 2501, 3704, 6804, 7503, 2108, 8499, 8800, 7701, 203, 902, 9200, 2202, 8197, 6501, 5902, 7300, 5701, 7000, 5399, 3401, 6200, 2699, 3601, 4000, 2598, 7799, 9501, 98, 7400, 5797, 2097, 4100, 6698, 5297, 4497, 1897, 6902, 299, 3899, 1700, 401, 4699, 9401, 4399, 8002, 7204, 6602, 9100, 7902, 4199, 6400, 8101, 2, 8601, 4898, 1202, 8301, 1800, 800, 6301, 4999, 3101, 8701, 5201, 4801, 2901, 3200, 1403, 8402, 3302, 304, 9001, 502, 3803, 1005, 9301, 2303, 6103, 5103, 3002, 4602, 4302, 603, 5504, 1502, 8901, 6007, 1306, 2006, 1606, 1106, 704, 7104, 3505, 2403, 4405, 7602, 2803, 5605, 2503, 3704, 6805, 7503, 9107, 8501, 8801, 7701, 204, 903, 9202, 2202, 8198, 6501, 5903, 7302, 5702, 7000, 5400, 3403, 6201, 2700, 3601, 4002, 2599, 7800, 9503, 99, 7401, 5799, 2099, 4100, 6700, 5298, 4497, 1898, 6904, 300, 3900, 1701, 402, 4700, 9402, 4300, 8003, 7205, 6603, 9101, 7902, 4200, 6401, 8102, 7702, 2, 8601, 4899, 1202, 8301, 1800, 800, 6301, 4999, 3101, 8701, 5201, 4801, 2901, 3200, 1403, 8402, 3302, 304, 9001, 501, 3803, 1005, 9300, 2302, 6103, 5103, 3002, 4603, 4303, 603, 5504, 1502, 8901, 6007, 1305, 2006, 1606, 1107, 704, 7104, 3505, 2404, 4404, 7601, 2803, 5605, 2503, 3704, 6805, 7503, 2109, 8501, 8801, 7700, 205, 904, 9202, 2201, 8198, 6500, 5902, 7301, 5702, 7000, 5401, 3402, 6201, 2700, 3600, 4002, 2598, 7799, 100, 7401, 5800, 2100, 4101, 6701, 5299, 4497, 1899, 3998, 6904, 300, 3901, 1701, 402, 4700, 9403, 7904, 8003, 7206, 6604, 9102, 7902, 4200, 6401, 8101, 8203, 2, 8601, 4899, 1202, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2901, 3200, 1403, 8402, 3302, 304, 9001, 501, 3803, 1005, 9300, 2303, 6103, 5103, 3001, 4603, 4302, 603, 5505, 1502, 8901, 6007, 1305, 2005, 1605, 1107, 704, 7104, 3504, 2404, 4403, 7600, 2803, 5605, 2503, 3705, 6804, 7502, 7405, 8501, 8801, 7699, 205, 905, 9202, 2201, 8199, 6501, 5902, 7300, 5702, 7001, 5401, 3401, 6201, 2700, 3600, 4002, 2598, 7799, 100, 7401, 5799, 8898, 2099, 4099, 6701, 5299, 4496, 1899, 6402, 6903, 299, 3900, 1700, 401, 4700, 7904, 8002, 7206, 6604, 9102, 7902, 4200, 6401, 8101, 8203, 2, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2900, 3200, 8306, 1402, 8401, 3301, 302, 9000, 500, 3802, 1004, 2302, 6103, 5103, 3001, 4603, 4302, 602, 5505, 1501, 8902, 6007, 1305, 2004, 1606, 1106, 705, 7103, 3504, 2404, 4404, 7600, 2804, 5605, 2504, 3706, 6804, 7501, 2108, 8501, 8801, 7699, 204, 906, 9202, 2202, 8200, 6501, 5902, 7300, 5701, 7002, 5401, 3400, 6200, 2701, 3601, 4001, 2598, 7799, 100, 7400, 5799, 6798, 2099, 4099, 6701, 5299, 4496, 1899, 6403, 6903, 299, 3900, 1700, 401, 4700, 7903, 8002, 7205, 6605, 9102, 7901, 4199, 6402, 8101, 8203, 2, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2900, 3200, 8306, 1402, 8401, 3301, 302, 8999, 500, 3802, 1003, 2302, 6103, 5103, 3002, 4603, 4303, 603, 5505, 1502, 8903, 6007, 1305, 2003, 1606, 1106, 706, 7102, 3505, 2405, 4404, 7601, 2803, 5605, 2504, 3706, 6805, 7500, 8108, 8501, 8802, 7699, 204, 905, 2203, 8201, 6502, 5903, 7300, 5702, 7002, 5402, 3401, 6201, 2703, 3603, 4002, 2600, 7800, 101, 7401, 5800, 6800, 2100, 4099, 6702, 5300, 4498, 1900, 3296, 1397, 6904, 299, 3899, 1701, 400, 4701, 7903, 8002, 7205, 6605, 9102, 7901, 4198, 6402, 8101, 8203, 2, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2900, 3200, 2909, 1402, 8400, 3301, 8801, 8999, 501, 3802, 1003, 2303, 6103, 5103, 3002, 4603, 4303, 603, 5505, 1502, 8902, 6006, 1304, 2004, 1606, 1107, 707, 7102, 3505, 2405, 4404, 7600, 2803, 5605, 2504, 3707, 6805, 7501, 6410, 8501, 8802, 7699, 204, 904, 2203, 8201, 6501, 5903, 7300, 5702, 7001, 5402, 3402, 6202, 2702, 3603, 4001, 2601, 7800, 101, 7400, 5800, 7297, 2100, 4098, 6702, 5301, 4498, 6493, 1899, 4494, 1396, 6903, 297, 3898, 1700, 399, 4700, 7902, 8001, 7203, 6604, 7901, 4198, 6403, 8101, 8203, 2, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2900, 3200, 2909, 1402, 8400, 3301, 8800, 502, 1307, 3803, 1003, 2303, 6103, 5104, 3002, 4603, 4303, 603, 5505, 1502, 8902, 6005, 1305, 2004, 1605, 1107, 707, 7101, 3505, 2405, 4404, 7600, 2804, 5605, 2505, 3706, 6804, 7500, 611, 8501, 8802, 7699, 203, 903, 2204, 8202, 6501, 5902, 7299, 5702, 7001, 5401, 3403, 6202, 2703, 3603, 4000, 2601, 7801, 101, 7400, 5800, 7296, 2099, 4098, 6703, 5301, 4499, 1194, 1899, 4495, 3496, 6902, 297, 3897, 1700, 400, 4700, 7802, 8001, 7203, 6604, 7901, 4198, 6403, 8101, 8203, 2, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2900, 3200, 106, 1402, 8400, 3301, 8800, 502, 1307, 3802, 1003, 2303, 6103, 5104, 3002, 4603, 4303, 603, 5505, 1501, 6006, 1306, 2005, 1605, 1107, 707, 7101, 3507, 2407, 4406, 7601, 2804, 5606, 2505, 3707, 6804, 7501, 611, 8503, 8803, 7701, 204, 905, 2205, 8203, 6503, 5902, 7300, 5703, 7001, 5402, 4600, 3403, 6203, 2704, 3602, 4000, 2602, 7801, 100, 7400, 5799, 6800, 2099, 4098, 6703, 5300, 4499, 1194, 1899, 5895, 1397, 6902, 298, 3896, 1700, 401, 4700, 7702, 8000, 7202, 6605, 7901, 4199, 6403, 8101, 8203, 2, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5000, 3101, 8701, 5201, 4801, 2900, 3200, 106, 1401, 8400, 3301, 8600, 502, 8303, 3802, 1002, 2303, 6103, 5104, 3002, 4603, 4303, 602, 5505, 1500, 6006, 1306, 2006, 1604, 1108, 707, 7101, 3506, 2406, 4406, 7601, 2804, 5606, 2505, 3706, 6804, 7501, 6411, 8503, 7703, 206, 905, 2206, 8204, 6505, 5904, 7301, 5703, 7002, 5403, 5901, 3405, 6203, 2704, 3603, 4001, 2604, 7802, 101, 7401, 5800, 6801, 2100, 4099, 6703, 5301, 4500, 4894, 1899, 5897, 1398, 6902, 300, 3897, 1701, 5697, 401, 4701, 7602, 8000, 7202, 6605, 7901, 4199, 6403, 8101, 8203, 1, 8601, 4900, 1201, 8301, 1800, 800, 6301, 5001, 3101, 5202, 4802, 2901, 3201, 108, 1402, 8401, 3302, 8601, 502, 8304, 3803, 1003, 1705, 2302, 6103, 5104, 3002, 4603, 4303, 602, 5505, 1499, 6006, 1305, 2006, 1605, 1108, 708, 7102, 3506, 2406, 4406, 7602, 2803, 5605, 2506, 3705, 6803, 7501, 6412, 8503, 7703, 207, 904, 2207, 8204, 6504, 5904, 7301, 5702, 7001, 5403, 4302, 3404, 6203, 2703, 3602, 4001, 2603, 7802, 102, 7401, 5801, 6800, 2101, 4099, 6703, 5301, 4500, 4895, 1899, 4496, 2795, 6902, 301, 3897, 1701, 2698, 401, 4701, 4600, 8000, 7202, 6604, 7901, 4200, 6404, 8101, 8203, 1, 8601, 4901, 1201, 8301, 1799, 800, 6301, 5001, 3101, 5202, 4802, 2901, 3201, 2605, 1402, 8401, 3302, 8401, 502, 8304, 3803, 1003, 1705, 2302, 6103, 5104, 3002, 4603, 4303, 602, 5504, 1500, 6005, 1304, 2006, 1605, 1108, 708, 7101, 3505, 2407, 4406, 7602, 2803, 5604, 2505, 3706, 6802, 7502, 610, 8503, 7703, 208, 904, 2206, 8205, 6503, 5904, 7301, 5703, 7001, 5403, 5902, 3404, 6204, 2702, 3601, 4001, 2603, 7803, 103, 7402, 5801, 5200, 2102, 4100, 6702, 5302, 4501, 1196, 1899, 5898, 1398, 6901, 300, 3898, 1700, 2698, 400, 4701, 4600, 7998, 7999, 7200, 6603, 7900, 4199, 6403, 8100, 8202, 8201, 4901, 1201, 8301, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3200, 2604, 1402, 8400, 3302, 302, 501, 1305, 3802, 1002, 3805, 2302, 6102, 5103, 3001, 4603, 4302, 601, 5503, 1499, 6004, 1302, 2005, 1604, 1106, 706, 7100, 3503, 2405, 4405, 7601, 2803, 5604, 2504, 3705, 6800, 7501, 608, 7703, 207, 904, 2207, 8205, 6503, 5903, 7302, 5703, 7001, 5402, 4302, 3403, 6205, 2702, 3601, 4002, 2602, 7803, 104, 7402, 5802, 5200, 2102, 4100, 6702, 5302, 4501, 7994, 1900, 5898, 1398, 6901, 299, 3898, 1700, 2697, 400, 4702, 4500, 6603, 7999, 7200, 6602, 7900, 4199, 6403, 8101, 8202, 8201, 4901, 1201, 8301, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3201, 2604, 1402, 3302, 8106, 502, 1307, 3803, 1002, 3806, 2303, 6103, 5104, 3002, 4604, 4303, 601, 5504, 1500, 6005, 1304, 2005, 1606, 1106, 708, 7101, 3505, 2406, 4407, 7602, 2805, 5605, 2504, 3706, 6802, 7502, 6108, 607, 7703, 206, 905, 2208, 8205, 6502, 5903, 7303, 5704, 7001, 5402, 4303, 3402, 6204, 2703, 3601, 4002, 2602, 7803, 103, 7402, 5802, 5200, 2103, 4100, 6701, 5301, 4501, 5894, 1900, 4497, 1398, 6901, 299, 3899, 1700, 2697, 401, 4702, 6504, 6603, 8000, 7200, 6602, 7900, 4199, 6403, 8101, 7802, 7801, 4901, 1201, 8301, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3200, 7702, 1402, 3302, 303, 501, 1306, 3803, 1002, 3806, 2303, 6103, 5104, 3002, 4604, 4303, 602, 5504, 1501, 6005, 1304, 2005, 1606, 1105, 708, 7101, 3505, 2405, 4407, 7602, 2805, 5605, 2504, 5108, 3704, 6800, 7501, 6106, 1909, 7702, 204, 903, 2206, 8204, 6501, 5903, 7302, 5702, 7000, 5402, 4302, 3401, 6202, 2703, 3600, 4001, 2602, 7802, 101, 7401, 5801, 5198, 2103, 4099, 6700, 5300, 4501, 1195, 1899, 4497, 1396, 6900, 299, 3898, 1699, 2697, 400, 4700, 6503, 6601, 7999, 7199, 6600, 7900, 4198, 6401, 8100, 7801, 8098, 4900, 1200, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3200, 7702, 1403, 3302, 1109, 501, 1306, 3803, 1002, 1706, 2303, 6102, 5104, 3003, 4604, 4304, 602, 5504, 1501, 213, 6003, 1303, 2005, 1605, 1105, 707, 7101, 3504, 2404, 4406, 7601, 2805, 5603, 2504, 5106, 3704, 6799, 7500, 6104, 7908, 7701, 204, 901, 2205, 6500, 5904, 7302, 5702, 7001, 5402, 4302, 3401, 6202, 2703, 3600, 4001, 2603, 7803, 100, 7402, 5802, 5198, 2102, 4100, 6700, 5301, 4501, 1195, 1900, 4497, 1396, 6900, 299, 3898, 1699, 3588, 400, 4700, 6403, 5804, 7999, 7199, 6600, 7900, 4198, 6401, 8100, 7698, 6398, 4900, 1200, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2901, 3200, 7702, 1403, 3302, 1108, 501, 7404, 1306, 3802, 1002, 1704, 2302, 6101, 5103, 3001, 4603, 4303, 601, 5503, 1500, 6606, 6001, 1303, 2003, 1604, 1104, 705, 7100, 3503, 2404, 4405, 7600, 2803, 5602, 2504, 5104, 3704, 6798, 7499, 7201, 6205, 7701, 202, 900, 2203, 6499, 5902, 7302, 5702, 7001, 5402, 2301, 3400, 6200, 2702, 3600, 4001, 2602, 7802, 100, 7401, 5802, 5198, 2101, 4099, 6699, 5300, 4499, 1193, 1900, 4495, 5395, 6900, 298, 3897, 1698, 3588, 399, 4699, 4598, 5804, 7998, 7197, 6599, 7899, 4197, 6399, 7699, 4194, 4900, 1199, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3201, 2604, 1403, 3302, 302, 501, 7404, 5, 3802, 1001, 1704, 2302, 6100, 5103, 3001, 4603, 4303, 600, 5503, 1500, 4207, 6001, 1303, 2003, 1603, 1104, 704, 7100, 3504, 2404, 4405, 7601, 2803, 5603, 2504, 5105, 3704, 6798, 7499, 6102, 1908, 7701, 201, 901, 2203, 6499, 5901, 7302, 5703, 7001, 5401, 2302, 3400, 6200, 2701, 3600, 4001, 2602, 7802, 99, 7401, 5802, 4598, 2100, 4099, 6699, 5301, 4499, 1193, 1899, 4495, 896, 6900, 298, 3898, 1698, 4988, 399, 4700, 297, 5804, 6001, 7197, 6598, 7899, 4198, 6399, 7699, 6397, 4900, 1199, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3201, 1205, 2603, 1402, 3301, 301, 499, 5207, 4, 3801, 1000, 1704, 2301, 6099, 5102, 3001, 4602, 4302, 599, 5502, 1498, 3010, 5999, 1302, 2002, 1602, 1104, 702, 7099, 3503, 2403, 4404, 7601, 2801, 5602, 2504, 5803, 3703, 6798, 7499, 6100, 2106, 7700, 200, 900, 2203, 6498, 5900, 7301, 5701, 7000, 5400, 2302, 3400, 6198, 2700, 3599, 4000, 2600, 7802, 98, 7401, 5800, 1500, 2099, 4099, 6699, 5300, 4498, 1192, 1898, 4494, 6399, 6899, 297, 3897, 1697, 5697, 399, 4699, 4598, 5802, 5201, 7196, 6597, 4198, 6399, 5999, 6397, 4900, 1199, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2900, 3201, 1205, 7701, 1401, 3301, 301, 499, 5207, 3, 3801, 1001, 3804, 2301, 6099, 2402, 5101, 3000, 4601, 4301, 597, 5501, 1497, 206, 5997, 1301, 2001, 1602, 1103, 702, 7098, 3502, 2403, 4403, 7600, 2799, 5600, 2502, 5802, 3702, 6797, 7499, 6098, 5903, 7699, 199, 899, 2203, 6497, 5898, 7300, 5699, 7000, 5400, 2301, 3399, 6197, 2698, 3598, 4000, 2599, 98, 7402, 5800, 3499, 2099, 4099, 6699, 5300, 4499, 1193, 1898, 3695, 3994, 6898, 298, 3897, 1697, 5696, 399, 4699, 297, 5802, 5201, 7196, 6597, 4197, 6398, 3795, 6396, 4900, 1199, 1799, 800, 6301, 5001, 3101, 7201, 5201, 4801, 2901, 3201, 1205, 2603, 1401, 3301, 101, 499, 4209, 706, 3801, 1001, 3805, 2301, 6100, 2402, 5101, 3000, 4601, 4301, 598, 5500, 1498, 6905, 5997, 1300, 2002, 1601, 1103, 702, 7098, 3502, 2402, 4403, 7600, 2800, 5599, 2502, 5801, 3702, 6797, 7499, 6804, 7400, 201, 901, 2204, 6499, 5899, 7302, 5700, 7001, 5402, 2303, 3400, 6198, 2698, 3600, 4001, 2599, 99, 7403, 5800, 4597, 2101, 4099, 6700, 5301, 4500, 3194, 1898, 7190, 1397, 6899, 299, 3899, 1698, 5697, 400, 4700, 298, 6599, 5202, 7197, 6598, 4198, 6399, 7497, 7496, 2599, 4900, 1199, 1799, 799, 6301, 5001, 3101, 7201, 5201, 4801, 2901, 3201, 1204, 2603, 1401, 3301, 3100, 500, 7402, 1304, 3801, 1001, 3805, 2301, 6099, 7500, 5101, 3000, 4601, 4301, 598, 5499, 1497, 2113, 5998, 1300, 2002, 1601, 1103, 702, 7098, 3502, 2402, 4403, 2801, 5600, 2502, 409, 3703, 6798, 7500, 6806, 5799, 201, 902, 2206, 6501, 5899, 7303, 5700, 7002, 5402, 2303, 3401, 6199, 2699, 3601, 4001, 2599, 101, 7404, 5801, 5201, 2101, 4100, 7197, 6700, 5302, 4499, 5797, 1898, 1097, 690, 6899, 299, 3899, 1698, 5696, 400, 4701, 4599, 6599, 4601, 7198, 6598, 4198, 6399, 3797, 3796, 7203, 4901, 1199, 1799, 799, 6301, 5001, 3101, 7201, 5201, 4801, 2901, 3201, 1204, 703, 1401, 3301, 3100, 500, 7402, 2807, 3801, 1001, 3805, 2302, 6099, 2402, 5101, 3000, 4601, 4301, 598, 5499, 1497, 3713, 5997, 1301, 2002, 1601, 1102, 703, 7099, 3503, 2401, 4402, 2801, 5599, 2501, 6409, 3703, 6798, 6100, 6496, 201, 903, 2206, 5700, 6501, 5899, 7303, 5700, 7002, 5401, 5104, 3402, 6199, 2699, 3601, 4001, 2599, 101, 7405, 5800, 7299, 2101, 4100, 3396, 6701, 5302, 4499, 4397, 1899, 3697, 1397, 6898, 299, 3898, 1697, 5696, 400, 4700, 4600, 6598, 4602, 7198, 6597, 4199, 6399, 3797, 3796, 7203, 4901, 1199, 1799, 799, 6301, 5001, 3101, 7201, 5201, 4801, 2901, 3201, 1204, 703, 1401, 3301, 3100, 500, 4209, 1305, 3801, 1000, 3805, 2301, 6099, 2402, 5101, 3000, 4601, 4301, 599, 5498, 1497, 6298, 1710, 5996, 1299, 2002, 1600, 1101, 702, 7099, 3502, 2399, 4400, 2800, 5597, 2501, 5800, 3702, 6797, 6099, 6495, 200, 903, 2205, 5698, 6500, 5898, 7303, 5698, 7002, 5400, 1602, 3401, 6199, 2698, 3601, 4000, 2598, 100, 5800, 6800, 2100, 4100, 3396, 6701, 5301, 4500, 3194, 1899, 4496, 690, 6898, 299, 3898, 1697, 490, 400, 4701, 4599, 6199, 4602, 7198, 6597, 4199, 6399, 3796, 3795, 7203, 4901, 1199, 1799, 799, 6301, 5001, 3101, 7201, 5201, 4801, 2901, 3201, 1204, 703, 1401, 3301, 3100, 501, 5206, 1305, 3801, 1000, 1704, 2301, 6099, 2104, 5100, 3000, 4601, 4301, 599, 5498, 1497, 6298, 508, 5996, 1299, 2001, 1601, 1102, 702, 7098, 3502, 2400, 4401, 2801, 5597, 2501, 5799, 3702, 6797, 5107, 6505, 201, 902, 2204, 4003, 6501, 5898, 5699, 7003, 5400, 2503, 3402, 6200, 2699, 3602, 4001, 2599, 101, 5801, 7201, 2101, 4101, 4999, 6701, 5302, 4501, 1197, 1900, 5895, 692, 6900, 300, 3899, 1699, 2695, 400, 4702, 4601, 3198, 4604, 7199, 6598, 4200, 6400, 5999, 1, 7204, 4902, 5602, 1199, 1799, 799, 6301, 5001, 3101, 3702, 5201, 4801, 2901, 3201, 6303, 1903, 1401, 3301, 1199, 502, 1406, 707, 3801, 1001, 3805, 2301, 6099, 2103, 5099, 3000, 4601, 4301, 599, 5498, 1498, 6998, 1404, 5996, 1299, 2001, 1601, 1101, 702, 7098, 3502, 2400, 4401, 2801, 5598, 2501, 6211, 3702, 6798, 4508, 6405, 201, 903, 2203, 5698, 6501, 5898, 5699, 7003, 5400, 5103, 3402, 6200, 2700, 3601, 4001, 2599, 101, 5801, 1998, 2100, 4100, 4999, 6702, 5301, 4502, 4896, 1899, 4498, 1397, 6900, 299, 3900, 1699, 498, 1096, 399, 4701, 4500, 6596, 4603, 6598, 4200, 6400, 5999, 1, 103, 4902, 300, 1199, 1799, 799, 6301, 5001, 3101, 3702, 5201, 4801, 2901, 3201, 6303, 7001, 1401, 3301, 1199, 502, 1904, 3, 3801, 1001, 1704, 2301, 6099, 2103, 5099, 3000, 4601, 4301, 599, 5499, 1498, 6298, 6404, 5997, 1299, 2000, 1601, 1101, 701, 3503, 2401, 4402, 2802, 5598, 2501, 5800, 3703, 6800, 5908, 5799, 202, 905, 2205, 4003, 6502, 5900, 5700, 7005, 5400, 2302, 3403, 6201, 2701, 3602, 4001, 2601, 102, 5802, 2097, 2100, 4101, 3399, 6704, 5302, 4503, 3694, 1900, 5897, 1398, 6901, 300, 3901, 1700, 2697, 2299, 400, 4702, 4601, 6599, 5202, 6599, 4202, 6401, 3499, 5999, 1, 3802, 4902, 300, 1199, 1799, 799, 6301, 5001, 3101, 5701, 5201, 4801, 2901, 3201, 6302, 1903, 1401, 3301, 1199, 502, 1903, 2, 3801, 1001, 1704, 2301, 6099, 2104, 5098, 3000, 4601, 4301, 598, 5498, 1498, 3405, 2809, 3011, 5996, 1299, 1998, 1601, 1099, 700, 3502, 2400, 4400, 2801, 5597, 2501, 5799, 3702, 6799, 1709, 6495, 202, 903, 2204, 4001, 6501, 5900, 5699, 5400, 4302, 3402, 6202, 2701, 3602, 4001, 2601, 101, 5803, 6804, 2100, 4102, 3398, 6704, 5301, 4503, 4896, 1899, 5897, 3198, 6902, 300, 3901, 1699, 994, 3597, 400, 4703, 4501, 6600, 5202, 6600, 4202, 6401, 5203, 5999, 1, 3802, 4902, 300, 1199, 1799, 799, 6301, 5001, 3101, 5701, 5201, 4801, 2901, 3201, 703, 1903, 1401, 3301, 3100, 501, 1903, 2802, 3801, 1001, 3805, 2301, 6099, 2403, 5098, 3001, 4601, 4301, 2402, 597, 5497, 1498, 1809, 1802, 3010, 5995, 1298, 1998, 1599, 1098, 700, 3501, 2400, 4399, 2800, 5596, 2501, 5406, 3701, 6798, 607, 6495, 201, 902, 2203, 4001, 6501, 5899, 5699, 5399, 1202, 3401, 6201, 2700, 3601, 4001, 2600, 100, 5802, 5200, 2099, 4101, 3397, 6703, 5300, 4502, 4895, 1897, 4498, 3996, 300, 3901, 1699, 5698, 3598, 400, 4703, 4401, 5201, 5201, 6600, 4203, 6401, 5202, 5599, 5598, 2601, 4902, 300, 1199, 1799, 799, 6301, 5001, 3101, 5701, 5201, 4801, 2901, 3201, 703, 3, 1401, 3301, 3100, 501, 104, 3, 3801, 1001, 4802, 2301, 6099, 2403, 5098, 3001, 4600, 4301, 2402, 598, 5497, 1498, 1405, 2809, 603, 5995, 1298, 1998, 1599, 1099, 699, 3501, 2400, 4399, 2801, 5596, 2501, 708, 3700, 5298, 6606, 5497, 201, 901, 2202, 3403, 6501, 5899, 5700, 5399, 5899, 3401, 6201, 2701, 3601, 4001, 2600, 100, 5802, 5200, 2099, 4102, 4398, 6704, 5300, 4503, 3692, 1897, 4499, 192, 300, 3902, 1698, 6286, 1398, 400, 4702, 4602, 5002, 5998, 6600, 4203, 6402, 5202, 5599, 5598, 2601, 4902, 300, 1199, 1798, 799, 6301, 5001, 3101, 5701, 5200, 4801, 2901, 3201, 4, 503, 1401, 3301, 3100, 501, 5905, 5804, 3801, 1001, 4801, 2301, 6099, 2403, 5099, 3001, 4599, 4301, 6403, 597, 5497, 1499, 701, 7, 5702, 5995, 1299, 1998, 1598, 1099, 699, 3501, 2400, 4399, 2801, 5597, 2501, 6003, 3699, 5298, 205, 1407, 202, 901, 2203, 4801, 6501, 5900, 5700, 5399, 4598, 3401, 6201, 2701, 3600, 4002, 2601, 101, 5802, 6601, 2099, 4102, 4895, 5301, 4504, 1197, 1898, 3698, 898, 301, 3903, 1698, 5699, 88, 401, 4703, 4602, 3299, 5999, 6601, 4204, 6403, 899, 4803, 5599, 5598, 2601, 4902, 300, 1199, 1798, 799, 6301, 5001, 3101, 5701, 5200, 4801, 2901, 3201, 6302, 503, 1402, 3301, 2900, 501, 104, 304, 3801, 1001, 1002, 2301, 6099, 2403, 5098, 3001, 4599, 4301, 2402, 597, 5497, 1498, 5397, 1309, 2509, 5995, 1298, 1998, 1597, 1099, 698, 3500, 2400, 4398, 2801, 5597, 2501, 4405, 3700, 5298, 6100, 6496, 201, 902, 2203, 4801, 6501, 5900, 5700, 5400, 5900, 3401, 6202, 2701, 3600, 4001, 2601, 102, 5803, 1398, 2100, 4102, 4894, 5301, 4503, 3197, 1899, 3699, 6402, 301, 3904, 1698, 5698, 5797, 401, 4702, 4502, 595, 5999, 5701, 4204, 6403, 3100, 5304, 5599, 5598, 2601, 4901, 300, 1199, 1798, 799, 6301, 5001, 3101, 5701, 5201, 4801, 2901, 3201, 6302, 5602, 1401, 3301, 302, 501, 1908, 1807, 3801, 1001, 2504, 2301, 6099, 2403, 5098, 3001, 4598, 4300, 2402, 597, 5497, 1498, 2, 1309, 2109, 5995, 1299, 1999, 1598, 1100, 698, 3499, 2400, 4397, 2801, 5597, 2501, 5097, 3700, 5406, 5298, 5598, 6304, 201, 902, 2202, 4799, 5900, 5701, 5401, 4301, 3400, 6202, 2702, 3601, 4001, 2601, 102, 5803, 1500, 2100, 4103, 4398, 5302, 4503, 3197, 1899, 396, 6403, 302, 3904, 1698, 6388, 5797, 401, 4702, 4402, 3300, 5201, 4505, 4205, 6403, 3100, 5304, 4801, 4800, 6301, 4901, 5602, 1199, 1799, 799, 6301, 5001, 3101, 5701, 5201, 4801, 2901, 3201, 703, 6301, 1401, 3301, 302, 501, 1908, 3208, 3801, 1001, 2505, 2301, 6099, 2104, 5098, 3001, 4598, 4299, 4199, 597, 5497, 1499, 704, 1101, 4105, 5996, 1298, 1999, 1598, 1099, 699, 3500, 2401, 4397, 2801, 5597, 2501, 2002, 3700, 5299, 5299, 306, 804, 5600, 201, 901, 2201, 3202, 5899, 5700, 5400, 4003, 3399, 6201, 2701, 3600, 4001, 2601, 102, 5802, 1499, 2099, 4103, 4397, 5301, 4501, 4095, 1899, 4094, 3997, 300, 3903, 1698, 5997, 6096, 400, 4700, 4301, 3299, 5200, 4503, 4204, 3101, 5304, 4801, 4800, 6301, 4901, 5602, 1199, 1799, 799, 6301, 5001, 3101, 5701, 5201, 4800, 2901, 3201, 703, 1203, 1401, 3301, 302, 501, 2903, 4205, 3801, 1001, 2505, 2301, 6098, 2404, 5098, 3001, 4598, 4299, 3902, 598, 5497, 1499, 2412, 202, 4104, 5997, 1297, 1999, 1598, 1099, 699, 3500, 2401, 4396, 2801, 5597, 2501, 5097, 3699, 5299, 5299, 5896, 5798, 5600, 200, 902, 2201, 3201, 5900, 5700, 5400, 5900, 3400, 6202, 2700, 3601, 4002, 2601, 103, 5803, 5200, 2099, 4103, 4396, 5301, 4501, 4095, 1899, 1098, 3998, 300, 3903, 1698, 2698, 1096, 400, 4700, 4599, 4686, 5999, 4503, 4204, 4803, 5304, 4402, 4401, 5901, 4901, 5602, 1199, 1800, 799, 4497, 5001, 3101, 5701, 5201, 4800, 2901, 3201, 703, 1203, 1401, 3301, 102, 501, 1903, 405, 3801, 1002, 2505, 2301, 6098, 2104, 5098, 3001, 4599, 4298, 2700, 598, 5497, 1499, 5398, 202, 4103, 5996, 1298, 1999, 1598, 1098, 699, 3500, 2401, 4395, 2801, 5597, 2501, 4101, 3699, 5299, 4997, 2098, 5297, 5600, 200, 901, 2201, 3200, 5900, 5700, 5401, 5900, 3400, 2701, 3601, 4002, 2601, 103, 5805, 5201, 2101, 4103, 3802, 5302, 4501, 5801, 1900, 1098, 398, 301, 3905, 1700, 2699, 1096, 400, 4701, 4600, 3200, 3804, 802, 4205, 4803, 5305, 4904, 1, 5902, 4902, 5603, 1199, 1801, 800, 97, 5002, 1198, 3101, 5701, 5201, 4801, 2901, 3201, 5602, 702, 1401, 3301, 102, 501, 1903, 3, 3801, 1001, 3499, 2301, 2105, 5099, 3002, 4599, 4299, 1998, 599, 5498, 1500, 4698, 810, 3312, 5997, 1299, 2000, 1600, 1098, 701, 5899, 3499, 2401, 4395, 2801, 5597, 2501, 3897, 3700, 5600, 5299, 2098, 4997, 3204, 199, 901, 2201, 4500, 5900, 5701, 5401, 5900, 3401, 2701, 3601, 4001, 2601, 103, 5805, 5201, 2101, 4103, 1699, 5303, 4501, 5801, 1900, 3700, 5902, 300, 3905, 1700, 500, 1095, 400, 4701, 4500, 3201, 2598, 802, 4204, 4803, 5305, 4904, 1, 5502, 4902, 3402, 1199, 1801, 800, 97, 5002, 1198, 3101, 5701, 5201, 4801, 2901, 3201, 5602, 702, 1401, 3301, 402, 501, 1911, 2802, 3801, 1001, 3499, 2301, 2405, 5099, 3002, 4599, 4299, 2404, 600, 5498, 1501, 5399, 1104, 3312, 1300, 2002, 1601, 1100, 701, 5900, 3500, 2402, 4397, 2802, 1602, 5598, 2501, 3896, 3700, 5601, 5299, 5897, 5595, 5601, 199, 900, 2201, 2902, 5901, 5701, 5401, 1200, 3400, 2701, 3602, 4001, 2601, 102, 5805, 798, 2101, 4102, 4301, 5303, 4501, 3197, 1901, 3701, 5903, 300, 3904, 1700, 500, 1095, 401, 4701, 4400, 3200, 3805, 802, 4204, 4803, 5305, 4904, 1, 5502, 4902, 3402, 1199, 1801, 800, 97, 5002, 1198, 3101, 5701, 5201, 4801, 2901, 3201, 504, 703, 1401, 3301, 402, 501, 3307, 1802, 3800, 1001, 701, 2301, 802, 5099, 3002, 4599, 4300, 2404, 600, 5498, 1501, 5399, 4197, 5307, 1300, 2003, 1601, 1100, 701, 300, 3500, 2402, 4396, 2801, 1602, 5599, 2501, 909, 3699, 5299, 5299, 4894, 4997, 5601, 200, 899, 2201, 1804, 5702, 5402, 3201, 3401, 2702, 3604, 4001, 2602, 103, 5807, 1502, 2103, 4103, 5004, 5303, 4502, 3199, 1902, 396, 3595, 302, 3905, 1701, 1499, 1096, 402, 4702, 4301, 1800, 2600, 3103, 801, 4203, 4803, 5202, 4904, 1, 5800, 4902, 3402, 1200, 1801, 800, 97, 5002, 1199, 3101, 5701, 5201, 4801, 2901, 3201, 2204, 702, 1401, 3301, 202, 501, 2309, 2802, 3800, 1001, 404, 2301, 802, 5099, 3002, 4599, 4299, 2404, 601, 5499, 1501, 303, 4198, 2111, 1301, 2003, 1601, 1100, 700, 3102, 3500, 2402, 4396, 2800, 1602, 5599, 2501, 2002, 3698, 5299, 4198, 5194, 1797, 5601, 201, 900, 2200, 4500, 5703, 5403, 4298, 3402, 2701, 3603, 4001, 2602, 1096, 103, 901, 2103, 4102, 2797, 5304, 4502, 3199, 1902, 1099, 599, 302, 3904, 1702, 1696, 2800, 402, 4702, 1701, 3102, 3994, 2503, 800, 4203, 4803, 5202, 4504, 1, 4099, 4902, 4103, 1200, 1801, 799, 4097, 5002, 1199, 3101, 2202, 5201, 4801, 2901, 3201, 2004, 5601, 1401, 3301, 202, 502, 5502, 2802, 3799, 1001, 700, 2301, 2903, 5099, 3002, 4599, 4299, 2404, 600, 5498, 1501, 304, 4197, 1608, 1301, 2003, 1601, 1100, 699, 5598, 3499, 2402, 4396, 2801, 1602, 5599, 2501, 799, 3698, 5601, 4198, 2098, 5596, 5103, 201, 900, 2199, 3201, 2199, 5403, 4298, 3403, 2701, 3602, 4000, 2601, 3602, 104, 1502, 2102, 4102, 4999, 5305, 4503, 3992, 1903, 1099, 3707, 302, 3904, 1702, 500, 3801, 401, 4702, 1601, 5201, 4601, 2503, 800, 4203, 4803, 3504, 4504, 1, 5400, 4902, 3702, 1201, 1801, 799, 4097, 5002, 1200, 3101, 2202, 5201, 4801, 2901, 3201, 407, 503, 1401, 3301, 2, 501, 5502, 2802, 3799, 1001, 700, 2301, 3899, 5099, 3002, 4599, 4299, 2700, 600, 5498, 1501, 510, 4497, 2111, 1301, 2003, 1602, 1101, 700, 902, 3498, 2402, 4396, 2801, 1001, 2501, 3895, 3698, 5301, 5301, 2099, 4998, 4602, 203, 901, 4898, 2199, 3400, 2199, 5403, 4298, 3402, 2702, 3602, 4000, 2601, 3602, 103, 3206, 2102, 4102, 3401, 5305, 4503, 4401, 1903, 3295, 5403, 301, 3903, 1702, 499, 3801, 401, 4701, 1501, 5202, 4601, 2503, 800, 4202, 4803, 3504, 4504, 1, 3700, 4902, 2201, 1201, 1802, 799, 4097, 5002, 1200, 3101, 4201, 5201, 4801, 2901, 3201, 2404, 503, 1401, 3301, 2, 501, 1698, 2802, 3799, 1001, 3502, 2301, 203, 5099, 3002, 4599, 4299, 2403, 601, 1502, 3401, 3994, 1209, 1302, 2004, 1604, 1102, 701, 503, 3499, 2402, 4398, 2802, 4098, 2501, 3897, 3698, 5302, 5302, 4307, 3898, 806, 203, 901, 4, 2200, 4802, 1602, 5405, 4300, 3402, 2703, 3602, 4001, 2603, 2400, 104, 3507, 2103, 4103, 5001, 5306, 4504, 3497, 1903, 1101, 5405, 302, 3904, 1704, 4501, 598, 401, 4702, 1402, 3003, 4601, 5003, 802, 4203, 3105, 3505, 4505, 2, 1497, 4903, 3699, 1202, 1803, 801, 4098, 5003, 1201, 1702, 3101, 4201, 5201, 4801, 2901, 3201, 2404, 2, 1401, 3300, 302, 501, 100, 2208, 3800, 1001, 3501, 2301, 5301, 5099, 3002, 4599, 4299, 1801, 601, 1503, 3401, 3696, 4103, 1302, 2004, 1604, 1102, 701, 3701, 3498, 2401, 4398, 2801, 1301, 4310, 2501, 4099, 3696, 4502, 4200, 5197, 1798, 2006, 202, 901, 3797, 2199, 3996, 2199, 3202, 3402, 2704, 3602, 4001, 2603, 2400, 103, 3506, 2103, 4103, 5002, 5307, 4504, 4402, 1903, 1502, 3706, 301, 3904, 1704, 4500, 1099, 400, 4702, 2904, 3204, 4202, 5004, 4503, 4203, 3106, 1300, 4105, 2, 5198, 4903, 1495, 1202, 1803, 801, 4500, 5003, 1201, 1702, 3101, 4201, 5201, 4801, 2901, 3201, 1100, 2, 1401, 3300, 302, 501, 4505, 3205, 3799, 1001, 2002, 2301, 203, 5098, 3002, 4599, 4299, 2403, 601, 1503, 410, 2396, 4103, 1303, 2004, 1604, 1102, 701, 3702, 3497, 2402, 4398, 2801, 5006, 3497, 2501, 800, 3697, 2909, 4201, 2099, 4303, 4603, 201, 902, 3699, 2198, 3100, 1601, 4600, 3401, 2703, 3601, 4001, 2604, 1098, 103, 3506, 2103, 4104, 3400, 4506, 4904, 1904, 2903, 101, 301, 3905, 1704, 5191, 5097, 401, 4702, 3106, 1902, 2608, 5005, 4504, 4204, 902, 5002, 4106, 3, 1499, 4904, 3699, 1203, 1804, 803, 4501, 5004, 1602, 1201, 1702, 3101, 4201, 4802, 2902, 3202, 3604, 1100, 3, 1401, 3300, 102, 501, 4, 1705, 3799, 1001, 1204, 2301, 3899, 5098, 3001, 4599, 4299, 2403, 601, 1503, 2900, 2099, 305, 1304, 2004, 1604, 1102, 702, 504, 3497, 2402, 4398, 2802, 5007, 700, 2501, 3895, 3696, 3405, 4201, 3697, 805, 4603, 200, 902, 3797, 2197, 3997, 1600, 4301, 3401, 2703, 3601, 4002, 2603, 1099, 102, 3505, 2102, 4104, 2801, 4506, 3603, 1905, 2904, 3209, 301, 3905, 1704, 501, 1101, 401, 4702, 2510, 897, 4600, 5005, 3206, 4204, 902, 3701, 4106, 3, 1499, 4904, 3699, 1203, 1804, 803, 4501, 5004, 1602, 1201, 1702, 3101, 4201, 4802, 2902, 3202, 3603, 1100, 2, 1401, 3300, 102, 501, 3, 3, 3800, 1001, 700, 2301, 3899, 3001, 4600, 4300, 2101, 602, 1504, 3196, 3697, 1907, 1305, 2004, 1605, 1104, 703, 505, 3499, 2403, 4399, 2803, 4100, 701, 2501, 802, 3697, 4503, 2411, 3698, 806, 4604, 202, 903, 3798, 2199, 3398, 1601, 5000, 4802, 3400, 2704, 3601, 4002, 2603, 1099, 101, 3505, 2102, 4104, 5008, 4505, 3603, 1905, 2798, 1507, 301, 3906, 1704, 501, 1792, 402, 4703, 4502, 1903, 3206, 5005, 4504, 4204, 902, 5002, 1100, 2, 1498, 4904, 3698, 1203, 1804, 803, 98, 5004, 1602, 1201, 1702, 3101, 4201, 4802, 2902, 3202, 3603, 4203, 4901, 1401, 3300, 302, 501, 3, 1802, 3800, 1001, 700, 2301, 100, 3001, 4600, 4300, 1202, 602, 1504, 4600, 3195, 298, 4599, 1304, 2002, 1604, 1104, 702, 3701, 3497, 2401, 4398, 2801, 1004, 1603, 2500, 801, 3696, 2903, 4805, 3697, 4304, 2903, 201, 902, 3798, 2198, 4802, 2999, 1000, 4301, 3399, 2704, 3600, 4001, 2603, 3600, 100, 2804, 2102, 4103, 3099, 4505, 2300, 1903, 300, 3406, 301, 3905, 1704, 1501, 795, 401, 4702, 1803, 2903, 3205, 2506, 4503, 4203, 4602, 3699, 4800, 4799, 4906, 4903, 3597, 1203, 1803, 802, 97, 1602, 1202, 1702, 3101, 4201, 4802, 4707, 2901, 3201, 3603, 4201, 3101, 1400, 3300, 401, 500, 103, 801, 3799, 1000, 1204, 2300, 3898, 2999, 4600, 4299, 1201, 601, 1503, 4600, 3194, 1200, 301, 1303, 2001, 1603, 1103, 701, 3700, 3496, 2400, 4397, 2799, 3109, 1602, 2500, 800, 3695, 3595, 1907, 3697, 4303, 2303, 200, 901, 2100, 2197, 3997, 1400, 2397, 4300, 3398, 2702, 3599, 4000, 2603, 3599, 99, 4402, 2101, 4103, 1700, 4505, 2299, 1902, 299, 3405, 300, 3904, 1703, 299, 1100, 401, 4701, 4600, 3200, 3202, 2505, 3202, 4202, 3300, 3698, 1099, 3696, 3004, 4504, 1203, 1803, 802, 97, 1602, 1202, 1702, 3101, 4201, 210, 2902, 3202, 3604, 3, 3102, 1401, 3300, 102, 501, 3905, 1802, 3800, 1001, 2199, 2301, 100, 3000, 4600, 4300, 1501, 602, 1504, 612, 2897, 1201, 2997, 1304, 2307, 2001, 1603, 1103, 701, 3701, 3496, 2400, 4398, 2799, 4098, 1502, 2500, 3397, 3696, 4297, 4103, 3697, 4303, 3704, 199, 901, 1502, 2196, 1499, 1400, 999, 4300, 3398, 2701, 3600, 4001, 2602, 3600, 99, 4403, 2102, 4103, 1699, 4505, 3092, 1903, 4604, 3405, 301, 3903, 1703, 197, 1100, 401, 4702, 299, 1801, 3003, 2506, 3800, 4202, 3897, 1299, 1099, 1297, 1503, 4504, 1203, 1803, 802, 98, 1602, 1202, 1702, 3101, 4201, 4413, 2902, 3201, 3604, 1204, 702, 1401, 3300, 3100, 501, 909, 1802, 3800, 1001, 2199, 2301, 100, 3000, 4600, 4300, 1999, 602, 1504, 4600, 2595, 704, 1200, 1005, 1303, 2306, 2000, 1601, 1102, 701, 1303, 3495, 2399, 4398, 2797, 1002, 2202, 2498, 799, 3695, 499, 4405, 3697, 3394, 2900, 199, 900, 1501, 2196, 3193, 1399, 2398, 4300, 3397, 2700, 3599, 4000, 2600, 3599, 98, 3503, 2101, 4101, 997, 4504, 1003, 1902, 1205, 3404, 300, 3902, 1702, 3300, 599, 400, 299, 1802, 4000, 3102, 4599, 4202, 3299, 1299, 1098, 1097, 1503, 4504, 1203, 1803, 802, 98, 1602, 1202, 1702, 3101, 4201, 4013, 2902, 3201, 3604, 1704, 702, 1401, 3301, 402, 501, 2907, 1802, 3800, 1001, 604, 2301, 3899, 3001, 4302, 4499, 603, 1504, 3901, 1699, 706, 3696, 712, 1304, 1807, 2000, 1601, 1103, 703, 3299, 3497, 2399, 4399, 2797, 503, 2204, 2498, 800, 3696, 97, 3996, 498, 3396, 804, 201, 901, 1501, 2198, 3397, 2699, 2398, 3197, 3399, 1399, 2699, 3599, 4000, 2600, 3599, 99, 3503, 2101, 4102, 996, 4505, 201, 1903, 3406, 4402, 300, 3902, 1703, 495, 599, 400, 299, 1801, 4000, 3102, 3799, 4203, 3897, 1300, 3297, 3296, 3298, 2203, 1203, 1803, 803, 99, 1602, 1202, 1702, 3101, 4201, 1007, 2902, 3202, 1305, 1704, 702, 1401, 3301, 2900, 501, 8, 1802, 3799, 1001, 4202, 2301, 3899, 3000, 4301, 4201, 604, 1504, 1008, 2595, 3599, 3696, 806, 1304, 1407, 2000, 1601, 1103, 703, 207, 3497, 2398, 4399, 2797, 3100, 3304, 2498, 2401, 3696, 3192, 2600, 3698, 3396, 4198, 201, 900, 2899, 2199, 3998, 2699, 2397, 2302, 3399, 801, 2699, 3599, 4000, 2599, 797, 3598, 98, 1499, 2101, 4102, 3792, 602, 1903, 2905, 4300, 300, 3901, 1703, 399, 4297, 401, 299, 1201, 3202, 3101, 1803, 4203, 3897, 1300, 2898, 1, 3298, 2203, 1203, 1803, 803, 99, 1602, 1202, 1702, 3101, 4201, 2907, 2901, 3202, 804, 3503, 702, 1401, 3301, 202, 501, 1003, 1208, 3799, 1001, 400, 2300, 3899, 3000, 4301, 4200, 604, 1504, 1310, 997, 706, 4298, 1111, 1303, 1905, 2000, 1601, 1103, 703, 207, 3497, 2398, 2799, 3503, 2013, 2498, 801, 3697, 501, 3296, 3699, 4105, 1604, 202, 900, 2900, 2199, 1499, 2699, 800, 1604, 3400, 1, 2699, 3601, 4002, 2600, 2498, 1702, 99, 2099, 2103, 4103, 3294, 2003, 1904, 4303, 1400, 302, 3902, 1705, 2602, 3301, 402, 890, 199, 1702, 1300, 2504, 1803, 4203, 3299, 3501, 3495, 1, 3298, 2203, 1203, 1803, 803, 701, 1602, 1202, 1702, 3101, 4201, 2907, 2901, 3202, 2504, 3, 4201, 1401, 3301, 2700, 501, 3, 2205, 3799, 1001, 3198, 2300, 3899, 3000, 2001, 605, 1505, 710, 2396, 3211, 1398, 3298, 1303, 1906, 2001, 1602, 1104, 704, 3216, 3498, 2398, 2799, 2802, 2204, 2498, 802, 3698, 3598, 2300, 3699, 3696, 4100, 203, 901, 2901, 2199, 4001, 1103, 2102, 2505, 3401, 802, 2700, 3602, 4003, 2600, 2499, 3202, 99, 2100, 2996, 2103, 4103, 3294, 2004, 1904, 706, 1401, 302, 3903, 1705, 3904, 600, 402, 1701, 99, 3801, 2687, 2504, 3799, 4203, 3299, 3501, 898, 1, 3298, 2203, 1203, 1803, 803, 701, 1602, 1202, 1702, 3101, 702, 3210, 2902, 3202, 1910, 3, 3501, 1401, 3301, 2, 501, 3, 2800, 3799, 1001, 2202, 2299, 100, 3000, 2000, 605, 1505, 3905, 2597, 1806, 3299, 900, 1303, 407, 2000, 1601, 1103, 704, 3702, 3498, 2397, 2799, 1107, 3607, 2498, 3899, 3698, 2599, 2299, 3699, 3399, 2497, 203, 901, 1304, 2199, 4001, 3, 2101, 1605, 3402, 3502, 2700, 3602, 4003, 2600, 2100, 1603, 100, 3901, 2997, 2102, 4104, 1700, 1004, 3590, 1904, 1100, 1400, 301, 3902, 1704, 3583, 798, 402, 3600, 795, 3801, 1804, 3100, 3799, 3298, 600, 899, 1, 2500, 2103, 1203, 1803, 803, 1601, 1602, 1202, 1702, 3101, 702, 3210, 2902, 3202, 3408, 3, 2402, 1401, 3301, 2500, 501, 11, 3, 3799, 1001, 2201, 2299, 100, 3000, 3301, 605, 1505, 1008, 2596, 110, 406, 3298, 1303, 1408, 1999, 1601, 1204, 1101, 703, 3911, 3497, 2396, 2798, 2398, 3600, 2498, 3898, 3698, 799, 3296, 2598, 1305, 3202, 202, 900, 2602, 2197, 4000, 3403, 2100, 1604, 3401, 3501, 2699, 3601, 4003, 2599, 2101, 2106, 99, 2197, 1996, 2101, 1997, 3603, 899, 1904, 1496, 1401, 302, 3902, 1704, 98, 2898, 402, 1895, 3499, 3200, 598, 3899, 3799, 3298, 2304, 2498, 1, 2500, 2003, 1203, 1803, 803, 401, 1602, 1202, 1702, 3101, 2701, 1613, 2902, 3202, 3610, 3502, 2, 1401, 3300, 302, 501, 1407, 802, 3798, 1001, 702, 2299, 3898, 3000, 1999, 605, 1505, 1007, 2596, 811, 1098, 405, 1303, 1806, 1999, 1601, 1204, 1101, 703, 3703, 3497, 2397, 2798, 1106, 2201, 2497, 801, 3699, 299, 2599, 3399, 803, 2197, 202, 899, 1004, 2196, 3400, 1102, 501, 2300, 2794, 3400, 3500, 2698, 3601, 2599, 2705, 3601, 99, 3800, 1996, 2100, 1702, 798, 898, 1903, 2289, 2404, 302, 3903, 1705, 2801, 3486, 401, 3801, 3399, 2801, 1805, 1704, 3799, 901, 3501, 3095, 1, 2101, 1903, 1203, 1803, 803, 1999, 1602, 1202, 1702, 3101, 2701, 1003, 2902, 3202, 605, 3502, 2, 1401, 3300, 2300, 501, 409, 103, 3798, 1001, 1002, 2300, 1409, 3000, 3405, 1997, 604, 1504, 310, 2595, 411, 507, 600, 1301, 1903, 1997, 1600, 705, 1100, 702, 1303, 3497, 2395, 2798, 1601, 2199, 2496, 1998, 3698, 500, 199, 105, 801, 6, 201, 897, 1302, 2194, 3699, 2699, 500, 999, 3602, 3399, 3398, 2698, 3600, 2598, 703, 3799, 99, 3800, 193, 2099, 1995, 796, 2800, 1902, 200, 898, 300, 1705, 590, 2984, 401, 3802, 3299, 3604, 1103, 1902, 3199, 901, 3502, 498, 1, 3602, 1803, 1203, 1803, 803, 498, 1602, 1202, 1702, 3101, 2701, 1003, 2902, 3202, 1804, 1703, 2, 1401, 3300, 102, 501, 3602, 802, 1002, 401, 2300, 206, 3001, 3407, 1998, 605, 1505, 1011, 1599, 2201, 3109, 210, 1302, 1903, 1997, 1600, 1203, 1101, 702, 505, 3499, 2396, 2799, 3599, 1509, 2497, 3603, 3699, 2597, 2296, 408, 2903, 2893, 201, 899, 2902, 2195, 701, 3000, 501, 299, 202, 3401, 803, 2699, 3601, 2600, 2295, 1905, 100, 2196, 1099, 2099, 2102, 96, 2801, 1902, 1302, 900, 301, 1787, 1704, 501, 2997, 401, 1400, 3199, 3604, 1993, 1703, 3199, 3102, 2201, 499, 2, 3202, 3601, 1203, 1803, 803, 1301, 1602, 1202, 1702, 3101, 2701, 1003, 2902, 3202, 1105, 104, 2, 1401, 3300, 2100, 501, 3602, 802, 1002, 401, 2300, 1603, 3001, 1203, 506, 604, 1504, 1007, 1302, 2701, 2195, 805, 1302, 1902, 1997, 1599, 3503, 1100, 701, 505, 3498, 2396, 2799, 3599, 2902, 2497, 2804, 100, 2709, 2705, 1899, 1505, 201, 900, 2099, 2196, 3402, 1403, 1002, 300, 802, 3402, 603, 2700, 3603, 2601, 698, 2998, 100, 2197, 1596, 2100, 2904, 96, 900, 1903, 1103, 397, 599, 301, 1002, 1704, 2701, 2997, 402, 1401, 3505, 1804, 2600, 1703, 803, 3102, 200, 2098, 2, 3202, 3601, 1203, 1803, 803, 1301, 1602, 1202, 1702, 3101, 2701, 2604, 2611, 2901, 3201, 1104, 3202, 3500, 1400, 3299, 401, 500, 3096, 801, 1001, 700, 2299, 1602, 3000, 1599, 504, 603, 1502, 609, 2296, 609, 2304, 2397, 1301, 1901, 1997, 1598, 1103, 1099, 700, 503, 3497, 2395, 2798, 1599, 1503, 2497, 1997, 2701, 3298, 2105, 502, 905, 200, 899, 1501, 2195, 2000, 1598, 1206, 2092, 202, 3401, 602, 2699, 2601, 1100, 2096, 100, 2400, 1598, 2100, 2904, 2893, 2803, 1902, 3503, 100, 901, 302, 1002, 1703, 2700, 3197, 402, 1301, 1705, 400, 2600, 1103, 803, 903, 200, 2695, 2, 3500, 3201, 1203, 1803, 803, 101, 1602, 1202, 1702, 3101, 2701, 2604, 807, 2901, 3201, 2902, 309, 2800, 1399, 3299, 1899, 500, 199, 801, 1001, 899, 2299, 703, 3000, 1598, 404, 603, 1502, 3301, 2296, 1799, 596, 2707, 1300, 1902, 1996, 1597, 5, 1099, 700, 3098, 2397, 2799, 1599, 504, 2498, 1997, 2803, 201, 1405, 2595, 3095, 201, 899, 1, 2196, 403, 2196, 1306, 1599, 203, 3403, 806, 2701, 2602, 700, 2999, 101, 1701, 2203, 2101, 2104, 1105, 897, 2803, 1902, 1608, 100, 1904, 302, 500, 1703, 2700, 899, 402, 3292, 1605, 3298, 3002, 502, 3200, 903, 201, 98, 2, 1799, 2202, 1203, 1803, 803, 101, 1602, 1202, 1702, 3101, 2701, 2604, 1002, 2901, 3201, 1600, 303, 1701, 1399, 3299, 3098, 500, 2604, 207, 1001, 899, 2299, 1699, 3000, 216, 304, 603, 1501, 1111, 1300, 2700, 108, 107, 1299, 708, 1996, 1596, 3201, 1099, 700, 3197, 2397, 2799, 399, 1404, 2498, 1997, 1205, 1905, 3205, 103, 2894, 201, 900, 2601, 2197, 3102, 1598, 1702, 1298, 203, 806, 2702, 2604, 1104, 2401, 102, 1701, 2097, 2102, 2105, 1107, 2904, 902, 1903, 1105, 3099, 795, 96, 302, 501, 1702, 2700, 1700, 402, 3097, 1505, 3299, 3003, 503, 3200, 3103, 1903, 2804, 2, 3100, 2202, 1203, 1803, 803, 101, 1602, 1202, 1702, 3101, 2701, 2604, 1706, 2901, 3201, 1299, 303, 701, 1399, 3099, 501, 407, 2103, 1204, 1001, 2303, 2299, 1004, 3000, 2914, 1997, 603, 1501, 1110, 401, 2707, 107, 1505, 1299, 2005, 1996, 1596, 5, 1098, 699, 1599, 2397, 2799, 1893, 1599, 2498, 799, 501, 200, 308, 607, 1402, 200, 901, 3000, 2198, 1200, 3002, 502, 505, 202, 2204, 2702, 2604, 2406, 1998, 102, 1701, 3200, 2103, 2106, 107, 2905, 902, 1903, 698, 3099, 1996, 103, 302, 2496, 1702, 502, 1501, 403, 292, 1405, 99, 2503, 503, 804, 3103, 2405, 2804, 2, 1400, 2202, 1203, 1803, 803, 1303, 1602, 1202, 1702, 3101, 2701, 2604, 1303, 2901, 2004, 909, 702, 1400, 3100, 502, 408, 1902, 1800, 1002, 2903, 2300, 3102, 3000, 2516, 1998, 604, 1502, 1005, 2501, 2301, 1395, 2399, 1299, 2004, 1997, 1598, 1102, 1098, 700, 3099, 2398, 2801, 1894, 2596, 2499, 801, 3000, 200, 2505, 2797, 1898, 200, 903, 4, 2199, 703, 1401, 802, 2503, 2302, 305, 1, 2702, 2604, 2701, 2201, 101, 1701, 1598, 2103, 2005, 3, 1398, 903, 1903, 1491, 1294, 1494, 103, 303, 702, 1702, 1401, 1699, 402, 95, 94, 99, 1205, 3100, 804, 3103, 2405, 3102, 2, 2603, 2202, 1203, 1803, 803, 1203, 1602, 1202, 1702, 3101, 2701, 2604, 2601, 2901, 2004, 1203, 702, 1400, 2900, 502, 904, 1902, 3, 1001, 101, 2300, 2603, 3000, 1602, 505, 604, 1503, 1608, 2899, 506, 1395, 1698, 1298, 707, 1998, 1597, 6, 1098, 700, 702, 2398, 2802, 1005, 2596, 2499, 801, 501, 201, 1199, 2596, 907, 201, 902, 2102, 2199, 2803, 1598, 2102, 499, 2303, 2904, 1607, 2703, 103, 2603, 2303, 1098, 100, 1700, 997, 2102, 1099, 1, 2896, 902, 1903, 1103, 993, 1795, 400, 302, 701, 1701, 2702, 896, 402, 998, 400, 1203, 3002, 503, 804, 903, 2404, 1400, 1, 2602, 2201, 1202, 1802, 802, 101, 1601, 2500, 1701, 2701, 2303, 1003, 2901, 2004, 2609, 702, 1400, 303, 502, 903, 2697, 803, 513, 1000, 1898, 2299, 2899, 7, 505, 604, 1502, 808, 2899, 109, 1705, 2399, 1298, 1903, 1998, 1597, 2003, 1097, 700, 599, 2398, 2802, 400, 2401, 2499, 503, 2102, 1908, 1801, 1104, 2897, 201, 901, 1801, 2200, 2908, 2200, 2401, 1001, 2303, 5, 2407, 2703, 1999, 2604, 1401, 1097, 101, 1700, 1800, 2102, 2004, 2000, 2103, 901, 1903, 102, 698, 1497, 1403, 303, 702, 1701, 502, 699, 402, 2792, 300, 300, 899, 2499, 1102, 903, 2301, 2701, 1, 1398, 2201, 1202, 1802, 802, 101, 1601, 2500, 1701, 2701, 1302, 702, 2805, 2104, 2503, 1400, 304, 503, 904, 2006, 504, 2106, 1000, 903, 2300, 1700, 605, 506, 605, 1503, 1098, 1, 2703, 904, 2400, 1300, 2606, 1999, 1598, 7, 1097, 700, 599, 2399, 2803, 798, 1501, 2501, 505, 503, 202, 1003, 2799, 2707, 202, 902, 2101, 2201, 707, 2201, 999, 501, 1697, 2299, 707, 2606, 2703, 403, 2604, 1904, 1704, 101, 101, 1603, 2103, 2505, 1006, 498, 901, 1903, 903, 2296, 1996, 496, 303, 1893, 1702, 199, 999, 402, 2299, 200, 2399, 2596, 2500, 1102, 1502, 2301, 1001, 1, 1398, 2201, 1201, 1802, 802, 101, 1601, 2500, 1701, 2701, 1301, 702, 2704, 1504, 2512, 1400, 304, 503, 409, 1007, 315, 1404, 1000, 902, 2504, 2299, 1908, 305, 1404, 603, 1502, 696, 803, 1209, 1897, 603, 1298, 2206, 1998, 1597, 6, 1096, 698, 1201, 2399, 401, 2599, 2502, 800, 503, 1802, 2509, 609, 209, 201, 901, 903, 2201, 106, 1401, 2403, 1601, 2200, 999, 305, 1600, 2704, 1199, 2604, 2303, 1099, 102, 2700, 1502, 2103, 1204, 207, 1800, 1403, 1902, 908, 2297, 1996, 104, 303, 2698, 1702, 1600, 109, 402, 2605, 2300, 195, 2591, 1100, 804, 1502, 603, 2204, 1, 2602, 998, 1201, 1802, 802, 701, 1601, 2500, 1701, 1805, 1301, 2507, 905, 1004, 2503, 1401, 706, 503, 2324, 1008, 802, 2203, 1000, 1701, 2503, 2299, 100, 7, 504, 602, 207, 1501, 501, 1510, 9, 106, 1197, 1297, 800, 1997, 1597, 1704, 1096, 697, 198, 2399, 400, 1300, 2501, 1999, 1507, 1500, 2503, 804, 2200, 201, 899, 2405, 2200, 1102, 1600, 800, 1104, 2504, 304, 2006, 800, 303, 2605, 1307, 1703, 101, 507, 1503, 2102, 2105, 1005, 2605, 402, 1903, 2399, 2298, 1996, 1695, 303, 496, 1702, 988, 1901, 403, 2597, 2200, 1799, 2594, 1897, 803, 1502, 603, 1000, 2, 2496, 1992, 1201, 1802, 802, 701, 1601, 2500, 1701, 1805, 1303, 2203, 1002, 1301, 502, 912, 1400, 210, 501, 902, 1107, 2096, 2202, 1000, 1401, 2404, 2298, 199, 1006, 1499, 601, 1909, 1500, 499, 5, 699, 2109, 1496, 1296, 1903, 1996, 1596, 2, 1094, 695, 1891, 2398, 398, 2397, 2500, 1899, 1398, 2101, 899, 102, 2002, 201, 897, 2305, 2200, 1297, 2200, 2102, 901, 2303, 803, 304, 1301, 303, 1598, 2102, 101, 102, 1503, 2103, 1702, 1005, 1800, 95, 1903, 1697, 1490, 1699, 1294, 304, 495, 1701, 1797, 1901, 403, 86, 1700, 1400, 2402, 2500, 803, 1502, 1604, 2301, 2, 1897, 304, 1201, 1802, 802, 502, 1601, 2500, 1701, 1201, 1303, 2203, 1001, 1301, 106, 2, 1400, 2125, 501, 903, 1306, 705, 803, 999, 1000, 1509, 2297, 199, 2401, 1499, 600, 1413, 1500, 499, 1097, 793, 1500, 605, 1296, 598, 1996, 1596, 1702, 1094, 694, 395, 2398, 1703, 997, 901, 500, 2103, 1108, 3, 1399, 203, 898, 1597, 2201, 1899, 1600, 2403, 203, 993, 1704, 702, 301, 303, 2102, 1504, 103, 1703, 1100, 2105, 1803, 209, 1999, 1603, 1903, 7, 1491, 2097, 997, 305, 1895, 1702, 1798, 1901, 403, 1899, 399, 1301, 2203, 1200, 1600, 802, 1502, 1204, 601, 2, 1897, 304, 1201, 1802, 802, 302, 1601, 696, 1701, 1201, 1303, 2203, 1001, 1301, 106, 2, 1400, 302, 501, 902, 1901, 1604, 108, 999, 1000, 1104, 2297, 1698, 810, 1499, 600, 2014, 1500, 197, 1999, 1605, 1100, 300, 1297, 805, 1997, 1596, 1702, 1094, 694, 2098, 398, 1807, 2001, 2105, 201, 610, 1902, 2110, 1997, 202, 898, 898, 2201, 2103, 1601, 997, 206, 1805, 502, 403, 502, 701, 1201, 1000, 104, 2102, 1100, 2105, 1806, 2204, 2000, 900, 1904, 2304, 1895, 1385, 1900, 304, 700, 1702, 1500, 1901, 403, 1387, 1899, 2104, 593, 295, 404, 1900, 1502, 2005, 1804, 2, 1098, 304, 1201, 1802, 802, 1599, 1601, 1201, 500, 1201, 1302, 2203, 1902, 403, 1403, 2, 1400, 302, 501, 707, 1901, 1103, 2104, 1000, 302, 2004, 1699, 2101, 1201, 601, 2, 1501, 107, 2001, 911, 1501, 1103, 1298, 1908, 1999, 1597, 3, 1095, 696, 395, 299, 397, 193, 2002, 1111, 200, 1410, 600, 2006, 1295, 201, 898, 702, 2201, 795, 1601, 997, 2009, 1805, 1498, 1901, 1508, 899, 697, 1807, 104, 1096, 1004, 2105, 1103, 399, 1694, 600, 1905, 195, 1694, 1995, 1306, 304, 1293, 1701, 1500, 899, 402, 1696, 1900, 494, 1200, 685, 1099, 1403, 1502, 2005, 2098, 3, 994, 2201, 1201, 1802, 802, 1599, 1601, 1201, 500, 1201, 1302, 1602, 1902, 204, 507, 700, 1400, 304, 301, 500, 705, 913, 799, 2103, 999, 1799, 1703, 1698, 605, 1200, 601, 1602, 1500, 198, 297, 2011, 302, 1901, 1297, 1304, 1997, 1596, 900, 1095, 694, 296, 297, 205, 401, 300, 2001, 2103, 1306, 1100, 2113, 1594, 200, 897, 1, 9, 1403, 2105, 1007, 709, 504, 1009, 799, 905, 596, 697, 103, 99, 903, 2106, 1103, 1007, 294, 2098, 1905, 1804, 1896, 998, 1304, 303, 1694, 1701, 1500, 599, 402, 1400, 1900, 587, 1486, 1799, 1898, 1907, 204, 1996, 1499, 3, 997, 302, 1201, 1802, 802, 792, 301, 1201, 500, 1201, 1303, 1602, 1902, 2010, 508, 700, 1399, 304, 301, 501, 1603, 1803, 101, 2002, 999, 400, 1703, 1698, 1705, 513, 600, 704, 1500, 1696, 1699, 495, 997, 600, 1297, 794, 1997, 1596, 798, 1095, 694, 1998, 896, 194, 394, 1801, 2000, 1003, 202, 819, 102, 403, 1996, 198, 897, 1802, 598, 1404, 798, 609, 1808, 1507, 296, 1598, 699, 797, 201, 102, 898, 1503, 899, 1007, 202, 1806, 1905, 1199, 296, 586, 704, 303, 700, 1702, 302, 300, 401, 97, 1796, 1701, 1897, 1888, 2008, 801, 1797, 1699, 1499, 3, 997, 3, 1201, 1802, 802, 102, 301, 1201, 500, 1201, 1012, 1602, 1902, 803, 8, 701, 1399, 1203, 101, 500, 1701, 105, 1904, 900, 999, 1002, 1902, 197, 1807, 503, 600, 704, 1500, 799, 102, 196, 104, 1197, 1297, 1006, 1598, 1100, 1096, 695, 796, 602, 592, 1300, 606, 898, 1004, 401, 702, 305, 1609, 401, 198, 899, 1600, 495, 1602, 999, 797, 1203, 1805, 201, 1400, 397, 1804, 1005, 102, 1496, 1505, 304, 9, 706, 1298, 1907, 1200, 1097, 799, 1398, 303, 495, 1703, 501, 601, 402, 97, 404, 1799, 1899, 8, 1703, 802, 806, 1300, 701, 4, 998, 1504, 1803, 1201, 1802, 802, 1299, 301, 1201, 500, 1201, 209, 1602, 1301, 603, 1402, 212, 1399, 1202, 103, 500, 303, 1701, 1105, 900, 999, 999, 900, 197, 8, 208, 600, 306, 1500, 1207, 1097, 1700, 103, 603, 1297, 795, 1599, 695, 1096, 695, 794, 200, 992, 395, 998, 299, 510, 315, 1001, 996, 1813, 604, 299, 196, 898, 898, 1200, 1402, 800, 391, 1202, 1805, 907, 1601, 1397, 1701, 1607, 101, 696, 1204, 1801, 13, 692, 398, 900, 103, 492, 203, 303, 1187, 1703, 1504, 601, 402, 84, 404, 907, 1104, 202, 402, 1703, 806, 1300, 597, 4, 200, 304, 702, 1201, 1802, 802, 492, 301, 1201, 500, 1201, 924, 1102, 1601, 1300, 1502, 1401, 700, 1398, 1201, 1001, 500, 901, 1700, 402, 799, 998, 998, 899, 1696, 797, 404, 599, 1602, 1500, 1597, 1698, 196, 798, 1596, 1296, 1711, 1597, 1198, 1095, 695, 1696, 1698, 297, 394, 389, 1104, 1512, 495, 1104, 1103, 517, 606, 402, 195, 897, 512, 904, 1600, 799, 203, 605, 403, 1703, 1399, 495, 497, 1606, 99, 1704, 1605, 300, 1403, 200, 1396, 498, 401, 592, 1204, 302, 485, 1703, 1500, 1489, 401, 603, 402, 1004, 1104, 503, 1399, 1702, 1700, 397, 599, 3, 199, 303, 205, 1200, 802, 397, 101, 1201, 500, 1201, 1413, 101, 1601, 1300, 1502, 1000, 700, 1398, 1201, 1000, 500, 801, 299, 1201, 1209, 997, 596, 899, 799, 799, 99, 599, 1602, 1499, 1401, 698, 195, 403, 788, 1297, 1297, 1597, 1198, 1095, 695, 1100, 494, 297, 1300, 610, 498, 1098, 1407, 494, 197, 605, 2, 1601, 598, 194, 896, 295, 406, 1600, 798, 100, 1304, 1209, 300, 797, 102, 699, 1606, 98, 399, 1095, 998, 594, 1399, 900, 106, 1000, 491, 1203, 301, 1096, 401, 1499, 401, 802, 402, 904, 1505, 508, 407, 801, 900, 995, 599, 2, 597, 303, 902, 1200, 802, 799, 798, 1100, 1296, 1201, 1013, 100, 300, 1300, 403, 801, 700, 1398, 1201, 1196, 500, 701, 1302, 1094, 1399, 997, 998, 899, 1206, 5, 98, 599, 704, 1499, 501, 1006, 290, 1495, 507, 1298, 593, 1200, 1096, 696, 697, 393, 400, 1401, 998, 498, 1310, 707, 496, 198, 298, 698, 802, 398, 195, 897, 296, 1500, 104, 501, 203, 906, 199, 900, 799, 903, 698, 1096, 99, 100, 1396, 114, 1202, 1495, 901, 1297, 902, 1199, 202, 302, 1097, 413, 898, 500, 401, 1197, 486, 301, 1099, 599, 1208, 603, 305, 1501, 1106, 2, 1301, 303, 303, 1200, 802, 1303, 1199, 1100, 1296, 1201, 806, 100, 300, 800, 403, 1127, 401, 1398, 1424, 1196, 501, 900, 603, 700, 1299, 997, 1202, 899, 500, 1400, 597, 599, 911, 1007, 699, 196, 98, 1000, 1298, 501, 397, 1098, 697, 899, 896, 409, 1001, 293, 610, 603, 1007, 95, 601, 996, 1209, 203, 1103, 196, 898, 901, 901, 200, 999, 597, 1203, 906, 199, 1401, 605, 1102, 1204, 100, 101, 409, 1397, 491, 603, 599, 499, 708, 701, 1206, 304, 394, 185, 199, 1301, 402, 1207, 800, 386, 1198, 1002, 405, 1303, 1101, 497, 600, 1105, 2, 1301, 303, 303, 1200, 802, 1303, 299, 1100, 796, 1201, 307, 102, 300, 703, 403, 801, 506, 605, 1001, 502, 1004, 611, 603, 802, 998, 1202, 806, 800, 1304, 110, 600, 894, 1009, 808, 197, 206, 95, 1299, 106, 903, 1100, 698, 893, 395, 293, 127, 492, 195, 701, 311, 1203, 97, 201, 195, 307, 704, 198, 899, 1, 898, 97, 802, 91, 605, 496, 1004, 906, 910, 506, 6, 101, 398, 109, 1104, 414, 100, 402, 901, 488, 1095, 690, 305, 1296, 1289, 792, 784, 403, 305, 1201, 287, 497, 1004, 1300, 1303, 102, 398, 900, 600, 906, 1, 1301, 303, 303, 1200, 802, 1303, 299, 1100, 197, 1201, 412, 102, 1001, 98, 503, 798, 408, 1002, 1197, 502, 204, 1, 102, 806, 998, 100, 900, 800, 1201, 899, 804, 599, 813, 397, 501, 196, 997, 607, 403, 797, 1099, 698, 894, 101, 1094, 194, 797, 516, 906, 914, 498, 799, 1108, 1007, 303, 704, 199, 900, 94, 304, 1106, 504, 201, 201, 505, 503, 203, 1104, 801, 10, 102, 1105, 1203, 297, 412, 4, 401, 1211, 905, 502, 789, 305, 701, 705, 201, 100, 402, 591, 800, 398, 1197, 1113, 403, 501, 298, 298, 901, 1008, 199, 1, 901, 303, 303, 1200, 802, 199, 299, 1100, 197, 305, 210, 102, 101, 98, 310, 1099, 700, 602, 404, 501, 1009, 1, 308, 706, 997, 398, 111, 800, 100, 300, 404, 599, 194, 699, 2, 196, 996, 705, 301, 198, 1099, 698, 191, 396, 403, 994, 592, 489, 1007, 2, 402, 98, 196, 808, 298, 301, 703, 198, 899, 400, 708, 2, 802, 1100, 410, 502, 299, 801, 709, 503, 10, 101, 395, 1006, 506, 394, 905, 194, 298, 994, 502, 386, 303, 700, 192, 92, 687, 401, 896, 400, 1097, 1004, 1101, 103, 500, 103, 606, 595, 905, 902, 901, 203, 300, 302, 802, 903, 697, 700, 896, 305, 210, 101, 300, 98, 102, 911, 800, 304, 997, 501, 397, 796, 601, 802, 997, 500, 215, 800, 500, 992, 806, 599, 804, 296, 802, 692, 806, 203, 199, 996, 903, 699, 16, 592, 810, 399, 204, 892, 907, 103, 402, 501, 196, 597, 6, 1, 97, 198, 899, 403, 1, 411, 802, 614, 915, 501, 605, 604, 604, 98, 709, 101, 201, 195, 601, 504, 190, 903, 603, 894, 585, 991, 303, 1000, 706, 686, 185, 401, 1002, 1002, 997, 204, 1003, 103, 500, 299, 305, 99, 599, 902, 901, 103, 300, 805, 802, 298, 897, 700, 396, 901, 118, 601, 100, 299, 97, 5, 499, 799, 706, 203, 500, 396, 210, 698, 800, 2, 110, 316, 200, 300, 597, 599, 107, 721, 102, 897, 504, 292, 401, 898, 399, 700, 502, 102, 403, 798, 192, 212, 888, 510, 409, 501, 786, 500, 609, 605, 384, 198, 899, 602, 380, 302, 802, 499, 708, 801, 302, 605, 94, 701, 400, 101, 303, 496, 506, 87, 908, 904, 408, 402, 598, 85, 303, 195, 706, 705, 3, 400, 9, 801, 897, 695, 600, 402, 102, 901, 301, 398, 600, 505, 504, 3, 300, 200, 802, 99, 897, 700, 301, 5, 807, 601, 101, 299, 97, 5, 507, 399, 800, 796, 500, 194, 108, 496, 802, 699, 4, 503, 215, 199, 299, 804, 599, 512, 800, 108, 195, 306, 101, 499, 207, 102, 698, 698, 394, 401, 595, 796, 394, 499, 799, 211, 97, 200, 105, 97, 502, 295, 197, 798, 92, 3, 803, 498, 705, 801, 503, 802, 604, 709, 317, 102, 103, 799, 507, 195, 497, 401, 203, 605, 601, 797, 302, 704, 304, 702, 291, 400, 507, 708, 797, 802, 502, 500, 301, 397, 301, 497, 700, 102, 101, 102, 300, 1, 802, 391, 800, 700, 301, 5, 706, 601, 205, 399, 97, 415, 401, 96, 105, 505, 500, 409, 600, 501, 596, 499, 699, 707, 609, 607, 500, 303, 598, 1, 100, 605, 195, 103, 701, 592, 609, 692, 698, 94, 101, 402, 304, 196, 406, 200, 398, 402, 11, 197, 397, 97, 202, 299, 197, 693, 578, 701, 504, 201, 285, 392, 699, 712, 499, 100, 503, 102, 693, 504, 703, 4, 202, 694, 402, 191, 705, 202, 302, 104, 307, 689, 398, 401, 407, 196, 607, 501, 592, 694, 402, 700, 202, 587, 404, 504, 503, 700, 300, 199, 292, 601, 302, 397, 301, 601, 516, 601, 207, 602, 97, 402, 410, 400, 212, 599, 499, 495, 406, 207, 596, 2, 197, 207, 607, 603, 486, 95, 598, 1, 496, 616, 195, 387, 101, 396, 104, 302, 502, 105, 102, 590, 399, 306, 606, 502, 412, 308, 414, 583, 105, 605, 497, 198, 197, 605, 503, 188, 603, 601, 601, 99, 599, 406, 97, 308, 402, 102, 103, 397, 396, 401, 203, 300, 409, 501, 601, 202, 303, 91, 493, 95, 192, 401, 307, 81, 95, 490, 505, 489, 298, 497, 7, 499, 595, 198, 197, 603, 596, 193, 502, 198, 302, 189, 301, 3, 502, 2, 233, 100, 97, 96, 401, 200, 101, 309, 499, 95, 400, 305, 412, 197, 499, 500, 107, 495, 298, 503, 495, 397, 296, 196, 395, 312, 386, 507, 92, 106, 202, 111, 295, 371, 278, 206, 506, 301, 413, 1, 424, 490, 495, 94, 307, 199, 3, 199, 1, 11, 192, 401, 407, 201, 498, 503, 98, 326, 401, 103, 497, 407, 12, 209, 198, 104, 193, 205, 3, 502, 303, 111, 405, 495, 101, 401, 207, 187, 305, 305, 502, 396, 292, 389, 385, 387, 396, 199, 198, 486, 379, 403, 99, 398, 199, 202, 301, 103, 202, 302, 211, 300, 97, 408, 95, 102, 202, 198, 96, 95, 193, 198, 1, 397, 2, 412, 6, 87, 14, 390, 189, 108, 198, 305, 4, 200, 99, 5, 207, 207, 188, 281, 404, 5, 91, 298, 5, 1, 403, 100, 324, 195, 94, 100, 99, 199, 199, 104, 201, 412, 398, 11, 307, 105, 302, 405, 397, 408, 1, 104, 211, 2, 12, 199, 103, 96, 212, 191, 404, 390, 303, 205, 302, 194, 109, 402, 83, 297, 86, 210, 101, 202, 288, 401, 203, 104, 100, 299, 298, 193, 300, 299, 299, 398, 1, 202, 301, 301, 207, 302, 210, 301, 97, 204, 101, 13, 136, 98, 299, 298, 95, 308, 310, 306, 193, 302, 291, 198, 203, 190, 210, 197, 97, 294, 101, 107, 309, 7, 91, 208, 295, 7, 310, 8, 192, 203, 200, 289, 100, 100, 294, 107, 108, 104, 103, 199, 197, 115, 106, 203, 194, 297, 97, 299, 307, 101, 92, 310, 295, 1, 103, 201, 96, 106, 309, 191, 293, 209, 102, 104, 113, 303, 291, 10, 4, 278, 186, 297, 196, 201, 113, 299, 195, 299, 98, 205, 200, 3, 2, 204, 195, 200, 301, 301, 1, 202, 301, 245, 205, 101, 242, 1, 97, 134, 207, 200, 107, 35, 91, 102, 3, 211, 207, 92, 97, 2, 199, 3, 102, 113, 218, 3, 187, 184, 105, 192, 8, 207, 197, 186, 6, 203, 80, 96, 175, 194, 212, 1, 201, 207, 215, 86, 18, 108, 182, 104, 198, 13, 107, 98, 195, 87, 15, 95, 190, 100, 1, 110, 1, 2, 205, 102, 93, 7, 206, 108, 107, 1, 1, 185, 14, 5, 83, 205, 4, 87, 101, 197, 96, 203, 200, 108, 7, 89, 198, 1, 201, 194, 193, 100, 106, 96, 77, 4, 1, 189, 198, 104, 121, 38, 101, 1, 97, 34, 107, 99, 21, 8, 91, 94, 7, 6, 103, 101, 102, 93, 97, 8, 1, 15, 87, 96, 8, 89, 13, 2, 21, 1, 89, 92, 12, 100, 123, 9, 91, 82, 87, 89, 97, 10, 6, 90, 82, 98, 102, 102, 99, 4, 93, 24, 99, 99, 74, 104, 116, 5, 10, 95, 99, 106, 99, 103, 82, 13, 108, 92, 1, 107, 104, 112, 100, 92, 91, 105, 75, 87, 103, 97, 100, 13, 9, 104, 7, 100, 98, 11, 101, 98, 97, 100, 106, 2, 83, 4, 1, 102, 98, 1, 3, 43, 42, 3, 2, 1, 2, 9, 9, 7, 23, 21, 1, 8, 1, 3, 16, 1, 11, 2, 1, 1, 1, 9, 1, 19, 13, 13, 7, 1, 1, 1, 1, 5, 1, 4, 11, 20, 1, 6, 17, 6, 5, 21, 4, 12, 1, 10, 1, 1, 14, 1, 10, 7, 8, 10, 1, 1, 1, 5, 11, 9, 1, 1, 1, 1, 1, 11, 1, 9, 1, 1, 1, 15, 1, 3, 3, 1, 9, 1, 1, 11, 1, 9, 4, 2, 6, 1, 3, 1, 4, 1, 7, 6, 3, 1, 2, 1, 1
        ];
        let block_size = 10000; // Blocchi di n bit
        let simulation_length = 32000; // Simulazione per un totale di n bit
        let error_probability = 0.1; //irrilevante su prestazioni a limite, asintotiche
        let iterations = 8; // Numero di iterazioni di decodifica
        let rate = 1; // Rate 1/3
        let kyber_input = kyber_encryption_generation();
        // Creazione dell'oggetto TurboSimulation
        let simulation = TurboSimulation::new(
            kyber_input,
            perm,
            block_size,
            simulation_length,
            error_probability,
            iterations,
            rate,
        );

        // Esecuzione della simulazione
        let error_rate = simulation.run_simulation();

        // Validazione dei risultati
        println!("Error rate: {:?}", error_rate);
        // assert!(error_rate >= 0.0 && error_rate <= 1.0, "Invalid error rate");
    }

    fn read_last_n_numbers(file_path: &Path, n: usize) -> Vec<i32> {
        // Aprire il file in modalità lettura
        let mut file = File::open(file_path).expect("Errore nella apertura file");


        // Leggere il contenuto del file
        let mut content = String::new();
        let _ = file.read_to_string(&mut content).expect("errore nella lettura file");

        // Dividere i numeri separati da virgola
        let numbers: Vec<i32> = content
            .trim()
            .split(',')
            .filter_map(|s| s.trim().parse::<i32>().ok())
            .collect();

        // Prendere gli ultimi `n` numeri
        let start = if numbers.len() > n { numbers.len() - n } else { 0 };
        // println!("vettore {:?}",numbers[start..].to_vec());
        numbers[start..].to_vec()
    }

    #[test]
    fn test_turbo_simulation_dyn() {
        let simulation_length = 1000000; // lunghezza 200 blocchi per 5888, messaggio criptato
        let block_size = 64000; //6400 lunghezza chiave pubblica di pk kyber e c, dato da mandare sempre in kyber 512 800 e 736 altre robe
        let mut error_prob = 0.185;///da cambiare nella prossima simulazione

        let file_name = "C:\\Users\\feder\\RustroverProjects\\TurboCodesRust_thesis\\kcimpl\\src\\interleaver.txt";
        let file_path = Path::new(file_name);
        let mut perm_trimmed: Vec<i32> = read_last_n_numbers(file_path, block_size);

        let output_file_path = "C:\\Users\\feder\\RustroverProjects\\TurboCodesRust_thesis\\kcimpl\\src\\output.txt";
        let mut output_file = OpenOptions::new()
            .create(true)
            .write(true)
            .append(true)
            .open(output_file_path)
            .expect("Unable to open or create output file");
        let kyber_input = kyber_encryption_generation();

        //println!("perm_trimmed {:?}", perm_trimmed);
        for _ in 0..3 {
            let (bit_err, block_err, uncoded_p) = turbo_simulation_dynamic_length(kyber_input.clone(), perm_trimmed.clone(), block_size, simulation_length, error_prob, 8, 1);
            let output_line = format!(
                "p: {:?} | Bit errors: {:?} | Block errors: {:?} | uncoded_p: {:?}\n",
                error_prob, bit_err, block_err, uncoded_p
            );
            error_prob += 0.005;

            output_file
                .write_all(output_line.as_bytes())
                .expect("Failed to write to output file");
        }
    }
    fn turbo_simulation_dynamic_length(kyber_input: Vec<i32>, perm_trimmed: Vec<i32>, block_size: usize, simulation_length: usize, error_probability: f64, iterations: usize, rate: usize) -> (f64, f64, f64) {
        // Configurazione

        // let block_size = 10000; // Blocchi di n bit
        // let simulation_length = 32000; // Simulazione per un totale di n bit
        // let error_probability = 0.1; //irrilevante su prestazioni a limite, asintotiche
        // let iterations = 8; // Numero di iterazioni di decodifica
        // let rate = 1; // Rate 1/3

        // Creazione dell'oggetto TurboSimulation
        let simulation = TurboSimulation::new(
            kyber_input,
            perm_trimmed,
            block_size,
            simulation_length,
            error_probability,
            iterations,
            rate,
        );

        // Esecuzione della simulazione
        let (bit_error_rate, block_error_rate, uncoded_p) = simulation.run_simulation();

        // Validazione dei risultati
        (bit_error_rate, block_error_rate, uncoded_p)
        // assert!(error_rate >= 0.0 && error_rate <= 1.0, "Invalid error rate");
    }

    fn u8_to_i32_vector(n: u8) -> Vec<i32> { //funzione da byte a bit
        (0..8).rev().map(|i| ((n >> i) & 1) as i32).collect()
    }

    fn binary_to_signed(binary: Vec<i32>) -> Vec<i32> {
        binary.into_iter().map(|b| if b == 0 { -1 } else { 1 }).collect()
    }


    fn kyber_encryption_generation() -> Vec<i32> {
        use std::fs::OpenOptions;
        use std::io::Write;
        use kcimpl::{kyber512pke, ByteArray};
        let pke = kyber512pke();
        let output_file_path = "C:\\Users\\feder\\RustroverProjects\\TurboCodesRust_thesis\\kcimpl\\src\\kyber_keys.txt";
        let mut output_file = OpenOptions::new()
            .create(true)
            .write(true)
            .append(true)
            .open(output_file_path)
            .expect("Unable to open or create output file");
        let mut byte_vec: Vec<u8> = Vec::new();

        for i in 0..200 {

            // Bob wants to send an encrypted message to Alice
            let m = ByteArray::random(32);
            let r = ByteArray::random(32);

            // Alice runs keygen, publishes pk. Value sk is secret
            let (sk, pk) = pke.keygen();
            //println!("pk: {:?}", pk);

            // Bob uses the public key to encrypt the message
            let enc = pke.encrypt(&pk, &m, r.clone());
            byte_vec.extend(enc.clone().data); //concateno i vettori che ottengo volta per volta


            // let output_line = format!(
            //                 "{:?}",
            //                 enc.data
            //             );
            // output_file.write_all(output_line.as_bytes()).expect("Failed to write to output file");
            // println!("{:?}", enc.data.len());
            //     println!("First 512 bytes (should be pk): {:?}", &enc.data[0..512]);
            //     println!("Remaining bytes (ciphertext): {:?}", &enc.data[512..]);


            // Bob sends enc to Alice
            // Alice uses the secret key to recover m
            let dec = pke.decrypt(&sk, &enc);
        }
        let mut bit_vec: Vec<i32> = Vec::new();
        for i in 0..byte_vec.len() {
            let mut bin_vec: Vec<i32> = Vec::new();
            bin_vec = u8_to_i32_vector(byte_vec[i]);
            let mut signed_vec: Vec<i32> = binary_to_signed(bin_vec);
            bit_vec.extend(signed_vec); //trasformo in vettore di binario e aggiungo a vettore cumulativo di livelli, come pn sequence
        }
        bit_vec //ritorno vec di livelli

        //println!("levels vec {:?}", bit_vec.len()); //vec di livelli già
    }

    #[test]
    fn kem_metrics() {
        // Import delle librerie dentro la funzione
        use kcimpl::kyber512kem;
        use std::time::{Instant, Duration};
        use sysinfo::{System, ProcessExt, Pid};
        use std::fs::OpenOptions;
        use std::io::Write;
        use std::thread;

        // Crea un file di log o aprilo se esiste già
        let log_file_path = "log_info.txt";
        let mut log_file = OpenOptions::new()
            .create(true) // Crea il file se non esiste
            .append(true) // Aggiungi i dati alla fine del file
            .open(log_file_path)
            .expect("Failed to open log file");

        // Raccogli i dati CPU in un thread secondario (creato una sola volta fuori dal ciclo)
        let (cpu_usage_tx, cpu_usage_rx) = std::sync::mpsc::channel();
        let cpu_thread = thread::spawn(move || {
            let mut cpu_data = Vec::new();
            loop {
                thread::sleep(Duration::from_millis(100)); // Intervallo di raccolta CPU

                let mut sys = System::new_all();
                sys.refresh_all();

                // Ottieni i dati della CPU
                if let Some(proc) = sys.process(Pid::from(std::process::id() as usize)) {
                    let cpu_usage = proc.cpu_usage();
                    cpu_data.push(cpu_usage);
                }

                // Invia i dati tramite il canale
                if cpu_data.len() > 0 {
                    cpu_usage_tx.send(cpu_data.clone()).unwrap();
                }
            }
        });

        // Ciclo di 200 iterazioni
        for iteration in 0..200 {
            let mut sys = System::new_all();
            sys.refresh_all();

            let kem = kyber512kem();

            // Registra il tempo di inizio
            let start_time = Instant::now();

            // Ottiene il PID del processo corrente
            let pid = Pid::from(std::process::id() as usize);

            // Raccogli la memoria prima dell'esecuzione
            let mut mem_before = 0;
            if let Some(proc) = sys.process(pid) {
                mem_before = proc.memory();
            }

            // Alice runs keygen
            let (sk, pk) = kem.keygen();
            let public_key_len = pk.data.len(); // La lunghezza della public key in byte
            let public_key_len_bits = public_key_len * 8; // La lunghezza della public key in bit

            // Bob encapsulates key
            let (c, k) = kem.encaps(&pk);

            // Alice decapsulates key
            let k_recovered = kem.decaps(&c, &sk);

            // Registra il tempo di fine
            let duration = start_time.elapsed();

            // Aggiorna info di sistema dopo l'esecuzione
            sys.refresh_all();
            let mut mem_after = 0;
            if let Some(proc) = sys.process(pid) {
                mem_after = proc.memory();
            }

            // Calcola la memoria finale
            let mem_final = if mem_after >= mem_before {
                mem_after - mem_before
            } else {
                0 // Se la memoria finale è inferiore a quella iniziale, la differenza sarà 0
            };

            // Verifica la correttezza della decapsulazione
            assert_eq!(k, k_recovered);

            // Aspetta che il thread raccolga i dati della CPU

            // Raccolta dei dati dalla comunicazione con il thread secondario
            let cpu_data = cpu_usage_rx.recv().unwrap();

            // Calcola la media della CPU usage raw
            let cpu_usage_avg_raw: f32 = cpu_data.iter().copied().sum::<f32>() / cpu_data.len() as f32;
            let cpu_usage_normalized = cpu_usage_avg_raw / sys.physical_core_count().unwrap_or(1) as f32;

            // Scrivi i dati nel file di log
            writeln!(
                log_file,
                "Iteration {}: \n\
            Execution time: {:?}\n\
            CPU Usage (Raw Average): {:.2}%\n\
            CPU Usage (Normalized Average): {:.2}%\n\
            Memory usage (KB): {}\n\
            ",
                iteration + 1,
                duration,
                cpu_usage_avg_raw,
                cpu_usage_normalized,
                mem_final,
             //800 byte, 6400 bits di lunghezza, fissa
            )
                .expect("Failed to write to log file");

            // Aggiungi una riga vuota per separare le iterazioni
            writeln!(log_file).expect("Failed to write empty line to log file");
        }

        // Al termine del ciclo, fermiamo il thread
        drop(cpu_thread);
    }



}
