import os
from ament_index_python.packages import get_package_share_directory
from launch import LaunchDescription
from launch.actions import IncludeLaunchDescription
from launch.launch_description_sources import PythonLaunchDescriptionSource
from launch_ros.actions import Node

def generate_launch_description():
    # Path to the sllidar launch file
    sllidar_launch_file = '/root/yahboomcar_ros2_ws/software/library_ws/src/sllidar_ros2/launch/sllidar_launch.py'

    # Include the Lidar launch file using the correct path
    lidar_node = IncludeLaunchDescription(
        PythonLaunchDescriptionSource(sllidar_launch_file)
    )
    
    # Launch of ros2_autonomous_follow_optimized executable
    follow_node = Node(
        package='pkg_autonomous_follow_road',  # Package name
        executable='follow_road',  # Executable 
        name='autonomous_follow_road',  # Node name
        output='screen',
        parameters=[
            {"mqtt_broker": "localhost"},  
            {"mqtt_port": 1883}
        ]
    )

    # LaunchDescription that includes the lidar node and the autonomous follow node
    return LaunchDescription([lidar_node, follow_node])
