# import the necessary packages
from scipy.spatial import distance as dist
from collections import OrderedDict
import numpy as np

class SafeRover():
    
    def __init__(self, limit_left = 60, limit_right = 580, limit_bottom = 475, limit_swap = 100, abort_limit_count = 8 ):
        # this class take in input the bbox
        # store the objects
        # calculate the distance between the objects nand our limit collision
        # and then return the command that the rover have to do
            # command=0----> do what you want
               # command=1----> stop and turn left
            # command=2----> probability of swapping in the next frames with the target
            # command=3----> target lost
            # command=4----> swap: abort mission
            # 640 x axis
            # 480 y axis
        self.command = 0
        self.limit_point_left = limit_left
        self.limit_point_right = limit_right
        self.limit_swapping = limit_swap
        self.object_swap_possib_id = -1
        self.flag_swap_poss = -1
        self.abort_counter = 0
        self.abort_limit = abort_limit_count
        self.limit_point_bottom = limit_bottom

    
    def check_collision(self, rects):
        # check to see if the list of input bounding box rectangles
        # is empty
        #if is empty you can do what you want 
        if len(rects) == 0:
            self.command=0
            return self.command

        # initialize an array of input centroids for the current frame
        inputDistance = np.zeros((len(rects), 2), dtype="int")

        # loop over the bounding box rectangles
        for (i, (startX, startY, endX, endY)) in enumerate(rects):
            # use the bounding box coordinates to derive the centroid
            dleft = int(startX - self.limit_point_left)
            dright = int(endX - self.limit_point_right)
            dbott = int(endY - self.limit_point_bottom)
            if( dleft<0 and dright>0 or dbott > 0):
                 self.command=1
            
        return self.command
    

    def check_switch(self,objects,id_target,boxes):
        # check to see if the list of input bounding box rectangles
        # is empty
        min=320
        not_abort = 0
        self.command = 0
        if len(objects) == 0:
            self.command=0
            return self.command
        #objectCentroids = list(objects.values())
        
        try:
            targetcentroid = list(objects[id_target])
        except KeyError:
            self.command=3
            return self.command

        if( self.flag_swap_poss == 0):
            for (centroidID, centroid) in objects.items():
        
                if ( centroidID == self.object_swap_possib_id or centroidID == id_target ):	
                    for i in range(0, len(boxes)):
                        cord = self.center_calculator(boxes[i])
                        if ( cord[0] == centroid[0] and cord[1] == centroid[1] ):
                            not_abort = 1
                            break
                    # One of centroids that can cause switch is pending, so abort the mission	
                    if(not_abort == 0):
                        self.abort_counter += 1
                        print("Abort counter: "+ str(self.abort_counter))
                        if(self.abort_counter >= self.abort_limit):
                            self.command = 4
                            self.reset()
                            return self.command
            # the two centroids that can cause switch are not pending, so not abort the mission
            if(self.abort_counter == 0):
                self.reset()

        if( self.flag_swap_poss== -1):	

            for (id,centr) in  objects.items():
                dist=np.sqrt((targetcentroid[0]-centr[0])**2 + (targetcentroid[1]-centr[1])**2)
                if( min > dist and dist!= 0):
                    min=dist
                    self.object_swap_possib_id = id

        if( min < self.limit_swapping and self.flag_swap_poss == -1 ):
            self.command=2
            self.flag_swap_poss = 0
        else:
            self.object_swap_possib_id = -1

        return self.command


    def check_target(self,objects,id_target):

        target_found=0
        if len(objects) == 0:
            self.command=0
            return self.command
        objectIDs = list(objects.keys())
        for id in objectIDs:
            if id==id_target:
                target_found=1
        
        if target_found==0:
            self.command=3
        else:
            self.command=0
            
        return self.command


    def center_calculator(self,bxs):

        cX = int((bxs[0] + bxs[2]) / 2.0)
        cY = int((bxs[1] + bxs[3]) / 2.0)
        return (cX, cY)


    def reset(self):
        self.abort_counter = 0
        self.flag_swap_poss = -1
        self.object_swap_possib_id = -1
        
         