import jetson_inference
import jetson_utils
import time
import cv2
import numpy as np 
import tkinter as tk
from tkinter import ttk
from tkinter import messagebox
import math
from others_modules.centroid_tracking_module import Centroids
from others_modules.safe_rover_module import SafeRover
from others_modules.follow_me_module import FollowMe
from others_modules.follow_line_module import Follow_Line_Core
from others_modules.follow_road_module import Follow_Road_Core
import paho.mqtt.client as mqtt
import json
import argparse
import imutils
import signal
import sys


label_vetctor=["person",
"bicycle",
"car",
"motorcycle",
"airplane",
"bus",
"train",
"truck",
"boat",
"traffic_light",
"fire_hydrant",
"street_sign",
"stop_sign",
"parking_meter",
"bench",
"bird",
"cat",
"dog",
"horse",
"sheep",
"cow",
"elephant",
"bear",
"zebra",
"giraffe",
"hat",
"backpack",
"umbrella",
"shoe",
"eye_glasses",
"handbag",
"tie",
"suitcase",
"frisbee",
"skis",
"snowboard",
"sports_ball",
"kite",
"baseball_bat",
"baseball_glove",
"skateboard",
"surfboard",
"tennis_racket",
"bottle",
"plate",
"wine_glass",
"cup",
"fork",
"knife",
"spoon",
"bowl",
"banana",
"apple",
"sandwich",
"orange",
"broccoli",
"carrot",
"hot_dog",
"pizza",
"donut",
"cake",
"chair",
"couch",
"potted_plant",
"bed",
"mirror",
"dining_table",
"window",
"desk",
"toilet",
"door",
"tv",
"laptop",
"mouse",
"remote",
"keyboard",
"cell_phone",
"microwave",
"oven",
"toaster",
"sink",
"refrigerator",
"blender",
"book",
"clock",
"vase",
"scissors",
"teddy_bear",
"hair_drier",
"toothbrush",
"hair_brush"]

# MQTT broker details
broker_ip = "localhost"  
broker_port = 1883  # Default MQTT port

# MQTT topic
topic = "robot/control"

def on_connect(client, userdata, flags, rc):
    if rc == 0:
        print("Connected to MQTT Broker!")
    #else:
        #print(f"Failed to connect, return code {rc}")

# Initialize the MQTT client
client = mqtt.Client()

# Set up the connection callback
client.on_connect = on_connect

# Connect to the broker
client.connect(broker_ip, broker_port, 60)

# Start the loop
client.loop_start()

def send_command(direction, angle=None):
    command = {"command": direction}
    if angle is not None:
        command["angle"] = angle
    client.publish("robot/control", json.dumps(command))

def send_activate():
    command = {"command": "activate"}
    client.publish("robot/control", json.dumps(command))

def send_deactivate():
    command = {"command": "deactivate"}
    client.publish("robot/control", json.dumps(command))

def send_emergency_stop():
    command = {"command": "emergency_stop"}
    client.publish("robot/control", json.dumps(command))

def send_stop():
    command = {"command": "stop"}
    client.publish("robot/control", json.dumps(command))

def truncate(f, n):
    '''Truncates/pads a float f to n decimal places without rounding'''
    s = '{}'.format(f)
    if 'e' in s or 'E' in s:
        return '{0:.{1}f}'.format(f, n)
    i, p, d = s.partition('.')
    return '.'.join([i, (d+'0'*n)[:n]])


def detection_center(detection):
    """Computes the center x, y coordinates of the object"""
    #bbox = detection['bbox']
    top=int(detection.Top)
    left=int(detection.Left)
    bottom=int(detection.Bottom)
    right=int(detection.Right)
    center_x = (left + right) / 2.0 - 0.5
    center_y = (bottom + top) / 2.0 - 0.5

    """center_x = (bbox[0] + bbox[2]) / 2.0 - 0.5
    center_y = (bbox[1] + bbox[3]) / 2.0 - 0.5"""
    return (center_x, center_y)


def module_vec_target(vec):
    """Computes the length of the 2D vector"""
    img_center_x=640/2
    img_center_y=0
    return np.sqrt((vec[0]-img_center_x)**2 + (vec[1]-img_center_y)**2)


def norm(vec):
    """Computes the length of the 2D vector"""
    img_center_x=640/2
    img_center_y=480/2
    return np.sqrt((vec[0]-img_center_x)**2 + (vec[1]-img_center_y)**2)


def closest_detection(detections):
    """Finds the detection closest to the image center"""
    closest_detection = None
    for det in detections:
        center = detection_center(det)
        if closest_detection is None:
            closest_detection = det
        elif norm(detection_center(det)) < norm(detection_center(closest_detection)):
            closest_detection = det
    return closest_detection


def farthest_detection(detections):
    """Finds the detection closest to the image center"""
    farest_detection = None
    for det in detections:
        center = detection_center(det)
        if farest_detection is None:
            farest_detection = det
        elif norm(detection_center(det)) > norm(detection_center(farest_detection)):
            farest_detection = det
    return farest_detection


def Central_Mode():

    timeStamp=time.time()
    fpsFilt=0
    net=jetson_inference.detectNet('ssd-mobilenet-v2',threshold=.7)
    dispW=640
    dispH=480
    flip=2
    font=cv2.FONT_HERSHEY_SIMPLEX
    

    cam=cv2.VideoCapture(0)
    ct=Centroids()
    while True:

        #img, width, height= cam.CaptureRGBA()
        _,img = cam.read()
        height=img.shape[0]
        width=img.shape[1]
    
        frame=cv2.cvtColor(img,cv2.COLOR_BGR2RGBA).astype(np.float32)
        frame=jetson_utils.cudaFromNumpy(frame)
    
        detections=net.Detect(frame, width, height)

        matching_detections= []
        rects=[]
        for detect in detections:

            ID=detect.ClassID
            confidence=truncate(float(detect.Confidence),2)
            top=int(detect.Top)
            left=int(detect.Left)
            bottom=int(detect.Bottom)
            right=int(detect.Right)
            item=net.GetClassDesc(ID)
            
        
            if item=='person':
                matching_detections.append(detect)
                box=(left,top,right,bottom)   
                rects.append(box)
            
            cv2.putText(img,item+" "+str(confidence),(left,top+20),font,.75,(0,0,255),2)    
            cv2.rectangle(img,(left,top),(right,bottom),(0,0,255),1) 

        
        # get detection closest to center of field of view and draw it
        det = closest_detection(matching_detections)
       
        # otherwise go forward if no target detected
        objects = ct.centroids_recalculator(rects)
        for (objectID, centroid) in objects.items():
            # draw both the ID of the object and the centroid of the
            # object on the output frame
            text = "ID {}".format(objectID)
            cv2.putText(img, text, (centroid[0] - 10, centroid[1] - 10),
            cv2.FONT_HERSHEY_SIMPLEX, 0.5, (0, 255, 0), 2)
            cv2.circle(img, (centroid[0], centroid[1]), 4, (0, 255, 0), -1)  
            
        if det is None:
            cv2.putText(img,"No target detected",(int(580/2),int(480/2)),font,1,(0,0,255),2)     
        # otherwsie steer towards target
        else:
            # move robot forward and steer proportional target's x-distance from center
            
            center = detection_center(det)
            dist_target=module_vec_target(center)
            angle=(np.arctan(abs(center[0]-(640/2))/(480-center[1]+0.01))*180/math.pi)
            top=int(det.Top)
            left=int(det.Left)
            bottom=int(det.Bottom)
            right=int(det.Right)
            """print(angle,dist_target)"""
        
            cv2.putText(img,"target found",(int(center[0]-60),int(center[1])),font,.75,(0,255,0),2)   
            if(center[0] < 640/2):
                cv2.putText(img,"GO LEFT "+str(int(angle))+"deg",(0,40),font,1,(255,255,255),2)   
            else:
                cv2.putText(img,"GO RIGHT "+str(int(angle))+"deg",(480,40),font,1,(255,255,255),2)   
            
            cv2.line(img,(int((640/2)),480),(int(center[0]),int(center[1])+150),(255,255,255),5)
                
        #display.RenderOnce(img,width,height)
        dt=time.time()-timeStamp
        timeStamp=time.time()
        fps=1/dt
        fpsFilt=.9*fpsFilt + .1*fps
    

        cv2.putText(img,str(round(fpsFilt,1))+' fps',(500,400),font,1,(0,0,255),2)
        cv2.imshow('detCam',img)
        cv2.moveWindow('detCam',0,0)
        if cv2.waitKey(1)==ord('q'):
            break
    cam.release()
    cv2.destroyAllWindows()


def Farthest_Mode():

    timeStamp=time.time()
    fpsFilt=0
    net=jetson_inference.detectNet('ssd-mobilenet-v2',threshold=.7)
    dispW=640
    dispH=480
    flip=2
    font=cv2.FONT_HERSHEY_SIMPLEX
    
    cam=cv2.VideoCapture(0)

    while True:

        #img, width, height= cam.CaptureRGBA()
        _,img = cam.read()
        height=img.shape[0]
        width=img.shape[1]
    
        frame=cv2.cvtColor(img,cv2.COLOR_BGR2RGBA).astype(np.float32)
        frame=jetson_utils.cudaFromNumpy(frame)
    
        detections=net.Detect(frame, width, height)

        matching_detections= []

        for detect in detections:

            ID=detect.ClassID
            confidence=truncate(float(detect.Confidence),2)
            top=int(detect.Top)
            left=int(detect.Left)
            bottom=int(detect.Bottom)
            right=int(detect.Right)
            item=net.GetClassDesc(ID)
        
            if item=='person':
                matching_detections.append(detect)
            
            cv2.putText(img,item+" "+str(confidence),(left,top+20),font,.75,(0,0,255),2)    
            cv2.rectangle(img,(left,top),(right,bottom),(0,0,255),1) 

        
        # get detection closest to center of field of view and draw it
        det = farthest_detection(matching_detections)
        if det is not None:
            top=int(det.Top)
            left=int(det.Left)
            bottom=int(det.Bottom)
            right=int(det.Right)

            cv2.putText(img,item+" "+str(confidence),(left,top+20),font,.75,(0,255,0),2)   
            cv2.rectangle(img,(left,top),(right,bottom),(0,255,0),1)

        
        # otherwise go forward if no target detected
        if det is None:
            cv2.putText(img,"No target detected",(540/2,480/2),font,1,(0,0,255),2)     
        # otherwsie steer towards target
        else:
            # move robot forward and steer proportional target's x-distance from center
            center = detection_center(det)
            dist_target=module_vec_target(center)
            angle=(np.arctan(abs(center[0]-(640/2))/(480-center[1]+0.01))*180/math.pi)
            top=int(det.Top)
            left=int(det.Left)
            bottom=int(det.Bottom)
            right=int(det.Right)
            print(angle,dist_target)
        
            cv2.putText(img,"target found",(int(center[0]-60),int(center[1])),font,.75,(0,255,0),2)   
            if(center[0] < 640/2):
                cv2.putText(img,"GO LEFT "+str(int(angle))+"deg",(0,40),font,1,(255,255,255),2)   
            else:
                cv2.putText(img,"GO RIGHT "+str(int(angle))+"deg",(500,40),font,1,(255,255,255),2)   
            
            cv2.line(img,((640/2),480),(int(center[0]),int(center[1])),(255,255,255),5)
                
        #display.RenderOnce(img,width,height)
        dt=time.time()-timeStamp
        timeStamp=time.time()
        fps=1/dt
        fpsFilt=.9*fpsFilt + .1*fps
    

        cv2.putText(img,str(round(fpsFilt,1))+' fps',(500,400),font,1,(0,0,255),2)
        cv2.imshow('detCam',img)
        cv2.moveWindow('detCam',0,0)
        if cv2.waitKey(1)==ord('q'):
            break
    cam.release()
    cv2.destroyAllWindows()


def personalized_mode(class_sel):
   
    timeStamp=time.time()
    fpsFilt=0
    net=jetson_inference.detectNet('ssd-mobilenet-v2',threshold=.7)
    dispW=640
    dispH=480
    flip=2
    font=cv2.FONT_HERSHEY_SIMPLEX
    
    cam=cv2.VideoCapture(0)
    while True:

        #img, width, height= cam.CaptureRGBA()
        _,img = cam.read()
        height=img.shape[0]
        width=img.shape[1]
    
        frame=cv2.cvtColor(img,cv2.COLOR_BGR2RGBA).astype(np.float32)
        frame=jetson_utils.cudaFromNumpy(frame)
    
        detections=net.Detect(frame, width, height)

        matching_detections= []

        for detect in detections:

            ID=detect.ClassID
            confidence=truncate(float(detect.Confidence),2)
            top=int(detect.Top)
            left=int(detect.Left)
            bottom=int(detect.Bottom)
            right=int(detect.Right)
            item=net.GetClassDesc(ID)
        
            if item==class_sel:
                matching_detections.append(detect)
            
            cv2.putText(img,item+" "+str(confidence),(left,top+20),font,.75,(0,0,255),2)    
            cv2.rectangle(img,(left,top),(right,bottom),(0,0,255),1)
        
        
        # get detection closest to center of field of view and draw it
        det = closest_detection(matching_detections)
        if det is not None:
            top=int(det.Top)
            left=int(det.Left)
            bottom=int(det.Bottom)
            right=int(det.Right)

            cv2.putText(img,item+" "+str(confidence),(left,top+20),font,.75,(0,255,0),2)   
            cv2.rectangle(img,(left,top),(right,bottom),(0,255,0),1)

        
        # otherwise go forward if no target detected
        if det is None:
            cv2.putText(img,"No target detected",(int(640/2),int(480/2)),font,1,(0,0,255),2)     
        # otherwsie steer towards target
        else:
            # move robot forward and steer proportional target's x-distance from center
            center = detection_center(det)
            dist_target=module_vec_target(center)
            angle=(np.arctan(abs(center[0]-(640/2))/(480-center[1]+0.01))*180/math.pi)
            top=int(det.Top)
            left=int(det.Left)
            bottom=int(det.Bottom)
            right=int(det.Right)
            print(angle,dist_target)
        
            cv2.putText(img,"target found",(int(center[0]-60),int(center[1])),font,.75,(0,255,0),2)   
            if(center[0] < 640/2):
                cv2.putText(img,"GO LEFT "+str(int(angle))+"deg",(0,40),font,1,(255,255,255),2)   
            else:
                cv2.putText(img,"GO RIGHT "+str(int(angle))+"deg",(480,40),font,1,(255,255,255),2)   
            
            cv2.line(img,(int((640/2)),480),(int(center[0]),int(center[1])),(255,255,255),5)
                
        #display.RenderOnce(img,width,height)
        dt=time.time()-timeStamp
        timeStamp=time.time()
        fps=1/dt
        fpsFilt=.9*fpsFilt + .1*fps
    

        cv2.putText(img,str(round(fpsFilt,1))+' fps',(500,400),font,1,(0,0,255),2)
        cv2.imshow('detCam',img)
        cv2.moveWindow('detCam',0,0)
        if cv2.waitKey(1)==ord('q'):
            break
    cam.release()
    cv2.destroyAllWindows()


def reach_target(class_sel):

    timeStamp=time.time()
    fpsFilt=0
    net=jetson_inference.detectNet('ssd-mobilenet-v2',threshold=.75)
    dispW=640
    dispH=480
    flip=2
    font=cv2.FONT_HERSHEY_SIMPLEX
    
    cam=cv2.VideoCapture(0)
    ct = Centroids()
    sf = SafeRover()
    fm = FollowMe()
    target = -1
    error_message = -1
    counter_message = 0
    limit_bottom = 450
    END_OF_THE_MISSION=0
    
    while True:

        #img, width, height= cam.CaptureRGBA()
        _,img = cam.read()
        height=img.shape[0]
        width=img.shape[1]
        
        frame=cv2.cvtColor(img,cv2.COLOR_BGR2RGBA).astype(np.float32)
        frame=jetson_utils.cudaFromNumpy(frame)
    
        detections=net.Detect(frame, width, height)

        matching_detections= []
        rects = []
        all_objects= []

        for detect in detections:

            ID=detect.ClassID
            confidence=truncate(float(detect.Confidence),2)
            top=int(detect.Top)
            left=int(detect.Left)
            bottom=int(detect.Bottom)
            right=int(detect.Right)
            item=net.GetClassDesc(ID)
            box=(left,top,right,bottom)
            
            if item == class_sel:
                matching_detections.append(detect)
                box_class=(left,top,right,bottom)   
                rects.append(box_class)
                cv2.putText(img,item+" "+str(confidence),(left,top+20),font,.75,(0,0,255),2)    
                cv2.rectangle(img,(left,top),(right,bottom),(0,0,255),1)
          
            all_objects.append(box)

        if len(rects) == 0 and target == -1:
            cv2.putText(img,"No class: "+class_sel+" detected",(int(520/2),int(460/2)),font,1,(0,0,255),2)     
        
        # otherwsie steer towards target
        else: 

            objects = ct.centroids_recalculator(rects) 

            # Waiting for a target       
            if(target == -1):

                target_object = closest_detection(matching_detections)
                center_targ = detection_center(target_object)
                for (centroidID, centroid) in objects.items():
                    if(centroid[0] == center_targ[0] and centroid[1]==centroid[1]):
                        target = centroidID
                    

            # Target selected
            else:  
                if(END_OF_THE_MISSION!=1):
                    # Control for an eventual lost of target
                    if(sf.check_target(objects,target) == 3):
                        target = -1
                        print("Target Lost:"+str(target))     
                        error_message = 1

                    else:

                        for obj in matching_detections:
                            center_targ = detection_center(obj)
                            if(center_targ[0] == objects[target][0] and center_targ[1] == objects[target][1]):
                                target_object = obj
                                break
                        print(str(target_object.Bottom))

                        # Control if is the Target is reached                  
                        if(int(target_object.Bottom) >= limit_bottom):                   
                            END_OF_THE_MISSION=1
                            print("END OF THE MISSION"+str(END_OF_THE_MISSION))
                            
                        # Control if an object is too close
                        ret_command=sf.check_collision(all_objects)    
                        if ret_command == 1:
                            cv2.putText(img,"- Stop: probability of collision -",(int(450),int(480/2)),font,.75,(100,100,255),4)

                        # Control for an eventual switching
                        ret_command = sf.check_switch(objects,target,rects)            
                        if(ret_command == 2):
                            cv2.putText(img,"- Probability of an object switch in the next frames -",(int(450),int(480/2)),font,.75,(255,255,255),4)                 
                        if(ret_command == 4):  
                            print("Abort Mission")
                            target=-1
                            error_message = 2

                for (objectID, centroid) in objects.items():
                    # draw both the ID of the object and the centroid of the
                    # object on the output frame
                    text = "ID {}".format(objectID)
                    cv2.putText(img, text, (centroid[0] - 10, centroid[1] - 10),
                    cv2.FONT_HERSHEY_SIMPLEX, 0.5, (0, 255, 0), 2)
                    cv2.circle(img, (centroid[0], centroid[1]), 4, (0, 255, 0), -1)  
                
                    if ( objectID == target ):
                        angle=(np.arctan(abs(centroid[0]-(640/2))/(480-centroid[1]+0.01))*180/math.pi)
                        if(centroid[0] < 640/2):
                            cv2.putText(img,"GO LEFT "+str(int(angle))+"deg",(0,40),font,1,(255,255,255),2)   
                        else:
                            cv2.putText(img,"GO RIGHT "+str(int(angle))+"deg",(500,40),font,1,(255,255,255),2)   

                        cv2.line(img,(int(640/2),480),(centroid[0],centroid[1]+150),(255,255,255),2)
                

                #display an eventuaL error message for N frames
                if(error_message != -1):
                    if (error_message == 1):
                            cv2.putText(img,"- Target Lost: Abort Mission -",(int(450),int(480/2)),font,.75,(100,100,255),5)                 
                            counter_message += 1
                            if(counter_message == 24):
                                error_message = -1
                                counter_message = 0
                    if (error_message == 2):
                            cv2.putText(img,"- Switching Avoidance: Abort Mission -",(int(450),int(480/2)),font,.75,(100,100,255),5)                 
                            counter_message += 1
                            if(counter_message == 24):
                                error_message = -1
                                counter_message = 0

        if (END_OF_THE_MISSION==1):
                cv2.putText(img,"- Target reached end of the mission -",(int(450),int(480/2)),font,.75,(100,100,255),5)                 
                counter_message += 1
                if(counter_message == 24):
                    return

        #display.RenderOnce(img,width,height)
        dt=time.time()-timeStamp
        timeStamp=time.time()
        fps=1/dt
        fpsFilt=.9*fpsFilt + .1*fps
    

        cv2.putText(img,str(round(fpsFilt,1))+' fps',(500,400),font,1,(0,0,255),2)
        cv2.imshow('detCam',img)
        cv2.moveWindow('detCam',200,200)
        if cv2.waitKey(1)==ord('q'):
            break
    cam.release()
    cv2.destroyAllWindows()

def Follow_Me():

    timeStamp = time.time()
    fpsFilt = 0
    net = jetson_inference.detectNet('ssd-mobilenet-v2', threshold=.65)
    dispW = 640
    dispH = 480
    danger_threshold = 461
    close_threshold = 440 
    stop_duration_threshold = 0.7  # 1 second for stop duration
    last_stop_time = None  # To track the last time a stop command was sent
    flip = 2
    font = cv2.FONT_HERSHEY_SIMPLEX

    cam=cv2.VideoCapture(0)

    #out = cv2.VideoWriter('recording.mp4', cv2.VideoWriter_fourcc(*'mp4v'), 20, (dispW, dispH))

    ct = Centroids()
    sf = SafeRover()
    fm = FollowMe()
    target = -1
    error_message = -1
    counter_message = 0
    bounding_boxes = {}  # Dictionary to store bounding boxes by CentroidID

    while True:
        #img, width, height= cam.CaptureRGBA()
        _,img = cam.read()
        height=img.shape[0]
        width=img.shape[1]
        
        frame=cv2.cvtColor(img,cv2.COLOR_BGR2RGBA).astype(np.float32)
        frame=jetson_utils.cudaFromNumpy(frame)
    
        detections=net.Detect(frame, width, height)

        matching_detections= []
        rects = []
        all_objects= []

        for detect in detections:

            ID=detect.ClassID
            confidence=truncate(float(detect.Confidence),2)
            top=int(detect.Top)
            left=int(detect.Left)
            bottom=int(detect.Bottom)
            right=int(detect.Right)
            item=net.GetClassDesc(ID)
            box=(left,top,right,bottom)

            if item == 'person':
                matching_detections.append(detect)
                box_person=(left,top,right,bottom)   
                rects.append(box_person)
                cv2.putText(img,item+" "+str(confidence),(left,top+20),font,.75,(0,0,255),2)    
                cv2.rectangle(img,(left,top),(right,bottom),(0,0,255),1)
          
            all_objects.append(box)
            
        objects = ct.centroids_recalculator(rects) 

        for (objectID, centroid), bbox in zip(objects.items(), rects):
            bounding_boxes[objectID] = bbox  # Map CentroidID to its bounding box
        
        
        if(fm.count_sleep == fm.max_sleep):

            # Waiting for a target       
            if(target == -1):
                target = fm.follow_update(objects,rects)

            # Target selected
            else:  

                # Control for an eventual lost of target
                if(sf.check_target(objects,target) == 3):
                    send_stop()
                    target = -1
                    print("Target Lost:"+str(target))     
                    error_message = 1

                else:
                    # Control if an object is too close
                    ret_command=sf.check_collision(all_objects)
                    if ret_command == 1:
                        cv2.putText(img,"- Stop: probability of collision -",(int(120),int(480/2)),font,.75,(100,100,255),4)                 
                    
                    # Control for an eventual switching
                    ret_command = sf.check_switch(objects,target,rects)            
                    if(ret_command == 2):
                        cv2.putText(img,"- Probability of an object switch in the next frames -",(int(50),int(480/2)),font,.75,(255,255,255),4)                 
                    if(ret_command == 4):  
                        print("Abort Mission")
                        send_stop()
                        target=-1
                        error_message = 2

                    target = fm.unfollow_update(objects,rects,target)
        else:
            fm.count_sleep += 1

        for (objectID, centroid) in objects.items():
            # draw both the ID of the object and the centroid of the
            # object on the output frame
            text = "ID {}".format(objectID)
            cv2.putText(img, text, (centroid[0] - 10, centroid[1] - 10),
            cv2.FONT_HERSHEY_SIMPLEX, 0.5, (0, 255, 0), 2)
            cv2.circle(img, (centroid[0], centroid[1]), 4, (0, 255, 0), -1)  
           
            if objectID == target:
                    angle = (np.arctan(abs(centroid[0] - (640 / 2)) / (480 - centroid[1] + 0.01)) * 180 / math.pi)
                    if target in bounding_boxes:
                        _, _, _, bottom = bounding_boxes[target]
                    # If person is too close (stop area)
                    if bottom >= close_threshold and bottom < danger_threshold:
                        send_command("stop")
                        cv2.putText(img, "STOP", (200, 260), font, 1, (0, 0, 255), 2)
                        last_stop_time = time.time()  # Record the time when we stopped

                    # If person is dangerously close
                    elif bottom >= danger_threshold:
                        send_command("backward")
                        cv2.putText(img, "MOVE BACKWARD!", (220, 260), font, 1, (0, 0, 255), 2)
                        last_stop_time = time.time()  # Reset stop timer when moving backward

                    # If person is far enough to resume movement
                    else:
                        # Only resume if 1 second has passed since the last stop message
                        if last_stop_time and time.time() - last_stop_time >= stop_duration_threshold or last_stop_time==None:
                            if centroid[0] < 640 / 2 - 10:
                                send_command("left", int(angle))
                                cv2.putText(img, "GO LEFT " + str(int(angle)) + "deg", (0, 40), font, 1, (255, 255, 255), 2)
                            elif centroid[0] > 640 / 2 + 10:
                                send_command("right", int(angle))
                                cv2.putText(img, "GO RIGHT " + str(int(angle)) + "deg", (440, 40), font, 1, (255, 255, 255), 2)
                            else:
                                send_command("forward")
                                cv2.putText(img, "GO STRAIGHT", (200, 40), font, 1, (255, 255, 255), 2)

                            # Reset last_stop_time since we're moving again
                            last_stop_time = None

                        cv2.line(img, (int(640 / 2), 480), (centroid[0], centroid[1] + 150), (255, 255, 255), 2)
        #display an eventuaL error message for N frames
        if(error_message != -1):
            if (error_message == 1):
                    cv2.putText(img,"- Target Lost: Abort Mission -",(int(200),int(480/2)),font,.75,(100,100,255),5)                 
                    counter_message += 1
                    if(counter_message == 24):
                        error_message = -1
                        counter_message = 0
            if (error_message == 2):
                    cv2.putText(img,"- Switching Avoidance: Abort Mission -",(int(200),int(480/2)),font,.75,(100,100,255),5)                 
                    counter_message += 1
                    if(counter_message == 24):
                        error_message = -1
                        counter_message = 0
       
        #display.RenderOnce(img,width,height)
        dt=time.time()-timeStamp
        timeStamp=time.time()
        fps=1/dt
        fpsFilt=.9*fpsFilt + .1*fps
    

        cv2.putText(img, str(round(fpsFilt,1))+' fps',(480,400),font,1,(0,0,255),2)
        cv2.imshow('detCam', img)
        #cv2.moveWindow('detCam',0,0)
        if cv2.waitKey(1) == ord('q'):
            break
    cam.release()
    #out.release()  # Release the video writer to save the file
    send_deactivate()  # Deactivate the robot when quitting
    cv2.destroyAllWindows()
    client.loop_stop()
    client.disconnect()

# Function for dynamic target selection
def Select_Class_Dyn():
    root = tk.Tk()
    root.title('Choose Target Class') 

    main_frame = ttk.Frame(root, padding="20")
    main_frame.pack(fill="both", expand=True)

    label1 = ttk.Label(main_frame, text='Select your target class', font=('Helvetica', 16, 'bold'))
    label1.pack(pady=10)

    label2 = ttk.Label(main_frame, text='Insert your Target:', font=('Helvetica', 12))
    label2.pack(pady=10)

    entry1 = ttk.Entry(main_frame, font=('Helvetica', 12))
    entry1.pack(pady=10)

    def getTarget():
        target = entry1.get()
        label_vetctor = ["Class A", "Class B", "Class C"]  # Example class list
        if target not in label_vetctor:               
            messagebox.showerror("Input Error", "Input invalid, no class found.")
        else:
            reach_target(target)
            print(f"target: {target}")
    
    button1 = ttk.Button(main_frame, text='Get Target', command=getTarget)
    button1.pack(pady=20)

    root.mainloop()

# Function for static target selection
def Select_Class():
    root = tk.Tk()
    root.title('Choose Target Class') 

    main_frame = ttk.Frame(root, padding="20")
    main_frame.pack(fill="both", expand=True)

    label1 = ttk.Label(main_frame, text='Select your Target', font=('Helvetica', 16, 'bold'))
    label1.pack(pady=10)

    label2 = ttk.Label(main_frame, text='Insert your Target:', font=('Helvetica', 12))
    label2.pack(pady=10)

    entry1 = ttk.Entry(main_frame, font=('Helvetica', 12))
    entry1.pack(pady=10)

    def getTarget():
        target = entry1.get()
        label_vetctor = ["Class A", "Class B", "Class C"]  # Example class list
        if target not in label_vetctor:               
            messagebox.showerror("Input Error", "Input invalid, no class found.")
        else:
            personalized_mode(target)
            print(f"target: {target}")

    button1 = ttk.Button(main_frame, text='Get Target', command=getTarget)
    button1.pack(pady=20)

    root.mainloop()





# Global reference to main Tk root
root = None
main_frame = None

# UI Colors
BG_COLOR = "#2C3E50"
BTN_COLOR = "#3498DB"
BTN_HOVER = "#2980B9"
TEXT_COLOR = "white"

def on_enter(e):
    e.widget.config(bg=BTN_HOVER)

def on_leave(e):
    e.widget.config(bg=BTN_COLOR)

# Function to create styled buttons
def create_button(parent, text, command):
    btn = tk.Button(
        parent, text=text, command=command, font=('Helvetica', 12, 'bold'),
        bg=BTN_COLOR, fg="white", activebackground=BTN_HOVER, activeforeground="white",
        relief="flat", padx=10, pady=5, borderwidth=3
    )
    btn.bind("<Enter>", on_enter)
    btn.bind("<Leave>", on_leave)
    btn.pack(pady=10, ipadx=10, ipady=5, fill="x")
    return btn

# Function to handle CTRL+C and close Tkinter windows
def exit_handler(sig, frame):
    print("Closing all windows...")
    if root:
        root.quit()
        root.destroy()
    sys.exit(0)

# Set signal handler for CTRL+C
signal.signal(signal.SIGINT, exit_handler)

# Function to switch menus
def switch_menu(title, buttons, show_back=True):
    """Cambia dinamicamente il contenuto della finestra con un nuovo menu."""
    for widget in main_frame.winfo_children():
        widget.destroy()

    label = tk.Label(main_frame, text=title, font=('Helvetica', 16, 'bold'), fg=TEXT_COLOR, bg=BG_COLOR)
    label.pack(pady=10)

    for text, command in buttons:
        create_button(main_frame, text, command)

    if show_back:
        create_button(main_frame, "Back", main_menu)

# Main menu (senza Back)
def main_menu():
    switch_menu("Select Your Functionality", [
        ("Dynamic Modes", dynamic_modes),
        ("Static Modes", static_modes)
    ], show_back=False)

# Static modes menu
def static_modes():
    switch_menu("Static Modes", [
        ("Most Central Object", Central_Mode),
        ("Farthest Object", Farthest_Mode),
        ("Select Detection Class", Select_Class)
    ])

# Dynamic modes menu
def dynamic_modes():
    switch_menu("Dynamic Modes", [
        ("Follow Me", Follow_Me),
        ("Reach Targets", Select_Class_Dyn),
        ("Follow Line", Follow_Line),
        ("Follow Road", Follow_Road),

    ])

def maskCalibration():
    """Funzione per calibrare manulamente la maschera attraverso una finestra dedicata."""
    
    # Avvia la videocamera
    cap = cv2.VideoCapture(0)

    # Crea una finestra per i cursori
    cv2.namedWindow("Trackbars")

    # Valori di default per la linea verde
    default_low_b = np.uint8([38, 71, 125])
    default_high_b = np.uint8([77, 255, 255])

    # Cursori per Hue, Saturation e Value
    cv2.createTrackbar("Low H", "Trackbars", default_low_b[0], 179, nothing)
    cv2.createTrackbar("High H", "Trackbars", default_high_b[0], 179, nothing)
    cv2.createTrackbar("Low S", "Trackbars", default_low_b[1], 255, nothing)
    cv2.createTrackbar("High S", "Trackbars", default_high_b[1], 255, nothing)
    cv2.createTrackbar("Low V", "Trackbars", default_low_b[2], 255, nothing)
    cv2.createTrackbar("High V", "Trackbars", default_high_b[2], 255, nothing)

    # Imposta subito i valori di default sulle trackbars
    cv2.setTrackbarPos("Low H", "Trackbars", default_low_b[0])
    cv2.setTrackbarPos("High H", "Trackbars", default_high_b[0])
    cv2.setTrackbarPos("Low S", "Trackbars", default_low_b[1])
    cv2.setTrackbarPos("High S", "Trackbars", default_high_b[1])
    cv2.setTrackbarPos("Low V", "Trackbars", default_low_b[2])
    cv2.setTrackbarPos("High V", "Trackbars", default_high_b[2])

    while True:
        ret, frame = cap.read()
        if not ret:
            break

        # Converti il frame in HSV
        hsv_frame = cv2.cvtColor(frame, cv2.COLOR_BGR2HSV)

        # Leggi i valori dei cursori
        low_h = cv2.getTrackbarPos("Low H", "Trackbars")
        high_h = cv2.getTrackbarPos("High H", "Trackbars")
        low_s = cv2.getTrackbarPos("Low S", "Trackbars")
        high_s = cv2.getTrackbarPos("High S", "Trackbars")
        low_v = cv2.getTrackbarPos("Low V", "Trackbars")
        high_v = cv2.getTrackbarPos("High V", "Trackbars")

        # Definisci i range HSV
        low_b = np.uint8([low_h, low_s, low_v])
        high_b = np.uint8([high_h, high_s, high_v])

        # Crea la maschera
        mask = cv2.inRange(hsv_frame, low_b, high_b)

        # Mostra la maschera e il frame originale
        cv2.imshow("Mask", mask)
        cv2.imshow("Frame", frame)

        # Esci premendo 'q'
        if cv2.waitKey(1) & 0xFF == ord('q'):
            break

    cap.release()
    cv2.destroyAllWindows()

    # Se l'utente non ha cambiato nulla, usa i valori di default
    if (low_b == default_low_b).all() and (high_b == default_high_b).all():
        print("No changes detected, using default green line values")
        return default_low_b, default_high_b

    return low_b, high_b

def nothing(x):
    pass

def Follow_Line():
    print("Starting mask calibration before Follow Line...")
    
    # Avvia la calibrazione della maschera
    low_b, high_b = maskCalibration()  # Ottieni i valori aggiornati
    
    # Avvia Follow Line con i valori ottenuti dalla calibrazione
    print(f"Using HSV range: Low={low_b}, High={high_b}")
    try:
        return Follow_Line_Core(send_activate, send_command, send_stop, truncate, low_b, high_b)
    except KeyboardInterrupt:
        exit_handler(None, None)


def Follow_Road():
    print("Starting mask calibration before Follow Line...")

    # Avvia la calibrazione della maschera
    low_b, high_b = maskCalibration()  # Ottieni i valori aggiornati
    
    # Avvia Follow Road con i valori ottenuti dalla calibrazione
    print(f"Using HSV range: Low={low_b}, High={high_b}")
    try:
        return Follow_Road_Core(send_activate, send_command, send_stop, truncate, low_b, high_b)
    except KeyboardInterrupt:
        exit_handler(None, None)

# Main function to start the application
def start_gui():
    global root, main_frame
    root = tk.Tk()
    root.title('Principal Menu')
    root.geometry('400x500')
    root.configure(bg=BG_COLOR)

    main_frame = tk.Frame(root, bg=BG_COLOR, padx=20, pady=20)
    main_frame.pack(fill="both", expand=True)

    main_menu()

    root.mainloop()

# Run the application
if __name__ == "__main__":
    start_gui()
