library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
library lpm;
use lpm.lpm_components.all;
library altera_mf;
use altera_mf.altera_mf_components.all;

entity user is
	port
	(
		-- Main clock inputs
		mainClk	: in std_logic;
		slowClk	: in std_logic;
		-- Main reset input
		reset		: in std_logic;
		-- MCU interface (UART, I2C)
		mcuUartTx	: in std_logic;
		mcuUartRx	: out std_logic;
		mcuI2cScl	: in std_logic;
		mcuI2cSda	: inout std_logic;
		-- Logic state analyzer/stimulator
		lsasBus	: inout std_logic_vector( 31 downto 0 );
		-- Dip switches
		switches	: in std_logic_vector( 7 downto 0 );
		-- LEDs
		leds		: out std_logic_vector( 3 downto 0 )
	);
end user;

architecture behavioural of user is

	signal clk: std_logic;
	signal pllLock: std_logic;

	signal lsasBusIn: std_logic_vector( 31 downto 0 );
	signal lsasBusOut: std_logic_vector( 31 downto 0 );
	signal lsasBusEn: std_logic_vector( 31 downto 0 ) := ( others => '0' );

	signal mcuI2cDIn: std_logic;
	signal mcuI2CDOut: std_logic;
	signal mcuI2cEn: std_logic := '0';	

	
	component myAltPll
		PORT
		(
			areset		: IN STD_LOGIC  := '0';
			inclk0		: IN STD_LOGIC  := '0';
			c0		: OUT STD_LOGIC ;
			locked		: OUT STD_LOGIC 
		);
	end component;
	
	component SPI_Avalon_System
	   PORT
		(
	   	clk_clk       : in  std_logic; --   clk.clk
		   reset_reset_n : in  std_logic; -- reset.reset_n
		   spi_mosi      : in  std_logic; --   spi.mosi
		   spi_ss        : in  std_logic; --      .ss
		   spi_miso      : out std_logic;        --      .miso
		   spi_sclk      : in  std_logic;  --      .sclk
         en_miso       : out std_logic
	   );
   end component;
	
begin

--**********************************************************************************
--* Main clock PLL
--**********************************************************************************

	myAltPll_inst : myAltPll PORT MAP (
		areset	 => reset,
		inclk0	 => mainClk,
		c0	 => clk,
		locked	 => pllLock
	);

--**********************************************************************************
--* LEDs
--**********************************************************************************

	leds(3 downto 0) <= switches(3 downto 0);
	
   
--**********************************************************************************
--* 		lsasBus	: inout std_logic_vector( 31 downto 0 )
--**********************************************************************************
	lsasBusIn <= lsasBus;
 
	lsasBus_tristate:
	process( lsasBusEn, lsasBusOut) is
	begin
		for index in 0 to 31 loop
			if lsasBusEn( index ) = '1'  then
				lsasBus( index ) <= lsasBusOut ( index );
			else
				lsasBus( index ) <= 'Z';

			end if;
		end loop;
	end process;
	
	
	system : SPI_Avalon_System 
	   port map(
	      clk_clk        => mainClk,
		   reset_reset_n  => reset,
		   spi_mosi       => lsasBusIn(15),
		   spi_sclk       => lsasBusIn(13),
		   spi_ss         => lsasBusIn(12),    
		   spi_miso       => lsasBusOut(14),
	      en_miso        => lsasBusEn(14)
			);
			
end behavioural;
--------------------------------------------------------------------------------