library ieee;
use ieee.std_logic_1164.all;

entity PISO is
     port(
         clock        : in std_logic;
         reset        : in std_logic;
         Write_enable : in std_logic;
         Shift_enable : in std_logic;
         din          : in std_logic_vector(31 downto 0);
         dout         : out std_logic
         );
end PISO;


architecture behavior of PISO is
begin

PISO : process (clock) is

variable temp : std_logic_vector(31 downto 0);

begin

if (clock ='1' AND clock'event) then
        if (reset='1') then
		  
            temp := "00000000000000000000000000000000";
		  
        elsif (Write_enable = '1') then
            temp := din; 
				dout <= temp(31);
				temp := temp(30 downto 0) & '0';
		  
		  elsif (Shift_enable = '1' ) then
		      dout <= temp(31);
				temp := temp(30 downto 0) & '0';	
		 
        end if;
		  
end if;

end process PISO;
end behavior;