library ieee;
use ieee.std_logic_1164.all;


entity DP_Slave_SPI_to_Avalon is
	port(
	      MOSI                    :     in std_logic; 
	      SCLK                    :     in std_logic; --Input from eternal SPI
	      MISO                    :     out std_logic;
			Data_Read               :     in std_logic_vector (31 downto 0);
			clock                   :     in std_logic;
			rst                     :     in std_logic;
			SS_en                   :     in std_logic;
			Sh_data_read            :     in std_logic;
			load_data_read          :     in std_logic; 
			Sh_data_write           :     in std_logic;
			Sh_address              :     in std_logic;
			Sh_Command              :     in std_logic; 
			Enable_Cnt              :     in std_logic;
			Shift_SCLK              :     in std_logic;
			reset_cnt               :     in std_logic;
			Serial_Falling_Edge     :     out std_logic;
			Serial_Rise_Edge        :     out std_logic;
			wr                      :     out std_logic;
			rd                      :     out std_logic;
			TC8                     :     out std_logic;
			TC32                    :     out std_logic;
			Address                 :     out std_logic_vector(31 downto 0);
			Data_write              :     out std_logic_vector(31 downto 0)
	      );
end DP_Slave_SPI_to_Avalon;

architecture arch of DP_Slave_SPI_to_Avalon is

signal opcode :std_logic_vector(31 downto 0);
	
begin 
	
Command_Register : entity work.SIPO 
   port map	(
	   InSIPO  => MOSI,
      LD      => SS_en,
	 	SH      => Sh_Command,
		Clk     => clock,
		Reset   => rst,
		OutSIPO => opcode);

Opcode_Decode : entity work.Code_Decoder 
   port map (
	   Clock      => Clock,
      Out_Enable => SS_en,
      Code_IN    => opcode(31 downto 24),
      rd         => rd,
		wr         => wr);

Address_Register : entity work.SIPO 
   port map	(
	   InSIPO  => MOSI,
      LD      => SS_en,
	 	SH      => Sh_Address,
		Clk     => clock,
		Reset   => rst,
		OutSIPO => Address);

Data_Write_Register : entity work.SIPO 
   port map	(
	   InSIPO  => MOSI,
      LD      => SS_en,
	 	SH      => Sh_data_write,
		Clk     => clock,
		Reset   => rst,
		OutSIPO => Data_write);

Data_Read_Register : entity work.PISO 
   port map(
      clock        => clock,
      reset        => rst,
      Write_enable => load_data_read,
      Shift_enable => Sh_data_read,
      din          => Data_Read,
      dout         => MISO);

Counter_Bits :  entity work.Counter8_32 
   port map(
	   enable => Enable_Cnt,
		clock  => clock,
		reset  => reset_cnt,
		TC8    => TC8,
		TC32   => TC32);

Synchronization_Serial_Clock : entity work.Edge_detector 
   port map (
	   Clk                 => clock,
      Rst                 => rst,
		SS                  => SS_en,
      Serial_Clk          => SCLK,
		Shift_SCLK          => Shift_SCLK,
      Serial_Rising_Edge  => Serial_Rise_Edge,
      Serial_Falling_Edge => Serial_Falling_Edge);

end arch;