-- SPI_Avalon_Component.vhd

-- This file was auto-generated as a prototype implementation of a module
-- created in component editor.  It ties off all outputs to ground and
-- ignores all inputs.  It needs to be edited to make it do something
-- useful.
-- 
-- This file will not be automatically regenerated.  You should check it in
-- to your version control system if you want to keep it.

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity SPI_Avalon_Component is
	port (
		avalon_master_address     : out std_logic_vector(31 downto 0);                    -- avalon_master.address
		avalon_master_read        : out std_logic;                                        --              .read
		avalon_master_readdata    : in  std_logic_vector(31 downto 0) := (others => '0'); --              .readdata
		avalon_master_waitrequest : in  std_logic                     := '0';             --              .waitrequest
		avalon_master_write       : out std_logic;                                        --              .write
		avalon_master_writedata   : out std_logic_vector(31 downto 0);                    --              .writedata
		clock_sink_clk            : in  std_logic                     := '0';             --    clock_sink.clk
		reset_sink_reset          : in  std_logic                     := '0';             --    reset_sink.reset
		mosi                      : in  std_logic                     := '0';             --   conduit_end.mosi
		ss                        : in  std_logic                     := '0';             --              .ss
		miso                      : out std_logic;                                        --              .miso
		sclk                      : in  std_logic                     := '0' ;		--              .sclk
	   en_miso                   : out std_logic
	);
end entity SPI_Avalon_Component;

architecture rtl of SPI_Avalon_Component is
SIGNAL Sh_data_read_i          : STD_LOGIC;
SIGNAL SS_En_i                 : STD_LOGIC;
SIGNAL Sh_sclk_i               : STD_LOGIC;
SIGNAL load_data_read_i        : STD_LOGIC;
SIGNAL Sh_data_write_i         : STD_LOGIC;
SIGNAL Sh_address_i            : STD_LOGIC;
SIGNAL Sh_Command_i            : STD_LOGIC;
SIGNAL Enable_Cnt_i            : STD_LOGIC;
SIGNAL Serial_Falling_Edge_i   : STD_LOGIC;
SIGNAL Serial_Rise_Edge_i      : STD_LOGIC;
SIGNAL TC8_i                   : STD_LOGIC;
SIGNAL TC32_i                  : STD_LOGIC;
SIGNAL wr_i                    : STD_LOGIC;
SIGNAL rd_i                    : STD_LOGIC;
SIGNAL reset_cnt_i             : STD_LOGIC;
SIGNAL reset_system_i          : STD_LOGIC;
SIGNAL general_reset           : STD_LOGIC;
SIGNAL rst_cmd_reg_i           : STD_LOGIC;
SIGNAL ld_cmd_i                : STD_LOGIC;

begin 

	
	general_reset <= reset_sink_reset or reset_system_i;
	
Datapath : entity work.DP_Slave_SPI_to_Avalon
  PORT MAP(
     MOSI                => mosi,
	  SCLK                => sclk,
     MISO                => miso,
	  Data_Read           => avalon_master_readdata,
	  clock               => clock_sink_clk,
     rst                 => general_reset,
	  SS_en               => SS_En_i,
	  Sh_data_read        => Sh_data_read_i,
	  load_data_read      => load_data_read_i,
	  Sh_data_write       => Sh_data_write_i,
	  Sh_address          => Sh_address_i,
	  Sh_Command          => Sh_Command_i,
	  Enable_Cnt          => Enable_Cnt_i,
	  Shift_SCLK          => Sh_sclk_i,
	  reset_cnt           => reset_cnt_i,
	  Serial_Falling_Edge => Serial_Falling_Edge_i,
	  Serial_Rise_Edge    => Serial_Rise_Edge_i,
	  wr                  => wr_i,
	  rd                  => rd_i,
	  TC8                 => TC8_i,
	  TC32                => TC32_i,
	  Address             => avalon_master_address,
	  Data_write          => avalon_master_writedata,
	  rst_cmd_reg         => rst_cmd_reg_i,
	  ld_cmd              => ld_cmd_i
	  );

Control_Unit : entity work.FSM_Slave_SPI_to_Avalon
   PORT MAP(
	   clock               => clock_sink_clk,
      Serial_Rising_Edge  => Serial_Rise_Edge_i,
	   Serial_Falling_Edge => Serial_Falling_Edge_i,
	   TC8                 => TC8_i,
	   TC32                => TC32_i,
	   SS                  => ss,
	   wr                  => wr_i,
	   rd                  => rd_i,
	   clr                 => reset_sink_reset,
	   waitrequest         => avalon_master_waitrequest,
	   wr_mem              => avalon_master_write,
	   rd_mem              => avalon_master_read,
	   en_cnt              => Enable_Cnt_i,
	   en_miso             => en_miso,
	   SS_En               => SS_En_i,
	   shift_SCLK          => Sh_sclk_i,
	   Shiftcommand        => Sh_Command_i,
	   reset_cnt           => reset_cnt_i,
	   shiftaddress        => Sh_address_i,
	   shiftdata           => Sh_data_write_i,
	   loaddata            => load_data_read_i,
	   shiftreaddata       => Sh_data_read_i,
		rst_cmd_reg         => rst_cmd_reg_i,
      ld_cmd              => ld_cmd_i,
		reset_system        => reset_system_i

		);
end architecture rtl; -- of SPI_Avalon_Component
