library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity Counter8_32 is
	port(
	      enable : in std_logic;
			clock  : in std_logic;
			reset  : in std_logic;
			TC8    : out std_logic;
			TC32   : out std_logic
			);
end Counter8_32;

architecture Behavior of Counter8_32 is
	
signal OutCounter_i: unsigned(5 downto 0);
	
begin
	 
	 process(clock)
	 
	 begin
		
		if (Clock'event and clock = '1') then
			if (reset = '1') then
				OutCounter_i <= "000000";
			elsif (enable = '1') then
				OutCounter_i <= OutCounter_i + 1;
			end if;
			
		end if;

	end process;
   
	
	TC8  <= (not OutCounter_i(0)) and (not OutCounter_i(1)) and (not OutCounter_i(2)) and (OutCounter_i(3)) and (not OutCounter_i(4)) and (not OutCounter_i(5));
	TC32 <= (not OutCounter_i(0)) and (not OutCounter_i(1)) and (not OutCounter_i(2)) and (not OutCounter_i(3)) and (not OutCounter_i(4)) and (OutCounter_i(5));
	

end Behavior;