library ieee;
use ieee.std_logic_1164.all;

entity Code_Decoder is
  port(
         Clock      : in std_logic; 
         Out_Enable : in std_logic;
         Code_IN    : in std_logic_vector(7 downto 0);
         rd         : out std_logic;
			wr         : out std_logic);
			
end Code_Decoder;

architecture Behavioral of Code_Decoder is

begin

process(Clock)
   begin
	if (Clock='1' and Clock'event) then
         
			case Code_IN is
	  	 
            when "01110111" => if Out_Enable = '1' then -- w in ASCII
				                      rd <= '0';
		                            wr <= '1';
										 end if;
											  
            when "01110010" => if Out_Enable = '1' then -- r in ASCII
				                      rd <= '1';
					                   wr <= '0';
										 end if;
                
            when others => if Out_Enable = '1' then 
				                      rd <= '0';
					                   wr <= '0';
										 end if;
         end case;
			end if;
   end process;
end Behavioral;

					 