-- SPI_Avalon_System.vhd

-- Generated using ACDS version 20.1 711

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity SPI_Avalon_System is
	port (
		clk_clk       : in  std_logic := '0'; --   clk.clk
		reset_reset_n : in  std_logic := '0'; -- reset.reset_n
		spi_mosi      : in  std_logic := '0'; --   spi.mosi
		spi_ss        : in  std_logic := '0'; --      .ss
		spi_miso      : out std_logic;        --      .miso
		spi_sclk      : in  std_logic := '0'  --      .sclk
	);
end entity SPI_Avalon_System;

architecture rtl of SPI_Avalon_System is
	component SPI_Avalon_Component is
		port (
			avalon_master_address     : out std_logic_vector(31 downto 0);                    -- address
			avalon_master_read        : out std_logic;                                        -- read
			avalon_master_readdata    : in  std_logic_vector(31 downto 0) := (others => 'X'); -- readdata
			avalon_master_waitrequest : in  std_logic                     := 'X';             -- waitrequest
			avalon_master_write       : out std_logic;                                        -- write
			avalon_master_writedata   : out std_logic_vector(31 downto 0);                    -- writedata
			clock_sink_clk            : in  std_logic                     := 'X';             -- clk
			reset_sink_reset          : in  std_logic                     := 'X';             -- reset
			mosi                      : in  std_logic                     := 'X';             -- mosi
			ss                        : in  std_logic                     := 'X';             -- ss
			miso                      : out std_logic;                                        -- miso
			sclk                      : in  std_logic                     := 'X'              -- sclk
		);
	end component SPI_Avalon_Component;

	component SPI_Avalon_System_onchip_memory2_0 is
		port (
			clk        : in  std_logic                     := 'X';             -- clk
			address    : in  std_logic_vector(9 downto 0)  := (others => 'X'); -- address
			clken      : in  std_logic                     := 'X';             -- clken
			chipselect : in  std_logic                     := 'X';             -- chipselect
			write      : in  std_logic                     := 'X';             -- write
			readdata   : out std_logic_vector(31 downto 0);                    -- readdata
			writedata  : in  std_logic_vector(31 downto 0) := (others => 'X'); -- writedata
			byteenable : in  std_logic_vector(3 downto 0)  := (others => 'X'); -- byteenable
			reset      : in  std_logic                     := 'X';             -- reset
			reset_req  : in  std_logic                     := 'X';             -- reset_req
			freeze     : in  std_logic                     := 'X'              -- freeze
		);
	end component SPI_Avalon_System_onchip_memory2_0;

	component SPI_Avalon_System_mm_interconnect_0 is
		port (
			clk_0_clk_clk                                                 : in  std_logic                     := 'X';             -- clk
			SPI_Avalon_Component_0_reset_sink_reset_bridge_in_reset_reset : in  std_logic                     := 'X';             -- reset
			SPI_Avalon_Component_0_avalon_master_address                  : in  std_logic_vector(31 downto 0) := (others => 'X'); -- address
			SPI_Avalon_Component_0_avalon_master_waitrequest              : out std_logic;                                        -- waitrequest
			SPI_Avalon_Component_0_avalon_master_read                     : in  std_logic                     := 'X';             -- read
			SPI_Avalon_Component_0_avalon_master_readdata                 : out std_logic_vector(31 downto 0);                    -- readdata
			SPI_Avalon_Component_0_avalon_master_write                    : in  std_logic                     := 'X';             -- write
			SPI_Avalon_Component_0_avalon_master_writedata                : in  std_logic_vector(31 downto 0) := (others => 'X'); -- writedata
			onchip_memory2_0_s1_address                                   : out std_logic_vector(9 downto 0);                     -- address
			onchip_memory2_0_s1_write                                     : out std_logic;                                        -- write
			onchip_memory2_0_s1_readdata                                  : in  std_logic_vector(31 downto 0) := (others => 'X'); -- readdata
			onchip_memory2_0_s1_writedata                                 : out std_logic_vector(31 downto 0);                    -- writedata
			onchip_memory2_0_s1_byteenable                                : out std_logic_vector(3 downto 0);                     -- byteenable
			onchip_memory2_0_s1_chipselect                                : out std_logic;                                        -- chipselect
			onchip_memory2_0_s1_clken                                     : out std_logic                                         -- clken
		);
	end component SPI_Avalon_System_mm_interconnect_0;

	component altera_reset_controller is
		generic (
			NUM_RESET_INPUTS          : integer := 6;
			OUTPUT_RESET_SYNC_EDGES   : string  := "deassert";
			SYNC_DEPTH                : integer := 2;
			RESET_REQUEST_PRESENT     : integer := 0;
			RESET_REQ_WAIT_TIME       : integer := 1;
			MIN_RST_ASSERTION_TIME    : integer := 3;
			RESET_REQ_EARLY_DSRT_TIME : integer := 1;
			USE_RESET_REQUEST_IN0     : integer := 0;
			USE_RESET_REQUEST_IN1     : integer := 0;
			USE_RESET_REQUEST_IN2     : integer := 0;
			USE_RESET_REQUEST_IN3     : integer := 0;
			USE_RESET_REQUEST_IN4     : integer := 0;
			USE_RESET_REQUEST_IN5     : integer := 0;
			USE_RESET_REQUEST_IN6     : integer := 0;
			USE_RESET_REQUEST_IN7     : integer := 0;
			USE_RESET_REQUEST_IN8     : integer := 0;
			USE_RESET_REQUEST_IN9     : integer := 0;
			USE_RESET_REQUEST_IN10    : integer := 0;
			USE_RESET_REQUEST_IN11    : integer := 0;
			USE_RESET_REQUEST_IN12    : integer := 0;
			USE_RESET_REQUEST_IN13    : integer := 0;
			USE_RESET_REQUEST_IN14    : integer := 0;
			USE_RESET_REQUEST_IN15    : integer := 0;
			ADAPT_RESET_REQUEST       : integer := 0
		);
		port (
			reset_in0      : in  std_logic := 'X'; -- reset
			clk            : in  std_logic := 'X'; -- clk
			reset_out      : out std_logic;        -- reset
			reset_req      : out std_logic;        -- reset_req
			reset_req_in0  : in  std_logic := 'X'; -- reset_req
			reset_in1      : in  std_logic := 'X'; -- reset
			reset_req_in1  : in  std_logic := 'X'; -- reset_req
			reset_in2      : in  std_logic := 'X'; -- reset
			reset_req_in2  : in  std_logic := 'X'; -- reset_req
			reset_in3      : in  std_logic := 'X'; -- reset
			reset_req_in3  : in  std_logic := 'X'; -- reset_req
			reset_in4      : in  std_logic := 'X'; -- reset
			reset_req_in4  : in  std_logic := 'X'; -- reset_req
			reset_in5      : in  std_logic := 'X'; -- reset
			reset_req_in5  : in  std_logic := 'X'; -- reset_req
			reset_in6      : in  std_logic := 'X'; -- reset
			reset_req_in6  : in  std_logic := 'X'; -- reset_req
			reset_in7      : in  std_logic := 'X'; -- reset
			reset_req_in7  : in  std_logic := 'X'; -- reset_req
			reset_in8      : in  std_logic := 'X'; -- reset
			reset_req_in8  : in  std_logic := 'X'; -- reset_req
			reset_in9      : in  std_logic := 'X'; -- reset
			reset_req_in9  : in  std_logic := 'X'; -- reset_req
			reset_in10     : in  std_logic := 'X'; -- reset
			reset_req_in10 : in  std_logic := 'X'; -- reset_req
			reset_in11     : in  std_logic := 'X'; -- reset
			reset_req_in11 : in  std_logic := 'X'; -- reset_req
			reset_in12     : in  std_logic := 'X'; -- reset
			reset_req_in12 : in  std_logic := 'X'; -- reset_req
			reset_in13     : in  std_logic := 'X'; -- reset
			reset_req_in13 : in  std_logic := 'X'; -- reset_req
			reset_in14     : in  std_logic := 'X'; -- reset
			reset_req_in14 : in  std_logic := 'X'; -- reset_req
			reset_in15     : in  std_logic := 'X'; -- reset
			reset_req_in15 : in  std_logic := 'X'  -- reset_req
		);
	end component altera_reset_controller;

	signal spi_avalon_component_0_avalon_master_readdata    : std_logic_vector(31 downto 0); -- mm_interconnect_0:SPI_Avalon_Component_0_avalon_master_readdata -> SPI_Avalon_Component_0:avalon_master_readdata
	signal spi_avalon_component_0_avalon_master_waitrequest : std_logic;                     -- mm_interconnect_0:SPI_Avalon_Component_0_avalon_master_waitrequest -> SPI_Avalon_Component_0:avalon_master_waitrequest
	signal spi_avalon_component_0_avalon_master_address     : std_logic_vector(31 downto 0); -- SPI_Avalon_Component_0:avalon_master_address -> mm_interconnect_0:SPI_Avalon_Component_0_avalon_master_address
	signal spi_avalon_component_0_avalon_master_read        : std_logic;                     -- SPI_Avalon_Component_0:avalon_master_read -> mm_interconnect_0:SPI_Avalon_Component_0_avalon_master_read
	signal spi_avalon_component_0_avalon_master_write       : std_logic;                     -- SPI_Avalon_Component_0:avalon_master_write -> mm_interconnect_0:SPI_Avalon_Component_0_avalon_master_write
	signal spi_avalon_component_0_avalon_master_writedata   : std_logic_vector(31 downto 0); -- SPI_Avalon_Component_0:avalon_master_writedata -> mm_interconnect_0:SPI_Avalon_Component_0_avalon_master_writedata
	signal mm_interconnect_0_onchip_memory2_0_s1_chipselect : std_logic;                     -- mm_interconnect_0:onchip_memory2_0_s1_chipselect -> onchip_memory2_0:chipselect
	signal mm_interconnect_0_onchip_memory2_0_s1_readdata   : std_logic_vector(31 downto 0); -- onchip_memory2_0:readdata -> mm_interconnect_0:onchip_memory2_0_s1_readdata
	signal mm_interconnect_0_onchip_memory2_0_s1_address    : std_logic_vector(9 downto 0);  -- mm_interconnect_0:onchip_memory2_0_s1_address -> onchip_memory2_0:address
	signal mm_interconnect_0_onchip_memory2_0_s1_byteenable : std_logic_vector(3 downto 0);  -- mm_interconnect_0:onchip_memory2_0_s1_byteenable -> onchip_memory2_0:byteenable
	signal mm_interconnect_0_onchip_memory2_0_s1_write      : std_logic;                     -- mm_interconnect_0:onchip_memory2_0_s1_write -> onchip_memory2_0:write
	signal mm_interconnect_0_onchip_memory2_0_s1_writedata  : std_logic_vector(31 downto 0); -- mm_interconnect_0:onchip_memory2_0_s1_writedata -> onchip_memory2_0:writedata
	signal mm_interconnect_0_onchip_memory2_0_s1_clken      : std_logic;                     -- mm_interconnect_0:onchip_memory2_0_s1_clken -> onchip_memory2_0:clken
	signal rst_controller_reset_out_reset                   : std_logic;                     -- rst_controller:reset_out -> [SPI_Avalon_Component_0:reset_sink_reset, mm_interconnect_0:SPI_Avalon_Component_0_reset_sink_reset_bridge_in_reset_reset, onchip_memory2_0:reset]
	signal reset_reset_n_ports_inv                          : std_logic;                     -- reset_reset_n:inv -> rst_controller:reset_in0

begin

	spi_avalon_component_0 : component SPI_Avalon_Component
		port map (
			avalon_master_address     => spi_avalon_component_0_avalon_master_address,     -- avalon_master.address
			avalon_master_read        => spi_avalon_component_0_avalon_master_read,        --              .read
			avalon_master_readdata    => spi_avalon_component_0_avalon_master_readdata,    --              .readdata
			avalon_master_waitrequest => spi_avalon_component_0_avalon_master_waitrequest, --              .waitrequest
			avalon_master_write       => spi_avalon_component_0_avalon_master_write,       --              .write
			avalon_master_writedata   => spi_avalon_component_0_avalon_master_writedata,   --              .writedata
			clock_sink_clk            => clk_clk,                                          --    clock_sink.clk
			reset_sink_reset          => rst_controller_reset_out_reset,                   --    reset_sink.reset
			mosi                      => spi_mosi,                                         --   conduit_end.mosi
			ss                        => spi_ss,                                           --              .ss
			miso                      => spi_miso,                                         --              .miso
			sclk                      => spi_sclk                                          --              .sclk
		);

	onchip_memory2_0 : component SPI_Avalon_System_onchip_memory2_0
		port map (
			clk        => clk_clk,                                          --   clk1.clk
			address    => mm_interconnect_0_onchip_memory2_0_s1_address,    --     s1.address
			clken      => mm_interconnect_0_onchip_memory2_0_s1_clken,      --       .clken
			chipselect => mm_interconnect_0_onchip_memory2_0_s1_chipselect, --       .chipselect
			write      => mm_interconnect_0_onchip_memory2_0_s1_write,      --       .write
			readdata   => mm_interconnect_0_onchip_memory2_0_s1_readdata,   --       .readdata
			writedata  => mm_interconnect_0_onchip_memory2_0_s1_writedata,  --       .writedata
			byteenable => mm_interconnect_0_onchip_memory2_0_s1_byteenable, --       .byteenable
			reset      => rst_controller_reset_out_reset,                   -- reset1.reset
			reset_req  => '0',                                              -- (terminated)
			freeze     => '0'                                               -- (terminated)
		);

	mm_interconnect_0 : component SPI_Avalon_System_mm_interconnect_0
		port map (
			clk_0_clk_clk                                                 => clk_clk,                                          --                                               clk_0_clk.clk
			SPI_Avalon_Component_0_reset_sink_reset_bridge_in_reset_reset => rst_controller_reset_out_reset,                   -- SPI_Avalon_Component_0_reset_sink_reset_bridge_in_reset.reset
			SPI_Avalon_Component_0_avalon_master_address                  => spi_avalon_component_0_avalon_master_address,     --                    SPI_Avalon_Component_0_avalon_master.address
			SPI_Avalon_Component_0_avalon_master_waitrequest              => spi_avalon_component_0_avalon_master_waitrequest, --                                                        .waitrequest
			SPI_Avalon_Component_0_avalon_master_read                     => spi_avalon_component_0_avalon_master_read,        --                                                        .read
			SPI_Avalon_Component_0_avalon_master_readdata                 => spi_avalon_component_0_avalon_master_readdata,    --                                                        .readdata
			SPI_Avalon_Component_0_avalon_master_write                    => spi_avalon_component_0_avalon_master_write,       --                                                        .write
			SPI_Avalon_Component_0_avalon_master_writedata                => spi_avalon_component_0_avalon_master_writedata,   --                                                        .writedata
			onchip_memory2_0_s1_address                                   => mm_interconnect_0_onchip_memory2_0_s1_address,    --                                     onchip_memory2_0_s1.address
			onchip_memory2_0_s1_write                                     => mm_interconnect_0_onchip_memory2_0_s1_write,      --                                                        .write
			onchip_memory2_0_s1_readdata                                  => mm_interconnect_0_onchip_memory2_0_s1_readdata,   --                                                        .readdata
			onchip_memory2_0_s1_writedata                                 => mm_interconnect_0_onchip_memory2_0_s1_writedata,  --                                                        .writedata
			onchip_memory2_0_s1_byteenable                                => mm_interconnect_0_onchip_memory2_0_s1_byteenable, --                                                        .byteenable
			onchip_memory2_0_s1_chipselect                                => mm_interconnect_0_onchip_memory2_0_s1_chipselect, --                                                        .chipselect
			onchip_memory2_0_s1_clken                                     => mm_interconnect_0_onchip_memory2_0_s1_clken       --                                                        .clken
		);

	rst_controller : component altera_reset_controller
		generic map (
			NUM_RESET_INPUTS          => 1,
			OUTPUT_RESET_SYNC_EDGES   => "deassert",
			SYNC_DEPTH                => 2,
			RESET_REQUEST_PRESENT     => 0,
			RESET_REQ_WAIT_TIME       => 1,
			MIN_RST_ASSERTION_TIME    => 3,
			RESET_REQ_EARLY_DSRT_TIME => 1,
			USE_RESET_REQUEST_IN0     => 0,
			USE_RESET_REQUEST_IN1     => 0,
			USE_RESET_REQUEST_IN2     => 0,
			USE_RESET_REQUEST_IN3     => 0,
			USE_RESET_REQUEST_IN4     => 0,
			USE_RESET_REQUEST_IN5     => 0,
			USE_RESET_REQUEST_IN6     => 0,
			USE_RESET_REQUEST_IN7     => 0,
			USE_RESET_REQUEST_IN8     => 0,
			USE_RESET_REQUEST_IN9     => 0,
			USE_RESET_REQUEST_IN10    => 0,
			USE_RESET_REQUEST_IN11    => 0,
			USE_RESET_REQUEST_IN12    => 0,
			USE_RESET_REQUEST_IN13    => 0,
			USE_RESET_REQUEST_IN14    => 0,
			USE_RESET_REQUEST_IN15    => 0,
			ADAPT_RESET_REQUEST       => 0
		)
		port map (
			reset_in0      => reset_reset_n_ports_inv,        -- reset_in0.reset
			clk            => clk_clk,                        --       clk.clk
			reset_out      => rst_controller_reset_out_reset, -- reset_out.reset
			reset_req      => open,                           -- (terminated)
			reset_req_in0  => '0',                            -- (terminated)
			reset_in1      => '0',                            -- (terminated)
			reset_req_in1  => '0',                            -- (terminated)
			reset_in2      => '0',                            -- (terminated)
			reset_req_in2  => '0',                            -- (terminated)
			reset_in3      => '0',                            -- (terminated)
			reset_req_in3  => '0',                            -- (terminated)
			reset_in4      => '0',                            -- (terminated)
			reset_req_in4  => '0',                            -- (terminated)
			reset_in5      => '0',                            -- (terminated)
			reset_req_in5  => '0',                            -- (terminated)
			reset_in6      => '0',                            -- (terminated)
			reset_req_in6  => '0',                            -- (terminated)
			reset_in7      => '0',                            -- (terminated)
			reset_req_in7  => '0',                            -- (terminated)
			reset_in8      => '0',                            -- (terminated)
			reset_req_in8  => '0',                            -- (terminated)
			reset_in9      => '0',                            -- (terminated)
			reset_req_in9  => '0',                            -- (terminated)
			reset_in10     => '0',                            -- (terminated)
			reset_req_in10 => '0',                            -- (terminated)
			reset_in11     => '0',                            -- (terminated)
			reset_req_in11 => '0',                            -- (terminated)
			reset_in12     => '0',                            -- (terminated)
			reset_req_in12 => '0',                            -- (terminated)
			reset_in13     => '0',                            -- (terminated)
			reset_req_in13 => '0',                            -- (terminated)
			reset_in14     => '0',                            -- (terminated)
			reset_req_in14 => '0',                            -- (terminated)
			reset_in15     => '0',                            -- (terminated)
			reset_req_in15 => '0'                             -- (terminated)
		);

	reset_reset_n_ports_inv <= not reset_reset_n;

end architecture rtl; -- of SPI_Avalon_System
