library ieee;
use ieee.std_logic_1164.all;

entity Edge_detector is
   port (
      Clk                    : in  std_logic;
      Rst                    : in  std_logic;
		SS                     : in  std_logic;
      Serial_Clk             : in  std_logic;
		Shift_SCLK             : in  std_logic;
      Serial_Rising_Edge     : out std_logic;
      Serial_Falling_Edge    : out std_logic
		);

end Edge_detector;

architecture EdgeDetector_rtl of Edge_detector is

signal Out_SIPO : std_logic_vector(31 downto 0);

begin 
	
Synchronization : entity work.SIPO 
   port map(
      InSIPO  => Serial_Clk,
	   LD      => SS,
      SH      => Shift_SCLK,
		Clk     => Clk, 
		Reset   => Rst, 
		OutSIPO => Out_SIPO);
		
Serial_Rising_Edge <= (not Out_SIPO(2)) and Out_SIPO(1); 
Serial_Falling_Edge <= (not Out_SIPO(1)) and  Out_SIPO(2);   
  

end EdgeDetector_rtl;