library ieee;
use ieee.std_logic_1164.all;

entity Pattern_Generator is
port(
   clock                         : in  std_logic;
	reset                         : in  std_logic;
	start                         : in  std_logic_vector(31 downto 0);
	stop                          : in  std_logic;
	setting                       : in  std_logic_vector(3 downto 0);
	clock_divider                 : in  std_logic_vector(31 downto 0);
	external_clock                : in  std_logic;
	sel_clk                       : in  std_logic_vector(31 downto 0);
	working_mode                  : in  std_logic_vector(31 downto 0);
	rd                            : in  std_logic;
	wr                            : in  std_logic;
	out_error_state               : in  std_logic;
	loop_max_value                : in  std_logic_vector(31 downto 0);
	data_memory                   : in  std_logic_vector(31 downto 0);
   addr_memory                   : in  std_logic_vector(31 downto 0);
	readdata_memory               : out  std_logic_vector(31 downto 0);
	mask_output_enable_in         : in  std_logic_vector(31 downto 0);
	mask_trigger                  : in  std_logic_vector(31 downto 0);
	value_trigger_condition       : in  std_logic_vector(31 downto 0);
	done                          : out std_logic;
	error                         : out std_logic;
	pattern_out                   : out std_logic_vector(31 downto 0);
	mask_output_enable_out        : out std_logic_vector(31 downto 0)
	);
end Pattern_Generator;

architecture structure of Pattern_Generator is

signal     reset_from_cu_i                  :  std_logic;  
signal	  en_reg_divider_clock_i           :  std_logic;
signal	  en_reg_clk_sel_i                 :  std_logic;
signal	  enable_pattern_reg_i             :  std_logic;
signal     en_reg_mask_output_enable_i      :  std_logic;	
signal	  en_reg_mask_trigger_i            :  std_logic;
signal	  en_reg_mask_trigger_condition_i  :  std_logic;
signal	  enable_trigger_i                 :  std_logic;
signal	  en_reg_working_mode_i            :  std_logic;
signal	  en_reg_loop_max_register_i       :  std_logic;
signal	  enable_loop_counter_i            :  std_logic;
signal	  trigger_out_i                    :  std_logic;
signal	  working_mode_to_fsm_i            :  std_logic;
signal	  end_loop_reps_i                  :  std_logic; 
signal     terminal_count_clock_i           :  std_logic;
signal     error_flag_divider_zero_i        :  std_logic;
signal     reset_loop_i                     :  std_logic;
signal     en_reg_data_memory_i             :  std_logic;
signal	  en_reg_addr_memory_i             :  std_logic;
signal	  en_reg_data_read_memory_i        :  std_logic;
signal     start_i                          :  std_logic;
signal     en_reg_start_i                   :  std_logic;
signal     start_out_i                      :  std_logic;
signal     sel_addr_i                       :  std_logic;
signal     en_addr_management_i             :  std_logic;
signal     rd_i                             :  std_logic;
signal     wr_i                             :  std_logic;
signal     sel_data_read_i                  :  std_logic_vector(3 downto 0);
signal     reset_start_reg_i                :  std_logic;
signal     reset_addr_management_i          :  std_logic;

begin

CONTROL_UNITY : entity work.CU_Pattern_Generator
port map(
   Clock                           =>   clock,
   Reset                           =>   reset,
	start                           =>   start_out_i,
   stop                            =>   stop,
	error_flag_divider_zero         =>   error_flag_divider_zero_i,
	terminal_count_clock            =>   terminal_count_clock_i,
 	trigger_out                     =>   trigger_out_i,
	working_mode_to_fsm             =>   working_mode_to_fsm_i,
	setting                         =>   setting,
	reset_from_cu                   =>   reset_from_cu_i,
	done                            =>   done,
	rd                              =>   rd,
	wr                              =>   wr,
	error                           =>   error,
	reset_addr_management           =>   reset_addr_management_i,
	sel_data_read                   =>   sel_data_read_i,
	rd_from_fsm                     =>   rd_i,
	wr_from_fsm                     =>   wr_i,
   out_error_state                 =>   out_error_state,	
   en_reg_loop_max_register        =>   en_reg_loop_max_register_i,
	enable_loop_counter             =>   enable_loop_counter_i,
	end_loop_reps                   =>   end_loop_reps_i,	
	reset_loop                      =>   reset_loop_i,
	reset_start_reg                 =>   reset_start_reg_i,
	en_reg_divider_clock            =>   en_reg_divider_clock_i,
	en_reg_clk_sel                  =>   en_reg_clk_sel_i,
   enable_pattern_reg              =>   enable_pattern_reg_i,
   en_reg_mask_output_enable       =>   en_reg_mask_output_enable_i,
	en_reg_mask_trigger             =>   en_reg_mask_trigger_i,
   en_reg_mask_trigger_condition   =>   en_reg_mask_trigger_condition_i,
   enable_trigger                  =>   enable_trigger_i,
   en_reg_working_mode             =>   en_reg_working_mode_i,
	en_reg_start                    =>   en_reg_start_i,
	en_reg_data_memory              =>   en_reg_data_memory_i,
	en_reg_addr_memory              =>   en_reg_addr_memory_i,
	sel_addr                        =>   sel_addr_i,
	en_addr_management              =>   en_addr_management_i,
	en_reg_data_read_memory         =>   en_reg_data_read_memory_i);
	
DATAPATH : entity work.DP_Pattern_Generator
port map(
   clock                           =>   clock,
	reset                           =>   reset_from_cu_i,
	start                           =>   start,
	en_reg_start                    =>   en_reg_start_i,
	en_reg_divider_clock            =>   en_reg_divider_clock_i,
	clock_divider                   =>   clock_divider,
	en_reg_clk_sel                  =>   en_reg_clk_sel_i,
	external_clock                  =>   external_clock,
	sel_clk                         =>   sel_clk,
	enable_pattern_reg              =>   enable_pattern_reg_i,
   en_reg_mask_output_enable       =>   en_reg_mask_output_enable_i,
	en_reg_mask_trigger             =>   en_reg_mask_trigger_i,
	en_reg_mask_trigger_condition   =>   en_reg_mask_trigger_condition_i,
	enable_trigger                  =>   enable_trigger_i,
	en_reg_working_mode             =>   en_reg_working_mode_i,
	reset_addr_management           =>   reset_addr_management_i,
	sel_data_read                   =>   sel_data_read_i,
	working_mode                    =>   working_mode,
	en_reg_data_memory              =>   en_reg_data_memory_i,
	en_reg_addr_memory              =>   en_reg_addr_memory_i,
	en_reg_data_read_memory         =>   en_reg_data_read_memory_i,
	sel_addr                        =>   sel_addr_i,
	en_addr_management              =>   en_addr_management_i,
	rd_from_fsm                     =>   rd_i,
	wr_from_fsm                     =>   wr_i,
	reset_start_reg                 =>   reset_start_reg_i,
	data_memory                     =>   data_memory,
   addr_memory                     =>   addr_memory,
	mask_output_enable_in           =>   mask_output_enable_in,
	mask_trigger                    =>   mask_trigger,
	value_trigger_condition         =>   value_trigger_condition,
	readdata_memory                 =>   readdata_memory,
	start_out                       =>   start_out_i,
	error_flag_divider_zero         =>   error_flag_divider_zero_i,
	terminal_count_clock            =>   terminal_count_clock_i,
 	trigger_out                     =>   trigger_out_i,
	working_mode_to_fsm             =>   working_mode_to_fsm_i,
	pattern_out                     =>   pattern_out,
	en_reg_loop_max_register        =>   en_reg_loop_max_register_i,
	loop_max_value                  =>   loop_max_value,
	enable_loop_counter             =>   enable_loop_counter_i,
	end_loop_reps                   =>   end_loop_reps_i,
   reset_loop                      =>   reset_loop_i,
	mask_output_enable_out          =>   mask_output_enable_out);

end structure;
	  