library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity Logic_Register is
    Port (
        clock     : in  STD_LOGIC;
        reset   : in  STD_LOGIC;
        enable  : in  STD_LOGIC;
        data_in : in  STD_LOGIC;
        data_out: out STD_LOGIC
    );
end entity Logic_Register;

architecture Behavioral of Logic_Register is

signal reg_value : STD_LOGIC := '0';

begin

process (clock)
begin

    if (clock'event AND clock='1') then
        if reset = '1' then
            reg_value <= '0';
        elsif enable = '1' then
            reg_value <= data_in;
        end if;
    end if;
	 
end process;

data_out <= reg_value;

end architecture Behavioral;
