library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.ALL;

entity Integer_Register is
    Port (
        clock      : in  std_logic;    
        reset      : in  std_logic;    
        enable     : in  std_logic;    
        data_in    : in  integer;     
        data_out   : out integer  
    );
end entity Integer_Register;

architecture Behavioral of Integer_Register is

signal reg_value : integer := 0; 

begin

process (clock)
begin
    if (clock='1' AND clock'event) then
        if reset = '1' then
            reg_value <= 0;  
        elsif enable = '1' then
            reg_value <= data_in;
        end if;
    end if;
end process;

data_out <= reg_value;

end architecture Behavioral;
