library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity DP_Pattern_Generator is
port(
   clock                         : in  std_logic;
	reset                         : in  std_logic;
	start                         : in  std_logic_vector(31 downto 0);
	en_reg_start                  : in  std_logic;
	en_reg_divider_clock          : in  std_logic;
	clock_divider                 : in  std_logic_vector(31 downto 0);
	loop_max_value                : in  std_logic_vector(31 downto 0);
	en_reg_clk_sel                : in  std_logic;
	external_clock                : in  std_logic;
	sel_clk                       : in  std_logic_vector(31 downto 0);
	enable_pattern_reg            : in  std_logic;
   en_reg_mask_output_enable     : in  std_logic;	
	en_reg_mask_trigger           : in  std_logic;
	en_reg_mask_trigger_condition : in  std_logic;
	enable_trigger                : in  std_logic;
	en_reg_working_mode           : in  std_logic;
	reset_addr_management         : in  std_logic;
	working_mode                  : in  std_logic_vector(31 downto 0);
	en_reg_data_memory            : in  std_logic;
	en_reg_addr_memory            : in  std_logic;
	en_reg_data_read_memory       : in  std_logic;
	rd_from_fsm                   : in  std_logic;
	wr_from_fsm                   : in  std_logic;
	sel_addr                      : in  std_logic;
	en_addr_management            : in  std_logic;
	en_reg_loop_max_register      : in  std_logic;
	enable_loop_counter           : in  std_logic;
	reset_loop                    : in  std_logic;
	reset_start_reg               : in  std_logic;
	data_memory                   : in  std_logic_vector(31 downto 0);
   addr_memory                   : in  std_logic_vector(31 downto 0);	
	mask_output_enable_in         : in  std_logic_vector(31 downto 0);
	mask_trigger                  : in  std_logic_vector(31 downto 0);
	value_trigger_condition       : in  std_logic_vector(31 downto 0);
	sel_data_read                 : in  std_logic_vector(3 downto 0);
	readdata_memory               : out std_logic_vector(31 downto 0);
	end_loop_reps                 : out std_logic;
	start_out                     : out std_logic;
	error_flag_divider_zero       : out std_logic;
	terminal_count_clock          : out std_logic;
 	trigger_out                   : out std_logic;
	working_mode_to_fsm           : out std_logic;
	pattern_out                   : out std_logic_vector(31 downto 0);
	mask_output_enable_out        : out std_logic_vector(31 downto 0)

);
end DP_Pattern_Generator;

architecture structure of DP_Pattern_Generator is

signal start_i                   : std_logic;
signal clock_divider_i           : std_logic_vector(31 downto 0);
signal sel_clk_i                 : std_logic;
signal sel_clk_out_reg           : std_logic_vector(31 downto 0);
signal internal_clock_i          : std_logic;
signal clock_pattern_out_i       : std_logic;
signal mask_trigger_i            : std_logic_vector(31 downto 0); 
signal value_trigger_condition_i : std_logic_vector(31 downto 0);
signal addr_memory_i             : std_logic_vector(31 downto 0);
signal data_memory_i             : std_logic_vector(31 downto 0);
signal readdata_memory_i         : std_logic_vector(31 downto 0);
signal out_mux_readdata          : std_logic_vector(31 downto 0);
signal working_mode_to_fsm_i     : std_logic;
signal mask_output_enable_out_i  : std_logic_vector(31 downto 0);
signal start_out_i               : std_logic;
signal sel_clk_vector            : std_logic_vector(31 downto 0);
signal working_mode_vector       : std_logic_vector(31 downto 0);
signal start_out_vector          : std_logic_vector(31 downto 0);
signal new_addr_memory_i         : std_logic_vector(31 downto 0);
signal addr_used_i               : std_logic_vector(31 downto 0);
signal loop_max_value_i          : std_logic_vector(31 downto 0);
signal working_mode_out_reg      : std_logic_vector(31 downto 0);
signal start_out_reg             : std_logic_vector(31 downto 0);


begin

CLOCK_DIVIDER_REGISTER  : entity work.PIPO32bit 
    Port map (
        clock     => clock,
        reset     => reset,
        enable    => en_reg_divider_clock,
        data_in   => clock_divider,
        data_out  => clock_divider_i);
		  
CLOCK_GENERATOR : entity work.Clock_Generator
    port map(
        clk                     => clock,
        reset                   => reset,
		  DIVIDER                 => clock_divider_i,
		  error_flag_divider_zero => error_flag_divider_zero,
		  Terminal_count          => terminal_count_clock,
		  clock_out               => internal_clock_i);
		  
CLOCK_SELECTION_REGISTER : entity work.PIPO32bit		  
	 Port map (
        clock     => clock,
        reset     => reset,
        enable    => en_reg_clk_sel,
        data_in   => sel_clk,
        data_out  => sel_clk_out_reg);

sel_clk_i <= sel_clk_out_reg(0);	  

		  
MUX_CLK : entity work.mux_2_to_1
    Port map( 
	     a   => internal_clock_i,
        b   => external_clock,
        sel => sel_clk_i,
        y   => clock_pattern_out_i);
		  
PATTERN_OUT_REGISTER : entity work.PIPO32bit
    Port  map(
        clock    => clock_pattern_out_i,
	     reset    => reset,
        enable   => enable_pattern_reg,
        data_in  => readdata_memory_i,
        data_out => pattern_out);	
	
OUTPUT_ENABLE_MASK_REGISTER : entity work.PIPO32bit    
    Port map(
        clock     => clock,
        reset     => reset,
        enable    => en_reg_mask_output_enable,
        data_in   => mask_output_enable_in,
        data_out  => mask_output_enable_out_i);
		 
mask_output_enable_out <= mask_output_enable_out_i; 

TRIGGER_MASK_REGISTER : entity work.PIPO32bit
    Port map(
        clock     => clock,
        reset     => reset,
        enable    => en_reg_mask_trigger,
        data_in   => mask_trigger,
        data_out  => mask_trigger_i);
		  
TRIGGER_CONDITION_REGISTER : entity work.PIPO32bit
    Port map(
        clock     => clock,
        reset     => reset,
        enable    => en_reg_mask_trigger_condition,
        data_in   => value_trigger_condition,
        data_out  => value_trigger_condition_i);
		  
TRIGGER_MANAGEMENT : entity work.TRIGGER 
    Port map(
        clock                    => clock,
        enable                   => enable_trigger,
		  mask_in                  => mask_trigger_i,
		  data_in                  => readdata_memory_i,
		  value_trigger_condition  => value_trigger_condition_i,
		  trigger_out              => trigger_out);
		  
LOOP_MAX_SEQUENCE_REGISTER  : entity work.PIPO32bit 
    Port map(
        clock     => clock,
        reset     => reset,
        enable    => en_reg_loop_max_register,
        data_in   => loop_max_value,
        data_out  => loop_max_value_i);
		  
LOOP_MANAGEMENT: entity work.Loop_Management
    port map (
        clock      => clock,
        reset      => reset_loop,
        enable_cnt => enable_loop_counter,
	     Max_Rep    => loop_max_value_i,
	     End_Loop   => end_loop_reps);	
		  
WORKING_MODE_REGISTER : entity work.PIPO32bit		  
	 Port map (
        clock     => clock,
        reset     => reset,
        enable    => en_reg_working_mode,
        data_in   => working_mode,
        data_out  => working_mode_out_reg);
		  
working_mode_to_fsm_i <= working_mode_out_reg(0);
working_mode_to_fsm <= working_mode_to_fsm_i;  
	
ADDR_MEMORY_REGISTER : entity work.PIPO32bit
    Port map(
        clock     => clock,
        reset     => reset,
        enable    => en_reg_addr_memory,
        data_in   => addr_memory,
        data_out  => addr_memory_i);
		  
MUX_ADDR : entity work.mux_2_to_1_vector
    Port map( 
	     a   => addr_memory_i,
        b   => new_addr_memory_i,
        sel => sel_addr,
        y   => addr_used_i);
	
ADDR_MEMORY_MANAGEMENT : entity work.ADDR_Manager 
    port map(
        clock         => clock,
		  reset         => reset_addr_management,
	     enable_adder  => en_addr_management,
	     address_in    => addr_used_i,
	     address_out   => new_addr_memory_i
	);	
		  
DATA_MEMORY_REGISTER : entity work.PIPO32bit
    Port map(
        clock     => clock,
        reset     => reset,
        enable    => en_reg_data_memory,
        data_in   => data_memory,
        data_out  => data_memory_i);	
		  
DATA_READ_MEMORY_REGISTER : entity work.PIPO32bit
    Port map(
        clock     => clock,
        reset     => reset,
        enable    => en_reg_data_read_memory,
        data_in   => out_mux_readdata,
        data_out  => readdata_memory);	
		  
--		  sel_clk_vector <= (0 => sel_clk_i, OTHERS =>'0'); 
--		  working_mode_vector <= (0 => working_mode_to_fsm_i, OTHERS => '0');
--		  start_out_vector <= (0 => start_out_i, OTHERS =>'0'); 
		  
--mettere mux con le uscite di tutti i registri, compresa la memoria
MUX_READ_DATA : entity work.mux_16_to_1
    Port map (
        in_a   => (others => '0'),
        in_b   => clock_divider_i,
        in_c   => sel_clk_out_reg,
        in_d   => addr_memory_i,
        in_e   => data_memory_i,
        in_f   => mask_trigger_i,
        in_g   => value_trigger_condition_i,
        in_h   => start_out_reg,
        in_i   => working_mode_out_reg,
        in_j   => mask_output_enable_out_i,
        in_k   => loop_max_value_i,
        in_l   => readdata_memory_i,
        in_m   => (others => '0'),
        in_n   => (others => '0'),
        in_o   => (others => '0'),
        in_p   => (others => '0'),
        sel    => sel_data_read,
        out_y  => out_mux_readdata
    );
	 
RAM_MEMORY : entity work.memory 
	port map (
		Clock     => clock,
		reset     => reset,
		RD        => rd_from_fsm,
		WR        => wr_from_fsm,
		address   => addr_used_i(7 downto 0),
		data_in   => data_memory_i,
		data_out  => readdata_memory_i
	);	  
		  
START_REGISTER : entity work.PIPO32bit		  
	 Port map (
        clock     => clock,
        reset     => reset_start_reg,
        enable    => en_reg_start,
        data_in   => start,
        data_out  => start_out_reg);
		  
		  start_out <= start_out_reg(0);

end structure;